/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class ExtensionPointImpl<T>
implements ExtensionPoint<T>,
Iterable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    @Nullable
    private volatile T[] myExtensionsCacheAsArray;
    final MutablePicoContainer myPicoContainer;
    private final PluginDescriptor myDescriptor;
    @NotNull
    protected List<ExtensionComponentAdapter> myAdapters;
    @NotNull
    private ExtensionPointListener<T>[] myListeners;
    @Nullable
    Class<T> myExtensionClass;
    private boolean processingAdaptersNow;
    private static final ArrayFactory<ExtensionPointListener> LISTENER_ARRAY_FACTORY;
    static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull MutablePicoContainer picoContainer, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (picoContainer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.myAdapters = Collections.emptyList();
        this.myListeners = ExtensionPointListener.EMPTY_ARRAY;
        this.myName = name;
        this.myClassName = className;
        this.myPicoContainer = picoContainer;
        this.myDescriptor = pluginDescriptor;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, null);
    }

    @Override
    public void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(7);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(8);
        }
        this.doRegisterExtension(extension, order, null);
    }

    @Override
    public void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, parentDisposable);
    }

    @NotNull
    final PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        return pluginDescriptor;
    }

    @Override
    public synchronized void registerExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(14);
        }
        this.doRegisterExtension(extension, order, parentDisposable);
    }

    private synchronized void doRegisterExtension(@NotNull T extension, @NotNull LoadingOrder order, @Nullable Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ExtensionPointImpl.castComponentInstance(adapter) != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order);
        this.addExtensionAdapter(adapter);
        this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor(), this.myListeners);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    List<ExtensionComponentAdapter> list = this.myAdapters;
                    int index = ContainerUtil.indexOfIdentity(list, (Object)adapter);
                    if (index < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.myComponentInstance);
                    }
                    list.remove(index);
                    this.clearCache();
                    this.notifyListenersOnRemove(adapter.myComponentInstance, adapter.getPluginDescriptor(), this.myListeners);
                }
            });
        }
    }

    public synchronized void registerExtensions(@NotNull List<? extends T> extensions) {
        if (extensions == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            Object instance;
            if (!(adapter instanceof ObjectComponentAdapter) || !ContainerUtil.containsIdentity(extensions, instance = ExtensionPointImpl.castComponentInstance(adapter))) continue;
            LOG.error("Extension was already added: " + instance);
            return;
        }
        int firstIndex = this.findInsertionIndexForAnyOrder();
        if (this.myAdapters == Collections.emptyList()) {
            this.myAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        int index = firstIndex;
        for (Object extension : extensions) {
            this.myAdapters.add(index++, new ObjectComponentAdapter(extension, LoadingOrder.ANY));
        }
        this.clearCache();
        for (int i = firstIndex; i < index; ++i) {
            this.notifyListenersOnAdd(ExtensionPointImpl.castComponentInstance(this.myAdapters.get(i)), null, this.myListeners);
        }
    }

    private synchronized int findInsertionIndexForAnyOrder() {
        ExtensionComponentAdapter lastAdapter;
        int index;
        for (index = this.myAdapters.size(); index > 0 && (lastAdapter = this.myAdapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
        }
        return index;
    }

    private synchronized void checkExtensionType(@NotNull T extension, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        if (!extensionClass.isInstance(extension)) {
            String message = "Extension " + extension.getClass() + " does not implement " + extensionClass;
            if (adapter != null) {
                message = message + ". It came from " + adapter;
            }
            throw new RuntimeException(message);
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, @Nullable PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(21);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<T> getExtensionList() {
        ImmutableList result = this.myExtensionsCache;
        if (result == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result = this.myExtensionsCache;
                if (result == null) {
                    Object[] array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = result = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList((Object[])array);
                }
            }
        }
        ImmutableList immutableList = result;
        if (immutableList == null) {
            ExtensionPointImpl.$$$reportNull$$$0(22);
        }
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] array = this.myExtensionsCacheAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList((Object[])array);
                }
            }
        }
        Object[] objectArray = array.length == 0 ? array : (Object[])array.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        return objectArray;
    }

    @Override
    public void forEachExtensionSafe(Consumer<T> extensionConsumer) {
        for (T t : this) {
            if (t == null) break;
            try {
                extensionConsumer.accept(t);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @ApiStatus.Experimental
    @NotNull
    public final Iterator<T> iterator() {
        List<T> result = this.myExtensionsCache;
        if (result == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result = this.myExtensionsCache;
                if (result == null) {
                    Iterator<T> iterator = this.createIterator();
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (iterator == null) {
                        ExtensionPointImpl.$$$reportNull$$$0(24);
                    }
                    return iterator;
                }
            }
        }
        Iterator<T> iterator = result.iterator();
        if (iterator == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        return iterator;
    }

    public void processWithPluginDescriptor(@NotNull BiConsumer<T, PluginDescriptor> consumer) {
        ExtensionComponentAdapter adapter;
        T extension;
        if (consumer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(26);
        }
        this.assertBeforeProcessing();
        CHECK_CANCELED.run();
        if (this.isInReadOnlyMode()) {
            for (T extension2 : this.myExtensionsCache) {
                consumer.accept(extension2, this.myDescriptor);
            }
            return;
        }
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        int size = adapters.size();
        if (size == 0) {
            return;
        }
        LoadingOrder.sort(adapters);
        LOG.assertTrue(this.myListeners.length == 0);
        int currentIndex = 0;
        while ((extension = this.processAdapter(adapter = adapters.get(currentIndex++), null, null, null, null)) != null) {
            consumer.accept(extension, adapter.getPluginDescriptor());
            if (currentIndex < size) continue;
        }
    }

    @NotNull
    private synchronized Iterator<T> createIterator() {
        this.assertBeforeProcessing();
        CHECK_CANCELED.run();
        final List<ExtensionComponentAdapter> adapters = this.myAdapters;
        final int size = adapters.size();
        if (size == 0) {
            Iterator iterator = Collections.emptyIterator();
            if (iterator == null) {
                ExtensionPointImpl.$$$reportNull$$$0(27);
            }
            return iterator;
        }
        LoadingOrder.sort(adapters);
        LOG.assertTrue(this.myListeners.length == 0);
        Iterator iterator = new Iterator<T>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension;
                    if ((extension = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++), null, null, null, null)) == null) continue;
                    return extension;
                } while (this.hasNext());
                return null;
            }
        };
        if (iterator == null) {
            ExtensionPointImpl.$$$reportNull$$$0(28);
        }
        return iterator;
    }

    @Override
    @NotNull
    public Stream<T> extensions() {
        Stream stream = this.getExtensionList().stream();
        if (stream == null) {
            ExtensionPointImpl.$$$reportNull$$$0(29);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        List<T> cache = this.myExtensionsCache;
        if (cache != null) {
            return !cache.isEmpty();
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return !this.myAdapters.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private synchronized T[] processAdapters() {
        Object[] objectArray;
        block7: {
            this.assertBeforeProcessing();
            this.assertNotReadOnlyMode();
            long startTime = StartUpMeasurer.getCurrentTime();
            int totalSize = this.myAdapters.size();
            Class<T> extensionClass = this.getExtensionClass();
            Object[] result = ArrayUtil.newArray(extensionClass, (int)totalSize);
            if (totalSize == 0) {
                if (result == null) {
                    ExtensionPointImpl.$$$reportNull$$$0(30);
                }
                return result;
            }
            CHECK_CANCELED.run();
            this.processingAdaptersNow = true;
            List<ExtensionComponentAdapter> adapters = this.myAdapters;
            LoadingOrder.sort(adapters);
            OpenTHashSet duplicates = this instanceof BeanExtensionPoint ? null : new OpenTHashSet(adapters.size());
            ExtensionPointListener<T>[] listeners = this.myListeners;
            int extensionIndex = 0;
            for (int i = 0; i < adapters.size(); ++i) {
                Object extension = this.processAdapter(adapters.get(i), listeners, result, duplicates, extensionClass);
                if (extension == null) continue;
                result[extensionIndex++] = extension;
            }
            if (extensionIndex != result.length) {
                result = Arrays.copyOf(result, extensionIndex);
            }
            ParallelActivity.EXTENSION.record(startTime, extensionClass, DefaultPicoContainer.getActivityLevel((PicoContainer)this.myPicoContainer));
            objectArray = result;
            if (objectArray != null) break block7;
            ExtensionPointImpl.$$$reportNull$$$0(31);
        }
        return objectArray;
        finally {
            this.processingAdaptersNow = false;
        }
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, @Nullable ExtensionPointListener<T>[] listeners, @Nullable T[] result, @Nullable OpenTHashSet<T> duplicates, @Nullable Class<T> extensionClassForCheck) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(32);
        }
        try {
            Object duplicate;
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated();
            Object extension = adapter.createInstance((PicoContainer)this.myPicoContainer);
            if (duplicates != null && !duplicates.add(extension)) {
                duplicate = duplicates.get(extension);
                assert (result != null);
            } else {
                if (extensionClassForCheck != null) {
                    this.checkExtensionType(extension, extensionClassForCheck, adapter);
                }
                if (isNotifyThatAdded) {
                    this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor(), listeners);
                }
                return (T)extension;
            }
            LOG.error("Duplicate extension found:\n                   " + extension + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result) + ";\n  adapters:        " + this.myAdapters);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    private void assertBeforeProcessing() {
        if (this.processingAdaptersNow) {
            throw new IllegalStateException("Recursive processAdapters() detected. You must have called 'getExtensions()' from within your extension constructor - don't. Either pass extension via constructor parameter or call getExtensions() later.");
        }
    }

    public synchronized void removeUnloadableExtensions() {
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            try {
                adapter.getImplementationClass();
                continue;
            }
            catch (Throwable e) {
                this.removeAdapter(adapter, i);
                this.clearCache();
            }
        }
    }

    @Override
    @Nullable
    public T getExtension() {
        List<T> extensions = this.getExtensionList();
        return extensions.isEmpty() ? null : (T)extensions.get(0);
    }

    @Override
    public synchronized boolean hasExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(33);
        }
        return ContainerUtil.containsIdentity(this.getExtensionList(), extension);
    }

    public synchronized void maskAll(final @NotNull List<T> list, @NotNull Disposable parentDisposable) {
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(34);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(35);
        }
        if (POINTS_IN_READONLY_MODE == null) {
            POINTS_IN_READONLY_MODE = ContainerUtil.newIdentityTroveSet();
        } else {
            this.assertNotReadOnlyMode();
        }
        final List<T> oldList = this.myExtensionsCache;
        final Object[] oldArray = this.myExtensionsCacheAsArray;
        this.myExtensionsCache = list;
        this.myExtensionsCacheAsArray = list.toArray(ArrayUtil.newArray(this.getExtensionClass(), (int)0));
        POINTS_IN_READONLY_MODE.add(this);
        if (this.myListeners.length > 0) {
            if (oldList != null) {
                for (Object object : oldList) {
                    this.notifyListenersOnRemove(object, null, this.myListeners);
                }
            }
            for (Object object : list) {
                this.notifyListenersOnAdd(object, null, this.myListeners);
            }
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    POINTS_IN_READONLY_MODE.remove(ExtensionPointImpl.this);
                    ExtensionPointImpl.this.myExtensionsCache = oldList;
                    ExtensionPointImpl.access$402(ExtensionPointImpl.this, oldArray);
                    for (Object extension : list) {
                        ExtensionPointImpl.this.notifyListenersOnRemove(extension, null, ExtensionPointImpl.this.myListeners);
                    }
                    if (oldList != null) {
                        for (Object extension : oldList) {
                            ExtensionPointImpl.this.notifyListenersOnAdd(extension, null, ExtensionPointImpl.this.myListeners);
                        }
                    }
                }
            }
        });
    }

    @Override
    public synchronized void unregisterExtensions(@NotNull Predicate<? super T> filter) {
        if (filter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        List<T> extensions = this.getExtensionList();
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        ExtensionPointListener<T>[] listeners = this.myListeners;
        ArrayList<Pair> removed = listeners.length == 0 ? null : new ArrayList<Pair>();
        for (int i = adapters.size() - 1; i >= 0; --i) {
            T extension = extensions.get(i);
            if (filter.test(extension)) continue;
            ExtensionComponentAdapter adapter = adapters.remove(i);
            if (removed == null) continue;
            removed.add(new Pair(extension, (Object)adapter.getPluginDescriptor()));
        }
        this.clearCache();
        if (removed != null) {
            for (Pair pair : removed) {
                this.notifyListenersOnRemove(pair.first, (PluginDescriptor)pair.second, listeners);
            }
        }
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        T[] extensions = this.myExtensionsCacheAsArray;
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = 0; i < adapters.size(); ++i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            if (adapter instanceof ObjectComponentAdapter ? ExtensionPointImpl.castComponentInstance(adapter) != extension : extensions == null || extensions[i] != extension) continue;
            adapters.remove(i);
            this.clearCache();
            this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), this.myListeners);
            return;
        }
        LOG.warn("Extension to be removed not found: " + extension);
    }

    @Override
    public void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister;
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(38);
        }
        if (!this.unregisterExtensions((arg_0, arg_1) -> ExtensionPointImpl.lambda$unregisterExtension$1(classNameToUnregister = extensionClass.getCanonicalName(), arg_0, arg_1), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    @Override
    public synchronized boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(39);
        }
        boolean found = false;
        for (int i = this.myAdapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = this.myAdapters.get(i);
            if (extensionClassFilter.test(adapter.getAssignableToClassName(), adapter)) continue;
            this.removeAdapter(adapter, i);
            this.clearCache();
            if (stopAfterFirstMatch) {
                return true;
            }
            found = true;
        }
        return found;
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, @Nullable PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extensionObject == null) {
            ExtensionPointImpl.$$$reportNull$$$0(40);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(41);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(42);
        }
        if (invokeForLoadedExtensions) {
            this.addExtensionPointListener(listener);
        } else {
            this.addListener(listener);
        }
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        return LISTENER_ARRAY_FACTORY;
    }

    private synchronized boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if (ArrayUtil.indexOf((Object[])this.myListeners, listener) != -1) {
            return false;
        }
        this.myListeners = (ExtensionPointListener[])ArrayUtil.append((Object[])this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    private synchronized void removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(44);
        }
        this.myListeners = (ExtensionPointListener[])ArrayUtil.remove((Object[])this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(45);
        }
        this.getExtensionList();
        if (this.addListener(listener)) {
            this.notifyListenersAboutLoadedExtensions(this.myAdapters, listener, false);
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(46);
        }
        this.removeListener(listener);
    }

    @Override
    public synchronized void reset() {
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        this.myAdapters = Collections.emptyList();
        this.notifyListenersAboutLoadedExtensions(adapters, null, true);
        this.clearCache();
    }

    private static <T> T castComponentInstance(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(47);
        }
        return (T)((ObjectComponentAdapter)adapter).myComponentInstance;
    }

    private synchronized void notifyListenersAboutLoadedExtensions(@NotNull List<? extends ExtensionComponentAdapter> loadedAdapters, @Nullable ExtensionPointListener<T> onlyListener, boolean isRemoved) {
        ExtensionPointListener<T>[] listeners;
        if (loadedAdapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(48);
        }
        if ((listeners = this.myListeners).length == 0) {
            return;
        }
        T[] extensions = this.myExtensionsCacheAsArray;
        int size = loadedAdapters.size();
        for (int i = 0; i < size; ++i) {
            T extension;
            ExtensionComponentAdapter adapter = loadedAdapters.get(i);
            if (adapter instanceof ObjectComponentAdapter) {
                extension = ExtensionPointImpl.castComponentInstance(adapter);
            } else {
                if (extensions == null) continue;
                extension = extensions[i];
            }
            if (isRemoved) {
                if (onlyListener == null) {
                    this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), listeners);
                    continue;
                }
                onlyListener.extensionRemoved(extension, adapter.getPluginDescriptor());
                continue;
            }
            if (onlyListener == null) {
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor(), listeners);
                continue;
            }
            onlyListener.extensionAdded(extension, adapter.getPluginDescriptor());
        }
    }

    @Override
    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(49);
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(50);
        }
        if (this.myAdapters == Collections.emptyList()) {
            this.myAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myAdapters.add(adapter);
        this.clearCache();
    }

    synchronized void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    private synchronized void removeAdapter(@NotNull ExtensionComponentAdapter adapter, int index) {
        T extensionInstance;
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(51);
        }
        if (adapter instanceof ComponentAdapter) {
            this.myPicoContainer.unregisterComponent(((ComponentAdapter)adapter).getComponentKey());
        }
        this.myAdapters.remove(index);
        if (adapter instanceof ObjectComponentAdapter) {
            extensionInstance = ExtensionPointImpl.castComponentInstance(adapter);
        } else {
            T[] array = this.myExtensionsCacheAsArray;
            if (array == null) {
                return;
            }
            extensionInstance = array[index];
        }
        this.notifyListenersOnRemove(extensionInstance, adapter.getPluginDescriptor(), this.myListeners);
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element var1, @NotNull PluginDescriptor var2, @NotNull MutablePicoContainer var3);

    void createAndRegisterAdapter(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor, @NotNull MutablePicoContainer picoContainer) {
        if (extensionElement == null) {
            ExtensionPointImpl.$$$reportNull$$$0(52);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(53);
        }
        if (picoContainer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(54);
        }
        this.addExtensionAdapter(this.createAdapterAndRegisterInPicoContainerIfNeeded(extensionElement, pluginDescriptor, picoContainer));
    }

    public final synchronized void createAndRegisterAdapters(@NotNull Collection<? extends Element> extensionElements, @NotNull PluginDescriptor pluginDescriptor, @NotNull MutablePicoContainer picoContainer) {
        if (extensionElements == null) {
            ExtensionPointImpl.$$$reportNull$$$0(55);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(56);
        }
        if (picoContainer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(57);
        }
        if (extensionElements.isEmpty()) {
            return;
        }
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        if (adapters == Collections.emptyList()) {
            this.myAdapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        for (Element element : extensionElements) {
            adapters.add(this.createAdapterAndRegisterInPicoContainerIfNeeded(element, pluginDescriptor, picoContainer));
        }
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(58);
        }
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    @Nullable
    public synchronized T findExtension(@NotNull Class<T> instanceOf, boolean isRequired) {
        Iterator<T> iterator;
        if (instanceOf == null) {
            ExtensionPointImpl.$$$reportNull$$$0(59);
        }
        Iterator<T> iterator2 = iterator = this.myListeners.length == 0 ? this.iterator() : this.getExtensionList().iterator();
        while (iterator.hasNext()) {
            T object = iterator.next();
            if (object == null || !instanceOf.isInstance(object)) continue;
            return object;
        }
        if (isRequired) {
            String message = "could not find extension implementation " + instanceOf;
            if (this.isInReadOnlyMode()) {
                message = message + " (point in read-only mode)";
            }
            throw new IllegalArgumentException(message);
        }
        return null;
    }

    protected synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    public static void setCheckCanceledAction(@NotNull Runnable checkCanceled) {
        if (checkCanceled == null) {
            ExtensionPointImpl.$$$reportNull$$$0(60);
        }
        CHECK_CANCELED = () -> {
            block2: {
                try {
                    checkCanceled.run();
                }
                catch (ProcessCanceledException e) {
                    if (ExtensionPointImpl.isInsideClassInitializer(e.getStackTrace())) break block2;
                    throw e;
                }
            }
        };
    }

    private static boolean isInsideClassInitializer(@NotNull StackTraceElement[] trace) {
        if (trace == null) {
            ExtensionPointImpl.$$$reportNull$$$0(61);
        }
        return Arrays.stream(trace).anyMatch(s -> "<clinit>".equals(s.getMethodName()));
    }

    private static /* synthetic */ boolean lambda$unregisterExtension$1(String classNameToUnregister, String className, ExtensionComponentAdapter adapter) {
        return !className.equals(classNameToUnregister);
    }

    static /* synthetic */ Object[] access$402(ExtensionPointImpl x0, Object[] x1) {
        x0.myExtensionsCacheAsArray = x1;
        return x1;
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 3: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 14: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 19: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 21: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 32: 
            case 47: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassFilter";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedAdapters";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElements";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkCanceled";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 49: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtension";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkExtensionType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnAdd";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processWithPluginDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processAdapter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasExtension";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 36: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnRemove";
                break;
            }
            case 42: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "castComponentInstance";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersAboutLoadedExtensions";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionAdapter";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "removeAdapter";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapter";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapters";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "setCheckCanceledAction";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isInsideClassInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        private final T myComponentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            super(extension.getClass().getName(), null, null, loadingOrder);
            this.myComponentInstance = extension;
        }

        @Override
        boolean isInstanceCreated() {
            return true;
        }

        @NotNull
        public T createInstance(@Nullable PicoContainer container) {
            T t = this.myComponentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

