/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public class JBHtmlEditorKit
extends HTMLEditorKit {
    private final StyleSheet style = JBHtmlEditorKit.createStyleSheet();
    private final HyperlinkListener myHyperlinkListener;

    @Override
    public Cursor getDefaultCursor() {
        return null;
    }

    public JBHtmlEditorKit() {
        this(true);
    }

    public JBHtmlEditorKit(boolean noGapsBetweenParagraphs) {
        if (noGapsBetweenParagraphs) {
            this.style.addRule("p { margin-top: 0; }");
        }
        this.myHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Element element = e.getSourceElement();
                if (element == null) {
                    return;
                }
                if (element.getName().equals("img")) {
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    this.setUnderlined(true, element);
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    this.setUnderlined(false, element);
                }
            }

            private void setUnderlined(boolean underlined, @NotNull Element element) {
                AttributeSet attributes;
                Object attribute;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((attribute = (attributes = element.getAttributes()).getAttribute(HTML.Tag.A)) instanceof MutableAttributeSet) {
                    MutableAttributeSet a = (MutableAttributeSet)attribute;
                    a.addAttribute(CSS.Attribute.TEXT_DECORATION, underlined ? "underline" : "none");
                    ((StyledDocument)element.getDocument()).setCharacterAttributes(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), a, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/ui/JBHtmlEditorKit$1", "setUnderlined"));
            }
        };
    }

    @Override
    public StyleSheet getStyleSheet() {
        return this.style;
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        StyleSheetCompressionThreshold ss = new StyleSheetCompressionThreshold();
        ss.addStyleSheet(styles);
        HTMLDocument doc = new HTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    public static StyleSheet createStyleSheet() {
        StyleSheet style = new StyleSheet();
        style.addStyleSheet(StartupUiUtil.isUnderDarcula() ? (StyleSheet)UIManager.getDefaults().get("StyledEditorKit.JBDefaultStyle") : StartupUiUtil.getDefaultHtmlKitCss());
        style.addRule("code { font-size: 100%; }");
        style.addRule("small { font-size: small; }");
        style.addRule("a { text-decoration: none;}");
        style.addRule("ul { margin-left-ltr: 10; margin-right-rtl: 10; }");
        style.addRule("ol { margin-left-ltr: 22; margin-right-rtl: 22; }");
        return style;
    }

    @Override
    public void install(final JEditorPane pane) {
        super.install(pane);
        pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                pane.removePropertyChangeListener(this);
            }
        });
        pane.addHyperlinkListener(this.myHyperlinkListener);
        List<HTMLEditorKit.LinkController> listeners1 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseListeners());
        List<HTMLEditorKit.LinkController> listeners2 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseMotionListeners());
        if (listeners1.size() == 1 && listeners1.equals(listeners2)) {
            HTMLEditorKit.LinkController oldLinkController = listeners1.get(0);
            pane.removeMouseListener(oldLinkController);
            pane.removeMouseMotionListener(oldLinkController);
            MouseExitSupportLinkController newLinkController = new MouseExitSupportLinkController();
            pane.addMouseListener(newLinkController);
            pane.addMouseMotionListener(newLinkController);
        }
    }

    @NotNull
    private static List<HTMLEditorKit.LinkController> filterLinkControllerListeners(@NotNull Object[] listeners) {
        if (listeners == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.mapNotNull((Object[])listeners, o -> (HTMLEditorKit.LinkController)ObjectUtils.tryCast((Object)o, HTMLEditorKit.LinkController.class));
        if (list == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void deinstall(@NotNull JEditorPane c) {
        if (c == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(2);
        }
        c.removeHyperlinkListener(this.myHyperlinkListener);
        super.deinstall(c);
    }

    static {
        StartupUiUtil.configureHtmlKitStylesheet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLinkControllerListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterLinkControllerListeners";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deinstall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MouseExitSupportLinkController
    extends HTMLEditorKit.LinkController {
        private MouseExitSupportLinkController() {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MouseExitSupportLinkController.$$$reportNull$$$0(0);
            }
            this.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), -1, -1, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/JBHtmlEditorKit$MouseExitSupportLinkController", "mouseExited"));
        }
    }

    private static class StyleSheetCompressionThreshold
    extends StyleSheet {
        private StyleSheetCompressionThreshold() {
        }

        @Override
        protected int getCompressionThreshold() {
            return -1;
        }
    }
}

