/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.ui.svg.SaxDocumentFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVG12DOMImplementation;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.util.ParsedURL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/svg/SaxSvgDocumentFactory;", "Lcom/intellij/ui/svg/SaxDocumentFactory;", "()V", "createDocument", "Lorg/w3c/dom/Document;", "uri", "", "inputStream", "Ljava/io/InputStream;", "getDOMImplementation", "Lorg/w3c/dom/DOMImplementation;", "ver", "resolveEntity", "Lorg/xml/sax/InputSource;", "publicId", "systemId", "Companion", "intellij.platform.util.ui"})
public final class SaxSvgDocumentFactory
extends SaxDocumentFactory {
    private static final Object LOCK;
    private static final String KEY_PUBLIC_IDS = "publicIds";
    private static final String KEY_SKIPPABLE_PUBLIC_IDS = "skippablePublicIds";
    private static final String KEY_SKIP_DTD = "skipDTD";
    private static final String KEY_SYSTEM_ID = "systemId.";
    private static String dtdIds;
    private static String skippableDtdIds;
    private static String skip_dtd;
    private static Properties dtdProps;
    public static final Companion Companion;

    @Override
    @NotNull
    public Document createDocument(@Nullable String uri, @NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uri);
        Document doc = super.createDocument("http://www.w3.org/2000/svg", "svg", inputSource);
        if (uri != null) {
            Document document = doc;
            if (document == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.batik.anim.dom.SVGOMDocument");
            }
            ((SVGOMDocument)document).setParsedURL(new ParsedURL(uri));
        }
        Document document = doc;
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.batik.dom.AbstractDocument");
        }
        AbstractDocument d = (AbstractDocument)document;
        d.setDocumentURI(uri);
        d.setXmlStandalone(this.isStandalone());
        d.setXmlVersion(this.getXmlVersion());
        return doc;
    }

    @Override
    @NotNull
    public DOMImplementation getDOMImplementation(@Nullable String ver) {
        block5: {
            block4: {
                if (ver == null) break block4;
                CharSequence charSequence = ver;
                boolean bl = false;
                if (!(charSequence.length() == 0) && !Intrinsics.areEqual((Object)ver, (Object)"1.0") && !Intrinsics.areEqual((Object)ver, (Object)"1.1")) break block5;
            }
            DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
            Intrinsics.checkExpressionValueIsNotNull((Object)dOMImplementation, (String)"SVGDOMImplementation.getDOMImplementation()");
            return dOMImplementation;
        }
        if (Intrinsics.areEqual((Object)ver, (Object)"1.2")) {
            DOMImplementation dOMImplementation = SVG12DOMImplementation.getDOMImplementation();
            Intrinsics.checkExpressionValueIsNotNull((Object)dOMImplementation, (String)"SVG12DOMImplementation.getDOMImplementation()");
            return dOMImplementation;
        }
        throw (Throwable)new RuntimeException("Unsupported SVG version '" + ver + '\'');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputSource resolveEntity(@Nullable String publicId, @Nullable String systemId) {
        Object object = LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (dtdProps == null) {
                dtdProps = new Properties();
                try {
                    Class<SAXSVGDocumentFactory> cls = SAXSVGDocumentFactory.class;
                    InputStream is = cls.getResourceAsStream("resources/dtdids.properties");
                    Properties properties = dtdProps;
                    if (properties == null) {
                        Intrinsics.throwNpe();
                    }
                    properties.load(is);
                }
                catch (IOException ioe) {
                    throw (Throwable)new SAXException(ioe);
                }
            }
            if (dtdIds == null) {
                Properties properties = dtdProps;
                if (properties == null) {
                    Intrinsics.throwNpe();
                }
                dtdIds = properties.getProperty(KEY_PUBLIC_IDS);
            }
            if (skippableDtdIds == null) {
                Properties properties = dtdProps;
                if (properties == null) {
                    Intrinsics.throwNpe();
                }
                skippableDtdIds = properties.getProperty(KEY_SKIPPABLE_PUBLIC_IDS);
            }
            if (skip_dtd == null) {
                Properties properties = dtdProps;
                if (properties == null) {
                    Intrinsics.throwNpe();
                }
                skip_dtd = properties.getProperty(KEY_SKIP_DTD);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (publicId == null) {
            return null;
        }
        String string = skippableDtdIds;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.indexOf$default((CharSequence)string, (String)publicId, (int)0, (boolean)false, (int)6, null) != -1) {
            String string2 = skip_dtd;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            return new InputSource(new StringReader(string2));
        }
        String string3 = dtdIds;
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.indexOf$default((CharSequence)string3, (String)publicId, (int)0, (boolean)false, (int)6, null) != -1) {
            String localSystemId;
            Properties properties = dtdProps;
            if (properties == null) {
                Intrinsics.throwNpe();
            }
            if ((localSystemId = properties.getProperty(KEY_SYSTEM_ID + StringsKt.replace$default((String)publicId, (char)' ', (char)'_', (boolean)false, (int)4, null))) != null && Intrinsics.areEqual((Object)"", (Object)localSystemId) ^ true) {
                return new InputSource(this.getClass().getResource(localSystemId).toString());
            }
        }
        return null;
    }

    public SaxSvgDocumentFactory() {
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        Intrinsics.checkExpressionValueIsNotNull((Object)dOMImplementation, (String)"SVGDOMImplementation.getDOMImplementation()");
        super(dOMImplementation);
    }

    static {
        Companion = new Companion(null);
        LOCK = new Object();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/svg/SaxSvgDocumentFactory$Companion;", "", "()V", "KEY_PUBLIC_IDS", "", "KEY_SKIPPABLE_PUBLIC_IDS", "KEY_SKIP_DTD", "KEY_SYSTEM_ID", "LOCK", "dtdIds", "dtdProps", "Ljava/util/Properties;", "skip_dtd", "skippableDtdIds", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

