/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePoint {
    @NotNull
    private final Component myComponent;
    @NotNull
    private final Point myPointOnComponent;
    @NotNull
    private final Component myOriginalComponent;
    @NotNull
    private final Point myOriginalPoint;

    public RelativePoint(@NotNull MouseEvent event) {
        if (event == null) {
            RelativePoint.$$$reportNull$$$0(0);
        }
        this(event.getComponent(), event.getPoint());
    }

    public RelativePoint(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            RelativePoint.$$$reportNull$$$0(1);
        }
        this(RelativePoint.getTargetWindow(), RelativePoint.calcPoint(screenPoint));
    }

    @NotNull
    private static Point calcPoint(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            RelativePoint.$$$reportNull$$$0(2);
        }
        Point p = new Point(screenPoint.x, screenPoint.y);
        SwingUtilities.convertPointFromScreen(p, RelativePoint.getTargetWindow());
        Point point = p;
        if (point == null) {
            RelativePoint.$$$reportNull$$$0(3);
        }
        return point;
    }

    @NotNull
    private static Window getTargetWindow() {
        Window[] windows = Window.getWindows();
        Window targetWindow = null;
        for (Window each : windows) {
            if (!each.isActive()) continue;
            targetWindow = each;
            break;
        }
        if (targetWindow == null) {
            targetWindow = JOptionPane.getRootFrame();
        }
        Frame frame = targetWindow;
        if (frame == null) {
            RelativePoint.$$$reportNull$$$0(4);
        }
        return frame;
    }

    public RelativePoint(@NotNull Component aComponent, @NotNull Point aPointOnComponent) {
        if (aComponent == null) {
            RelativePoint.$$$reportNull$$$0(5);
        }
        if (aPointOnComponent == null) {
            RelativePoint.$$$reportNull$$$0(6);
        }
        JRootPane rootPane = SwingUtilities.getRootPane(aComponent);
        if (aComponent.isShowing() && rootPane != null) {
            this.myComponent = rootPane;
            this.myPointOnComponent = SwingUtilities.convertPoint(aComponent, aPointOnComponent, this.myComponent);
        } else {
            this.myComponent = aComponent;
            this.myPointOnComponent = aPointOnComponent;
        }
        this.myOriginalComponent = aComponent;
        this.myOriginalPoint = aPointOnComponent;
    }

    @NotNull
    public Component getComponent() {
        Component component = this.myComponent;
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(7);
        }
        return component;
    }

    public Point getPoint() {
        return this.myPointOnComponent;
    }

    public Point getPoint(@Nullable Component aTargetComponent) {
        boolean window = aTargetComponent instanceof Window;
        if (aTargetComponent == null || !window && (aTargetComponent.getParent() == null || SwingUtilities.getWindowAncestor(aTargetComponent) == null)) {
            return new Point();
        }
        return SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), aTargetComponent);
    }

    @NotNull
    public RelativePoint getPointOn(@NotNull Component aTargetComponent) {
        if (aTargetComponent == null) {
            RelativePoint.$$$reportNull$$$0(8);
        }
        Point point = this.getPoint(aTargetComponent);
        RelativePoint relativePoint = new RelativePoint(aTargetComponent, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(9);
        }
        return relativePoint;
    }

    @NotNull
    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        Point point2 = point;
        if (point2 == null) {
            RelativePoint.$$$reportNull$$$0(10);
        }
        return point2;
    }

    @NotNull
    public MouseEvent toMouseEvent() {
        MouseEvent mouseEvent = new MouseEvent(this.myComponent, 0, 0L, 0, this.myPointOnComponent.x, this.myPointOnComponent.y, 1, false);
        if (mouseEvent == null) {
            RelativePoint.$$$reportNull$$$0(11);
        }
        return mouseEvent;
    }

    @NotNull
    public String toString() {
        String string = this.getPoint() + " on " + this.getComponent();
        if (string == null) {
            RelativePoint.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static RelativePoint getCenterOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(13);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(14);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthEastOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(15);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(16);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthWestOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(17);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(18);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(19);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(20);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthWestOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(21);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(22);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthEastOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(23);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(24);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint fromScreen(Point screenPoint) {
        Frame root = JOptionPane.getRootFrame();
        SwingUtilities.convertPointFromScreen(screenPoint, root);
        RelativePoint relativePoint = new RelativePoint(root, screenPoint);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(25);
        }
        return relativePoint;
    }

    @NotNull
    public Component getOriginalComponent() {
        Component component = this.myOriginalComponent;
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(26);
        }
        return component;
    }

    @NotNull
    public Point getOriginalPoint() {
        Point point = this.myOriginalPoint;
        if (point == null) {
            RelativePoint.$$$reportNull$$$0(27);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenPoint";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/awt/RelativePoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPointOnComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aTargetComponent";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/awt/RelativePoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointOn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenPoint";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toMouseEvent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterOf";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSouthEastOf";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSouthWestOf";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSouthOf";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNorthWestOf";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNorthEastOf";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fromScreen";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalComponent";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcPoint";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPointOn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCenterOf";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSouthEastOf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSouthWestOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSouthOf";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNorthWestOf";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNorthEastOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

