/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public class UiInterceptors {
    private static final ConcurrentLinkedQueue<UiInterceptor<?>> ourInterceptors = new ConcurrentLinkedQueue();

    public static boolean tryIntercept(@NotNull Object uiComponent) {
        UiInterceptor<?> interceptor;
        if (uiComponent == null) {
            UiInterceptors.$$$reportNull$$$0(0);
        }
        if ((interceptor = ourInterceptors.poll()) == null) {
            return false;
        }
        interceptor.intercept(uiComponent);
        return true;
    }

    public static void register(UiInterceptor<?> interceptor) {
        ourInterceptors.offer(interceptor);
    }

    public static void clear() {
        ArrayList interceptors = new ArrayList(ourInterceptors);
        ourInterceptors.clear();
        if (!interceptors.isEmpty()) {
            throw new IllegalStateException("Expected UI was not shown: " + interceptors);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiComponent", "com/intellij/ui/UiInterceptors", "tryIntercept"));
    }

    public static abstract class UiInterceptor<T> {
        @NotNull
        private final Class<T> myClass;

        protected UiInterceptor(@NotNull Class<T> componentClass) {
            if (componentClass == null) {
                UiInterceptor.$$$reportNull$$$0(0);
            }
            this.myClass = componentClass;
        }

        public final void intercept(@NotNull Object component) {
            if (component == null) {
                UiInterceptor.$$$reportNull$$$0(1);
            }
            if (!this.myClass.isInstance(component)) {
                throw new IllegalStateException("Unexpected UI component appears: wanted " + this.myClass.getName() + "; got: " + component.getClass().getName() + " (" + component + ")");
            }
            this.doIntercept(this.myClass.cast(component));
        }

        protected abstract void doIntercept(T var1);

        public String toString() {
            return this.myClass.getName() + " (interceptor: " + this.getClass().getName() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/UiInterceptors$UiInterceptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intercept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

