/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CollapsingListener;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class CollapsiblePanel
extends JPanel {
    private final JButton myToggleCollapseButton;
    private final JComponent myContent;
    private boolean myIsCollapsed;
    private final Collection<CollapsingListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIsInitialized = false;
    private final Icon myExpandIcon;
    private final Icon myCollapseIcon;
    private Label myTitleLabel;
    public static final KeyStroke LEFT_KEY_STROKE = KeyStroke.getKeyStroke(37, 0);
    public static final KeyStroke RIGHT_KEY_STROKE = KeyStroke.getKeyStroke(39, 0);
    @NonNls
    public static final String EXPAND = "expand";
    @NonNls
    public static final String COLLAPSE = "collapse";

    public CollapsiblePanel(JComponent content, boolean collapseButtonAtLeft, boolean isCollapsed, Icon collapseIcon, Icon expandIcon, String title) {
        super(new GridBagLayout());
        this.myContent = content;
        this.setBackground(content.getBackground());
        this.myExpandIcon = expandIcon;
        this.myCollapseIcon = collapseIcon;
        Dimension buttonDimension = this.getButtonDimension();
        this.myToggleCollapseButton = new JButton();
        this.myToggleCollapseButton.setOpaque(false);
        this.myToggleCollapseButton.setBorderPainted(false);
        this.myToggleCollapseButton.setBackground(content.getBackground());
        this.myToggleCollapseButton.setSize(buttonDimension);
        this.myToggleCollapseButton.setPreferredSize(buttonDimension);
        this.myToggleCollapseButton.setMinimumSize(buttonDimension);
        this.myToggleCollapseButton.setMaximumSize(buttonDimension);
        this.myToggleCollapseButton.setFocusable(true);
        this.myToggleCollapseButton.getActionMap().put(COLLAPSE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapsiblePanel.this.collapse();
            }
        });
        this.myToggleCollapseButton.getActionMap().put(EXPAND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapsiblePanel.this.expand();
            }
        });
        this.myToggleCollapseButton.getInputMap().put(LEFT_KEY_STROKE, COLLAPSE);
        this.myToggleCollapseButton.getInputMap().put(RIGHT_KEY_STROKE, EXPAND);
        int iconAnchor = collapseButtonAtLeft ? 17 : 13;
        this.add((Component)this.myToggleCollapseButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, iconAnchor, 0, new Insets(-5, collapseButtonAtLeft ? 0 : -5, 0, collapseButtonAtLeft ? -5 : 0), 0, 0));
        if (title != null) {
            this.myTitleLabel = new Label(title);
            this.myTitleLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
            this.myTitleLabel.setBackground(content.getBackground());
            this.add((Component)this.myTitleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(-5, -3, 0, -3), 0, 0));
        }
        this.myToggleCollapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapsiblePanel.this.setCollapsed(!CollapsiblePanel.this.myIsCollapsed);
            }
        });
        this.setCollapsed(isCollapsed);
    }

    private Dimension getButtonDimension() {
        if (this.myExpandIcon == null) {
            return new Dimension(7, 7);
        }
        return new Dimension(this.myExpandIcon.getIconWidth(), this.myExpandIcon.getIconHeight());
    }

    public CollapsiblePanel(JComponent content, boolean collapseButtonAtLeft) {
        this(content, collapseButtonAtLeft, false, null, null, null);
    }

    protected void setCollapsed(boolean collapse) {
        try {
            if (collapse) {
                if (this.myIsInitialized) {
                    this.remove(this.myContent);
                }
            } else {
                this.add((Component)this.myContent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.myIsCollapsed = collapse;
            Icon icon = this.getIcon();
            if (icon != null) {
                this.myToggleCollapseButton.setIcon(icon);
                this.myToggleCollapseButton.setBorder(null);
                this.myToggleCollapseButton.setBorderPainted(false);
                this.myToggleCollapseButton.setToolTipText(this.getToggleButtonToolTipText());
            }
            if (collapse) {
                this.setFocused(true);
                this.setSelected(true);
            } else {
                this.myContent.requestFocusInWindow();
            }
            this.notifyListeners();
            this.revalidate();
            this.repaint();
        }
        finally {
            this.myIsInitialized = true;
        }
    }

    private String getToggleButtonToolTipText() {
        if (this.myIsCollapsed) {
            return UIBundle.message("collapsible.panel.collapsed.state.tooltip.text", new Object[0]);
        }
        return UIBundle.message("collapsible.panel.expanded.state.tooltip.text", new Object[0]);
    }

    private Icon getIcon() {
        if (this.myIsCollapsed) {
            return this.myExpandIcon;
        }
        return this.myCollapseIcon;
    }

    private void notifyListeners() {
        for (CollapsingListener listener : this.myListeners) {
            listener.onCollapsingChanged(this, this.isCollapsed());
        }
    }

    public void addCollapsingListener(CollapsingListener listener) {
        this.myListeners.add(listener);
    }

    public void removeCollapsingListener(CollapsingListener listener) {
        this.myListeners.remove(listener);
    }

    public boolean isCollapsed() {
        return this.myIsCollapsed;
    }

    public void expand() {
        if (this.myIsCollapsed) {
            this.setCollapsed(false);
        }
    }

    public void collapse() {
        if (!this.myIsCollapsed) {
            this.setCollapsed(true);
        }
    }

    public void setFocused(boolean focused) {
        this.myToggleCollapseButton.requestFocusInWindow();
    }

    public void setSelected(boolean selected) {
        this.myToggleCollapseButton.setSelected(selected);
    }

    public ActionMap getCollapsibleActionMap() {
        return this.myToggleCollapseButton.getActionMap();
    }

    public InputMap getCollapsibleInputMap() {
        return this.myToggleCollapseButton.getInputMap();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.updatePanel();
        super.paintComponent(g);
    }

    private void updatePanel() {
        if (this.paintAsSelected()) {
            this.setBackground(UIUtil.getTableSelectionBackground());
        } else {
            this.setBackground(this.myContent.getBackground());
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.myTitleLabel != null) {
            this.updateTitle();
        }
        this.updateToggleButton();
        super.paintChildren(g);
    }

    private void updateToggleButton() {
        if (this.paintAsSelected()) {
            this.myToggleCollapseButton.setBackground(UIUtil.getTableSelectionBackground());
        } else {
            this.myToggleCollapseButton.setBackground(this.myContent.getBackground());
        }
    }

    private void updateTitle() {
        if (this.paintAsSelected()) {
            this.myTitleLabel.setForeground(UIUtil.getTableSelectionForeground());
            this.myTitleLabel.setBackground(UIUtil.getTableSelectionBackground());
        } else {
            this.myTitleLabel.setForeground(UIUtil.getLabelForeground());
            this.myTitleLabel.setBackground(this.myContent.getBackground());
        }
    }

    private boolean paintAsSelected() {
        return this.myToggleCollapseButton.hasFocus() && this.isCollapsed();
    }
}

