/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JavaMethodSignature {
    private static final Set<String> OBJECT_METHOD_NAMES = ContainerUtil.map2Set((Object[])Object.class.getDeclaredMethods(), Method::getName);
    private final String myMethodName;
    private final Class[] myMethodParameters;

    public JavaMethodSignature(String methodName, Class ... methodParameters) {
        this.myMethodName = methodName;
        this.myMethodParameters = methodParameters.length == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : methodParameters;
    }

    public JavaMethodSignature(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    @Nullable
    public final Method findMethod(Class aClass) {
        Method method = this.getDeclaredMethod(aClass);
        if (method == null && aClass.isInterface() && OBJECT_METHOD_NAMES.contains(this.myMethodName)) {
            method = ReflectionUtil.getDeclaredMethod(Object.class, (String)this.myMethodName, (Class[])this.myMethodParameters);
        }
        return method;
    }

    @Nullable
    private Method getDeclaredMethod(Class aClass) {
        Method method = ReflectionUtil.getMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters);
        return method == null ? ReflectionUtil.getDeclaredMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters) : method;
    }

    List<Method> getAllMethods(Class startFrom) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class superClass : JBIterable.from((Iterable)ReflectionUtil.classTraverser((Class)startFrom)).append(Object.class).unique()) {
            for (Method method : superClass.getDeclaredMethods()) {
                if (!this.methodMatches(method)) continue;
                result.add(method);
            }
        }
        return result;
    }

    private boolean methodMatches(Method method) {
        return this.myMethodName.equals(method.getName()) && Arrays.equals(method.getParameterTypes(), this.myMethodParameters);
    }

    public String toString() {
        return this.myMethodName + Arrays.asList(this.myMethodParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodSignature that = (JavaMethodSignature)o;
        if (!this.myMethodName.equals(that.myMethodName)) {
            return false;
        }
        return Arrays.equals(this.myMethodParameters, that.myMethodParameters);
    }

    public int hashCode() {
        int result = this.myMethodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.myMethodParameters);
        return result;
    }
}

