/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestUtil {
    public static final String CARET_TAG = "<caret>";
    public static final String CARET_TAG_PREFIX = "<caret>".substring(0, "<caret>".length() - 1);
    public static final String SELECTION_START_TAG = "<selection>";
    public static final String SELECTION_END_TAG = "</selection>";
    public static final String BLOCK_SELECTION_START_TAG = "<block>";
    public static final String BLOCK_SELECTION_END_TAG = "</block>";
    public static final char BACKSPACE_FAKE_CHAR = '\uffff';
    public static final char SMART_ENTER_FAKE_CHAR = '\ufffe';
    public static final char SMART_LINE_SPLIT_CHAR = '\ufffd';

    public static void performTypingAction(Editor editor, char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        if (c == '\uffff') {
            EditorTestUtil.executeAction(editor, "EditorBackSpace");
        } else if (c == '\ufffe') {
            EditorTestUtil.executeAction(editor, "EditorCompleteStatement");
        } else if (c == '\ufffd') {
            EditorTestUtil.executeAction(editor, "EditorSplitLine");
        } else if (c == '\n') {
            EditorTestUtil.executeAction(editor, "EditorEnter");
        } else {
            TypedAction action = actionManager.getTypedAction();
            action.actionPerformed(editor, c, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        }
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(0);
        }
        if (actionId == null) {
            EditorTestUtil.$$$reportNull$$$0(1);
        }
        EditorTestUtil.executeAction(editor, actionId, false);
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId, boolean assertActionIsEnabled) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(2);
        }
        if (actionId == null) {
            EditorTestUtil.$$$reportNull$$$0(3);
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        AnAction action = actionManager.getAction(actionId);
        Assert.assertNotNull((Object)action);
        EditorTestUtil.executeAction(editor, assertActionIsEnabled, action);
    }

    public static void executeAction(@NotNull Editor editor, boolean assertActionIsEnabled, @NotNull AnAction action) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(4);
        }
        if (action == null) {
            EditorTestUtil.$$$reportNull$$$0(5);
        }
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)EditorTestUtil.createEditorContext(editor));
        action.beforeActionPerformedUpdate(event);
        if (!event.getPresentation().isEnabled()) {
            Assert.assertFalse((String)("Action " + action + " is disabled"), (boolean)assertActionIsEnabled);
            return;
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.fireBeforeActionPerformed(action, event.getDataContext(), event);
        action.actionPerformed(event);
        actionManager.fireAfterActionPerformed(action, event.getDataContext(), event);
    }

    @NotNull
    private static DataContext createEditorContext(@NotNull Editor editor) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(6);
        }
        Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        Map map = ContainerUtil.newHashMap((Pair)Pair.create((Object)CommonDataKeys.HOST_EDITOR.getName(), (Object)hostEditor), (Pair[])new Pair[]{Pair.createNonNull((Object)CommonDataKeys.EDITOR.getName(), (Object)editor)});
        DataContext parent = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        DataContext dataContext = SimpleDataContext.getSimpleContext((Map)map, (DataContext)parent);
        if (dataContext == null) {
            EditorTestUtil.$$$reportNull$$$0(7);
        }
        return dataContext;
    }

    public static void performReferenceCopy(Editor editor) {
        EditorTestUtil.executeAction(editor, "CopyReference", true);
    }

    public static void performPaste(Editor editor) {
        EditorTestUtil.executeAction(editor, "EditorPaste", true);
    }

    public static List<IElementType> getAllTokens(EditorHighlighter highlighter) {
        ArrayList<IElementType> tokens = new ArrayList<IElementType>();
        HighlighterIterator iterator = highlighter.createIterator(0);
        while (!iterator.atEnd()) {
            tokens.add(iterator.getTokenType());
            iterator.advance();
        }
        return tokens;
    }

    public static int getCaretPosition(@NotNull String content) {
        if (content == null) {
            EditorTestUtil.$$$reportNull$$$0(8);
        }
        return EditorTestUtil.getCaretAndSelectionPosition(content)[0];
    }

    public static int[] getCaretAndSelectionPosition(@NotNull String content) {
        String visualOffsetString;
        if (content == null) {
            EditorTestUtil.$$$reportNull$$$0(9);
        }
        int caretPosInSourceFile = content.indexOf(CARET_TAG_PREFIX);
        int caretEndInSourceFile = content.indexOf(">", caretPosInSourceFile);
        int caretLength = caretEndInSourceFile - caretPosInSourceFile;
        int visualColumnOffset = 0;
        if (caretPosInSourceFile >= 0 && (visualOffsetString = content.substring(caretPosInSourceFile + CARET_TAG_PREFIX.length(), caretEndInSourceFile)).length() > 1) {
            visualColumnOffset = Integer.parseInt(visualOffsetString.substring(1));
        }
        int selectionStartInSourceFile = content.indexOf(SELECTION_START_TAG);
        int selectionEndInSourceFile = content.indexOf(SELECTION_END_TAG);
        if (selectionStartInSourceFile >= 0) {
            if (caretPosInSourceFile >= 0) {
                if (caretPosInSourceFile < selectionStartInSourceFile) {
                    selectionStartInSourceFile -= caretLength;
                    selectionEndInSourceFile -= caretLength;
                } else {
                    caretPosInSourceFile = caretPosInSourceFile < selectionEndInSourceFile ? (caretPosInSourceFile -= SELECTION_START_TAG.length()) : (caretPosInSourceFile -= SELECTION_START_TAG.length() + SELECTION_END_TAG.length());
                }
            }
            selectionEndInSourceFile -= SELECTION_START_TAG.length();
        }
        return new int[]{caretPosInSourceFile, visualColumnOffset, selectionStartInSourceFile, selectionEndInSourceFile};
    }

    public static boolean configureSoftWraps(Editor editor, int charCountToWrapAt) {
        int charWidthInPixels = 10;
        return EditorTestUtil.configureSoftWraps(editor, (charCountToWrapAt + 1) * charWidthInPixels + 1, charWidthInPixels);
    }

    public static boolean configureSoftWraps(Editor editor, int visibleWidth, final int charWidthInPixels) {
        editor.getSettings().setUseSoftWraps(true);
        SoftWrapModelImpl model = (SoftWrapModelImpl)editor.getSoftWrapModel();
        model.setSoftWrapPainter(new SoftWrapPainter(){

            public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
                if (g == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (drawingType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return charWidthInPixels;
            }

            public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
                if (g == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (drawingType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return charWidthInPixels;
            }

            public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
                if (drawingType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return charWidthInPixels;
            }

            public boolean canUse() {
                return true;
            }

            public void reinit() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "drawingType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDrawingHorizontalOffset";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getMinDrawingWidth";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        model.reinitSettings();
        SoftWrapApplianceManager applianceManager = model.getApplianceManager();
        applianceManager.setWidthProvider(() -> visibleWidth);
        model.setEditorTextRepresentationHelper((EditorTextRepresentationHelper)new DefaultEditorTextRepresentationHelper(editor){

            public int charWidth(int c, int fontType) {
                return charWidthInPixels;
            }
        });
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, visibleWidth, 1000);
        applianceManager.registerSoftWrapIfNecessary();
        return !model.getRegisteredSoftWraps().isEmpty();
    }

    public static void setEditorVisibleSize(Editor editor, int widthInChars, int heightInChars) {
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, widthInChars * EditorUtil.getSpaceWidth((int)0, (Editor)editor), heightInChars * editor.getLineHeight());
    }

    public static void setEditorVisibleSizeInPixels(Editor editor, int widthInPixels, int heightInPixels) {
        Dimension size = new Dimension(widthInPixels, heightInPixels);
        ((EditorEx)editor).getScrollPane().getViewport().setExtentSize(size);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document) {
        if (document == null) {
            EditorTestUtil.$$$reportNull$$$0(10);
        }
        CaretAndSelectionState caretAndSelectionState = EditorTestUtil.extractCaretAndSelectionMarkers(document, true);
        if (caretAndSelectionState == null) {
            EditorTestUtil.$$$reportNull$$$0(11);
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document, boolean processBlockSelection) {
        if (document == null) {
            EditorTestUtil.$$$reportNull$$$0(12);
        }
        CaretAndSelectionState caretAndSelectionState = (CaretAndSelectionState)WriteCommandAction.writeCommandAction(null).compute(() -> EditorTestUtil.extractCaretAndSelectionMarkersImpl(document, processBlockSelection));
        if (caretAndSelectionState == null) {
            EditorTestUtil.$$$reportNull$$$0(13);
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkersImpl(@NotNull Document document, boolean processBlockSelection) {
        if (document == null) {
            EditorTestUtil.$$$reportNull$$$0(14);
        }
        ArrayList<CaretInfo> carets = new ArrayList<CaretInfo>();
        String fileText = document.getText();
        RangeMarker blockSelectionStartMarker = null;
        RangeMarker blockSelectionEndMarker = null;
        if (processBlockSelection) {
            int blockSelectionEnd;
            int blockSelectionStart = fileText.indexOf(BLOCK_SELECTION_START_TAG);
            if ((blockSelectionStart ^ (blockSelectionEnd = fileText.indexOf(BLOCK_SELECTION_END_TAG))) < 0) {
                throw new IllegalArgumentException("Both block selection opening and closing tag must be present");
            }
            if (blockSelectionStart >= 0) {
                blockSelectionStartMarker = document.createRangeMarker(blockSelectionStart, blockSelectionStart);
                blockSelectionEndMarker = document.createRangeMarker(blockSelectionEnd, blockSelectionEnd);
                document.deleteString(blockSelectionStartMarker.getStartOffset(), blockSelectionStartMarker.getStartOffset() + BLOCK_SELECTION_START_TAG.length());
                document.deleteString(blockSelectionEndMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset() + BLOCK_SELECTION_END_TAG.length());
            }
        }
        boolean multiCaret = StringUtil.getOccurrenceCount((String)document.getText(), (String)CARET_TAG) > 1 || StringUtil.getOccurrenceCount((String)document.getText(), (String)SELECTION_START_TAG) > 1;
        int pos = 0;
        while (pos < document.getTextLength()) {
            RangeMarker selEndMarker;
            int selEndIndex;
            fileText = document.getText();
            int caretIndex = fileText.indexOf(CARET_TAG, pos);
            int selStartIndex = fileText.indexOf(SELECTION_START_TAG, pos);
            if ((selStartIndex ^ (selEndIndex = fileText.indexOf(SELECTION_END_TAG, pos))) < 0) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (0 <= selEndIndex && selEndIndex < selStartIndex) {
                throw new IllegalArgumentException("Wrong order of selection opening and closing tags");
            }
            if (caretIndex < 0 && selStartIndex < 0 && selEndIndex < 0) break;
            if (multiCaret && 0 <= caretIndex && caretIndex < selStartIndex) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (multiCaret && caretIndex > selEndIndex && selEndIndex >= 0) {
                caretIndex = -1;
            }
            RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
            RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
            RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
            if (caretMarker != null) {
                document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_TAG.length());
            }
            if (selStartMarker != null) {
                document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_TAG.length());
            }
            if (selEndMarker != null) {
                document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_TAG.length());
            }
            LogicalPosition caretPosition = null;
            if (caretMarker != null) {
                int line = document.getLineNumber(caretMarker.getStartOffset());
                int column = caretMarker.getStartOffset() - document.getLineStartOffset(line);
                caretPosition = new LogicalPosition(line, column);
            }
            carets.add(new CaretInfo(caretPosition, selStartMarker == null || selEndMarker == null ? null : new TextRange(selStartMarker.getStartOffset(), selEndMarker.getEndOffset())));
            pos = Math.max(caretMarker == null ? -1 : caretMarker.getStartOffset(), selEndMarker == null ? -1 : selEndMarker.getEndOffset());
        }
        if (carets.isEmpty()) {
            carets.add(new CaretInfo(null, null));
        }
        TextRange blockSelection = null;
        if (blockSelectionStartMarker != null) {
            blockSelection = new TextRange(blockSelectionStartMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset());
        }
        CaretAndSelectionState caretAndSelectionState = new CaretAndSelectionState(Arrays.asList(carets.toArray(new CaretInfo[0])), blockSelection);
        if (caretAndSelectionState == null) {
            EditorTestUtil.$$$reportNull$$$0(15);
        }
        return caretAndSelectionState;
    }

    public static void setCaretsAndSelection(Editor editor, CaretAndSelectionState caretsState) {
        CaretModel caretModel = editor.getCaretModel();
        ArrayList<CaretState> states = new ArrayList<CaretState>(caretsState.carets.size());
        for (CaretInfo caret : caretsState.carets) {
            states.add(new CaretState(caret.position == null ? null : editor.offsetToLogicalPosition(caret.getCaretOffset(editor.getDocument())), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getStartOffset()), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getEndOffset())));
        }
        caretModel.setCaretsAndSelections(states);
        if (caretsState.blockSelection != null) {
            editor.getSelectionModel().setBlockSelection(editor.offsetToLogicalPosition(caretsState.blockSelection.getStartOffset()), editor.offsetToLogicalPosition(caretsState.blockSelection.getEndOffset()));
        }
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState) {
        EditorTestUtil.verifyCaretAndSelectionState(editor, caretState, null);
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState, String message) {
        boolean hasChecks = false;
        for (int i = 0; i < caretState.carets.size(); ++i) {
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position == null && expected.selection == null) continue;
            hasChecks = true;
            break;
        }
        if (!hasChecks) {
            return;
        }
        String messageSuffix = message == null ? "" : message + ": ";
        CaretModel caretModel = editor.getCaretModel();
        ArrayList allCarets = new ArrayList(caretModel.getAllCarets());
        Assert.assertEquals((String)(messageSuffix + " Unexpected number of carets"), (long)caretState.carets.size(), (long)allCarets.size());
        for (int i = 0; i < caretState.carets.size(); ++i) {
            String caretDescription = caretState.carets.size() == 1 ? "" : "caret " + (i + 1) + "/" + caretState.carets.size() + " ";
            Caret currentCaret = (Caret)allCarets.get(i);
            int actualCaretLine = editor.getDocument().getLineNumber(currentCaret.getOffset());
            int actualCaretColumn = currentCaret.getOffset() - editor.getDocument().getLineStartOffset(actualCaretLine);
            LogicalPosition actualCaretPosition = new LogicalPosition(actualCaretLine, actualCaretColumn);
            int selectionStart = currentCaret.getSelectionStart();
            int selectionEnd = currentCaret.getSelectionEnd();
            LogicalPosition actualSelectionStart = editor.offsetToLogicalPosition(selectionStart);
            LogicalPosition actualSelectionEnd = editor.offsetToLogicalPosition(selectionEnd);
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position != null) {
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected caret position"), (Object)expected.position, (Object)actualCaretPosition);
            }
            if (expected.selection != null) {
                LogicalPosition expectedSelectionStart = editor.offsetToLogicalPosition(expected.selection.getStartOffset());
                LogicalPosition expectedSelectionEnd = editor.offsetToLogicalPosition(expected.selection.getEndOffset());
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection start"), (Object)expectedSelectionStart, (Object)actualSelectionStart);
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection end"), (Object)expectedSelectionEnd, (Object)actualSelectionEnd);
                continue;
            }
            Assert.assertFalse((String)(messageSuffix + caretDescription + "should has no selection, but was: (" + actualSelectionStart + ", " + actualSelectionEnd + ")"), (boolean)currentCaret.hasSelection());
        }
    }

    public static FoldRegion addFoldRegion(@NotNull Editor editor, int startOffset, int endOffset, String placeholder, boolean collapse) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(16);
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        Ref ref = new Ref();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion region = foldingModel.addFoldRegion(startOffset, endOffset, placeholder);
            Assert.assertNotNull((Object)region);
            region.setExpanded(!collapse);
            ref.set((Object)region);
        });
        return (FoldRegion)ref.get();
    }

    public static Inlay addInlay(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(17);
        }
        return EditorTestUtil.addInlay(editor, offset, false);
    }

    public static Inlay addInlay(@NotNull Editor editor, int offset, boolean relatesToPrecedingText) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(18);
        }
        return EditorTestUtil.addInlay(editor, offset, relatesToPrecedingText, 1);
    }

    public static Inlay addInlay(@NotNull Editor editor, int offset, boolean relatesToPrecedingText, final int widthInPixels) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(19);
        }
        return editor.getInlayModel().addInlineElement(offset, relatesToPrecedingText, new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Inlay inlay) {
                if (inlay == null) {
                    3.$$$reportNull$$$0(0);
                }
                return widthInPixels;
            }

            public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
                if (inlay == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (g == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (targetRegion == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (textAttributes == null) {
                    3.$$$reportNull$$$0(4);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inlay";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetRegion";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textAttributes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "calcWidthInPixels";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static Inlay addBlockInlay(@NotNull Editor editor, int offset, boolean showAbove) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(20);
        }
        return editor.getInlayModel().addBlockElement(offset, false, showAbove, 0, new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Inlay inlay) {
                if (inlay == null) {
                    4.$$$reportNull$$$0(0);
                }
                return 0;
            }

            public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
                if (inlay == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (g == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (targetRegion == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (textAttributes == null) {
                    4.$$$reportNull$$$0(4);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inlay";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetRegion";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textAttributes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "calcWidthInPixels";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void waitForLoading(Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (EditorUtil.isRealFileEditor((Editor)editor)) {
            UIUtil.dispatchAllInvocationEvents();
            while (!AsyncEditorLoader.isEditorLoaded((Editor)editor)) {
                LockSupport.parkNanos(100000000L);
                UIUtil.dispatchAllInvocationEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testUndoInEditor(@NotNull Editor editor, @NotNull Runnable runnable) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(21);
        }
        if (runnable == null) {
            EditorTestUtil.$$$reportNull$$$0(22);
        }
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        Project project2 = editor.getProject();
        Assert.assertNotNull((Object)project2);
        UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)project2);
        CurrentEditorProvider savedProvider = undoManager.getEditorProvider();
        undoManager.setEditorProvider(() -> EditorTestUtil.lambda$testUndoInEditor$3((FileEditor)fileEditor));
        try {
            runnable.run();
        }
        finally {
            undoManager.setEditorProvider(savedProvider);
        }
    }

    @NotNull
    public static String getTextWithCaretsAndSelections(@NotNull Editor editor) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(23);
        }
        String string = EditorTestUtil.getTextWithCaretsAndSelections(editor, true, true);
        if (string == null) {
            EditorTestUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getTextWithCaretsAndSelections(@NotNull Editor editor, boolean addCarets, boolean addSelections) {
        if (editor == null) {
            EditorTestUtil.$$$reportNull$$$0(25);
        }
        StringBuilder sb = new StringBuilder(editor.getDocument().getCharsSequence());
        ContainerUtil.reverse((List)editor.getCaretModel().getAllCarets()).forEach(caret -> ContainerUtil.reverse(EditorTestUtil.getCaretMacros(caret, addCarets, addSelections)).forEach(pair -> sb.insert((int)((Integer)pair.first), (String)pair.second)));
        String string = sb.toString();
        if (string == null) {
            EditorTestUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static List<Pair<Integer, String>> getCaretMacros(@NotNull Caret caret, boolean position, boolean selection) {
        if (caret == null) {
            EditorTestUtil.$$$reportNull$$$0(27);
        }
        if (!position && !selection) {
            List<Pair<Integer, String>> list = Collections.emptyList();
            if (list == null) {
                EditorTestUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        boolean addSelection = selection && caret.hasSelection();
        ArrayList<Pair<Integer, String>> result = new ArrayList<Pair<Integer, String>>();
        if (addSelection) {
            result.add(Pair.create((Object)caret.getSelectionStart(), (Object)SELECTION_START_TAG));
        }
        if (position) {
            result.add((Pair<Integer, String>)Pair.create((Object)caret.getOffset(), (Object)CARET_TAG));
        }
        if (addSelection) {
            result.add((Pair<Integer, String>)Pair.create((Object)caret.getSelectionEnd(), (Object)SELECTION_END_TAG));
        }
        ArrayList<Pair<Integer, String>> arrayList = result;
        if (arrayList == null) {
            EditorTestUtil.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private static /* synthetic */ FileEditor lambda$testUndoInEditor$3(FileEditor fileEditor) {
        return fileEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/EditorTestUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCaretAndSelectionMarkers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCaretAndSelectionMarkersImpl";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithCaretsAndSelections";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditorContext";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCaretPosition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAndSelectionPosition";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkersImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addInlay";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addBlockInlay";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "testUndoInEditor";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithCaretsAndSelections";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCaretMacros";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CaretInfo {
        @Nullable
        public final LogicalPosition position;
        @Nullable
        public final TextRange selection;

        public CaretInfo(@Nullable LogicalPosition position, @Nullable TextRange selection) {
            this.position = position;
            this.selection = selection;
        }

        public int getCaretOffset(Document document) {
            return this.position == null ? -1 : document.getLineStartOffset(this.position.line) + this.position.column;
        }
    }

    public static class CaretAndSelectionState {
        public final List<CaretInfo> carets;
        public final TextRange blockSelection;

        public CaretAndSelectionState(List<CaretInfo> carets, @Nullable TextRange blockSelection) {
            this.carets = carets;
            this.blockSelection = blockSelection;
        }

        public boolean hasExplicitCaret() {
            if (this.carets.isEmpty()) {
                return false;
            }
            if (this.blockSelection == null && this.carets.size() == 1) {
                CaretInfo caret = this.carets.get(0);
                return caret.position != null || caret.selection != null;
            }
            return true;
        }
    }
}

