/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.python.packaging.PyExecutionException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a$\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a$\u0010\u0015\u001a\u00020\t*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"createButtonsPanel", "Ljavax/swing/JPanel;", "buttons", "", "Ljavax/swing/JButton;", "doCreateSouthPanel", "leftButtons", "rightButtons", "show", "", "panel", "stepContent", "Ljava/awt/Component;", "showProcessExecutionErrorDialog", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/jetbrains/python/packaging/PyExecutionException;", "swipe", "swipeDirection", "Lcom/intellij/ui/JBCardLayout$SwipeDirection;", "appendProcessOutput", "Ljavax/swing/JTextPane;", "stdout", "", "stderr", "exitCode", "", "intellij.python.community.impl"})
public final class WizardUIUtilKt {
    @NotNull
    public static final JPanel doCreateSouthPanel(@NotNull List<? extends JButton> leftButtons, @NotNull List<? extends JButton> rightButtons) {
        Insets insets;
        Intrinsics.checkParameterIsNotNull(leftButtons, (String)"leftButtons");
        Intrinsics.checkParameterIsNotNull(rightButtons, (String)"rightButtons");
        JPanel panel = new JPanel(new BorderLayout());
        if (SystemInfo.isMacOSLeopard) {
            JBInsets jBInsets = UIUtil.isUnderIntelliJLaF() ? JBUI.insets((int)0, (int)8) : JBUI.emptyInsets();
            Intrinsics.checkExpressionValueIsNotNull((Object)jBInsets, (String)"if (UIUtil.isUnderIntell\u2026) else JBUI.emptyInsets()");
            insets = (Insets)jBInsets;
        } else if (UIUtil.isUnderWin10LookAndFeel()) {
            JBInsets jBInsets = JBUI.emptyInsets();
            Intrinsics.checkExpressionValueIsNotNull((Object)jBInsets, (String)"JBUI.emptyInsets()");
            insets = (Insets)jBInsets;
        } else {
            insets = new Insets(8, 0, 0, 0);
        }
        Insets insets2 = insets;
        GridBag bag = new GridBag().setDefaultInsets(insets2);
        NonOpaquePanel lrButtonsPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        JPanel leftButtonsPanel = WizardUIUtilKt.createButtonsPanel(leftButtons);
        leftButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        lrButtonsPanel.add((Component)leftButtonsPanel, (Object)bag.next());
        lrButtonsPanel.add(Box.createHorizontalGlue(), (Object)bag.next().weightx(1.0).fillCellHorizontally());
        JPanel buttonsPanel = WizardUIUtilKt.createButtonsPanel(rightButtons);
        lrButtonsPanel.add((Component)buttonsPanel, (Object)bag.next());
        panel.add((Component)lrButtonsPanel, "Center");
        panel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        return panel;
    }

    private static final JPanel createButtonsPanel(List<? extends JButton> buttons) {
        int hgap = SystemInfo.isMacOSLeopard ? (UIUtil.isUnderIntelliJLaF() ? 8 : 0) : 5;
        NonOpaquePanel buttonsPanel = new NonOpaquePanel((LayoutManager)new GridLayout(1, buttons.size(), hgap, 0));
        Iterable $this$forEach$iv = buttons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton it = (JButton)element$iv;
            boolean bl = false;
            buttonsPanel.add((Component)it);
        }
        return (JPanel)buttonsPanel;
    }

    public static final void swipe(@NotNull JPanel panel, @NotNull Component stepContent, @NotNull JBCardLayout.SwipeDirection swipeDirection) {
        Intrinsics.checkParameterIsNotNull((Object)panel, (String)"panel");
        Intrinsics.checkParameterIsNotNull((Object)stepContent, (String)"stepContent");
        Intrinsics.checkParameterIsNotNull((Object)swipeDirection, (String)"swipeDirection");
        String stepContentName = String.valueOf(stepContent.hashCode());
        panel.add(stepContentName, stepContent);
        LayoutManager layoutManager = panel.getLayout();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.JBCardLayout");
        }
        ((JBCardLayout)layoutManager).swipe((Container)panel, stepContentName, swipeDirection);
    }

    public static final void show(@NotNull JPanel panel, @NotNull Component stepContent) {
        Intrinsics.checkParameterIsNotNull((Object)panel, (String)"panel");
        Intrinsics.checkParameterIsNotNull((Object)stepContent, (String)"stepContent");
        String stepContentName = String.valueOf(stepContent.hashCode());
        panel.add(stepContentName, stepContent);
        LayoutManager layoutManager = panel.getLayout();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.CardLayout");
        }
        ((CardLayout)layoutManager).show(panel, stepContentName);
    }

    public static final void showProcessExecutionErrorDialog(@Nullable Project project, @NotNull PyExecutionException e) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
        String errorMessageText = e.getCommand() + " could not complete successfully. " + "Please see the command's output for information about resolving this problem.";
        JBLabel errorMessageLabel = new JBLabel(UIUtil.toHtml((String)errorMessageText), Messages.getErrorIcon(), 2);
        JTextPane jTextPane = new JTextPane();
        boolean bl = false;
        boolean bl2 = false;
        JTextPane $this$apply = jTextPane;
        boolean bl3 = false;
        String string = e.getStdout();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.stdout");
        String string2 = e.getStderr();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"e.stderr");
        WizardUIUtilKt.appendProcessOutput($this$apply, string, string2, e.getExitCode());
        $this$apply.setBackground((Color)JBColor.WHITE);
        $this$apply.setEditable(false);
        JTextPane commandOutputTextPane = jTextPane;
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        bl2 = false;
        boolean bl4 = false;
        BorderLayoutPanel $this$apply2 = borderLayoutPanel;
        boolean bl5 = false;
        $this$apply2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Command output", (boolean)false));
        $this$apply2.addToCenter((Component)new JBScrollPane((Component)commandOutputTextPane, 20, 31));
        BorderLayoutPanel commandOutputPanel = borderLayoutPanel;
        FormBuilder formBuilder = new FormBuilder().addComponent((JComponent)errorMessageLabel).addComponentFillVertically((JComponent)commandOutputPanel, 4);
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder, (String)"FormBuilder()\n    .addCo\u2026nel, UIUtil.DEFAULT_VGAP)");
        FormBuilder formBuilder2 = formBuilder;
        new DialogWrapper(formBuilder2, e, project, project){
            final /* synthetic */ FormBuilder $formBuilder;
            final /* synthetic */ PyExecutionException $e;
            final /* synthetic */ Project $project;

            @NotNull
            protected Action[] createActions() {
                Action[] actionArray = new Action[1];
                Action action = this.getOKAction();
                Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"okAction");
                actionArray[0] = action;
                return actionArray;
            }

            @NotNull
            protected JComponent createCenterPanel() {
                JPanel jPanel = this.$formBuilder.getPanel();
                boolean bl = false;
                boolean bl2 = false;
                JPanel $this$apply = jPanel;
                boolean bl3 = false;
                $this$apply.setPreferredSize(new Dimension(600, 300));
                JPanel jPanel2 = jPanel;
                Intrinsics.checkExpressionValueIsNotNull((Object)jPanel2, (String)"formBuilder.panel.apply \u2026Dimension(600, 300)\n    }");
                return jPanel2;
            }
            {
                this.$formBuilder = $captured_local_variable$0;
                this.$e = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3);
                this.init();
                this.setTitle($captured_local_variable$1.getLocalizedMessage());
            }
        }.showAndGet();
    }

    private static final void appendProcessOutput(@NotNull JTextPane $this$appendProcessOutput, String stdout, String stderr, int exitCode) {
        Style stdoutStyle = $this$appendProcessOutput.addStyle(null, null);
        StyleConstants.setFontFamily(stdoutStyle, "Monospaced");
        Style stderrStyle = $this$appendProcessOutput.addStyle(null, stdoutStyle);
        StyleConstants.setForeground(stderrStyle, (Color)JBColor.RED);
        Document document = $this$appendProcessOutput.getDocument();
        boolean bl = false;
        boolean bl2 = false;
        Document $this$apply = document;
        boolean bl3 = false;
        Pair[] $this$forEach$iv = new Pair[]{TuplesKt.to((Object)stdout, (Object)stdoutStyle), TuplesKt.to((Object)stderr, (Object)stderrStyle)};
        boolean $i$f$forEach = false;
        Pair[] pairArray = $this$forEach$iv;
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            Pair element$iv;
            Pair $dstr$std$style = element$iv = pairArray[i];
            boolean bl4 = false;
            String std = (String)$dstr$std$style.component1();
            Style style = (Style)$dstr$std$style.component2();
            CharSequence charSequence = std;
            boolean bl5 = false;
            if (!(charSequence.length() > 0)) continue;
            $this$apply.insertString($this$apply.getLength(), std + "\n", style);
        }
        $this$apply.insertString($this$apply.getLength(), "Process finished with exit code " + exitCode, stdoutStyle);
    }
}

