/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.extractSuperclass;

import com.google.common.base.Predicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyExtractSuperclassHelper {
    private static final Logger LOG = Logger.getInstance((String)PyExtractSuperclassHelper.class.getName());
    private static final Predicate<PyMemberInfo<PyElement>> ALLOW_OBJECT = new PyUtil.ObjectPredicate(true);

    private PyExtractSuperclassHelper() {
    }

    static void extractSuperclass(PyClass clazz, @NotNull Collection<PyMemberInfo<PyElement>> selectedMemberInfos, String superBaseName, String targetFile) {
        PyMemberInfo<PyElement> object;
        if (selectedMemberInfos == null) {
            PyExtractSuperclassHelper.$$$reportNull$$$0(0);
        }
        Project project = clazz.getProject();
        selectedMemberInfos = new ArrayList<PyMemberInfo<PyElement>>(selectedMemberInfos);
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements((Collection)JBIterable.from(selectedMemberInfos).transform(info -> (PyElement)info.getMember()).toList());
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyExtractSuperclassHelper.getRefactoringId(), beforeData);
        PyMemberInfo<PyElement> objectMember = MembersManager.findMember(selectedMemberInfos, ALLOW_OBJECT);
        if (LanguageLevel.forElement((PsiElement)clazz).isPy3K() && !PyExtractSuperclassHelper.isObjectParentDeclaredExplicitly(clazz)) {
            if (objectMember != null) {
                selectedMemberInfos.remove(objectMember);
            }
        } else if (objectMember == null && (object = MembersManager.findMember(clazz, ALLOW_OBJECT)) != null) {
            selectedMemberInfos.add(object);
        }
        String text2 = "class " + superBaseName + ":\n  pass\n";
        PyClass newClass = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyClass.class, text2);
        newClass = PyExtractSuperclassHelper.placeNewClass(project, newClass, clazz, targetFile);
        MembersManager.moveAllMembers(selectedMemberInfos, clazz, newClass);
        if (!newClass.getContainingFile().equals(clazz.getContainingFile())) {
            PyClassRefactoringUtil.optimizeImports(clazz.getContainingFile());
        }
        PyClassRefactoringUtil.addSuperclasses(project, clazz, null, newClass);
        RefactoringEventData afterData = new RefactoringEventData();
        afterData.addElement((PsiElement)newClass);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyExtractSuperclassHelper.getRefactoringId(), afterData);
    }

    private static boolean isObjectParentDeclaredExplicitly(@NotNull PyClass clazz) {
        if (clazz == null) {
            PyExtractSuperclassHelper.$$$reportNull$$$0(1);
        }
        return Arrays.stream(clazz.getSuperClassExpressions()).anyMatch(o -> "object".equals(o.getName()));
    }

    private static PyClass placeNewClass(Project project, PyClass newClass, @NotNull PyClass clazz, String targetFile) {
        VirtualFile file;
        if (clazz == null) {
            PyExtractSuperclassHelper.$$$reportNull$$$0(2);
        }
        if (Comparing.equal((Object)(file = VirtualFileManager.getInstance().findFileByUrl(ApplicationManager.getApplication().isUnitTestMode() ? targetFile : VfsUtilCore.pathToUrl((String)targetFile))), (Object)clazz.getContainingFile().getVirtualFile())) {
            return (PyClass)clazz.getParent().addBefore((PsiElement)newClass, (PsiElement)clazz);
        }
        PsiFile psiFile = null;
        try {
            if (file == null) {
                String filename;
                String path;
                if (targetFile.endsWith(PythonFileType.INSTANCE.getDefaultExtension())) {
                    path = PathUtil.getParentPath((String)targetFile);
                    filename = PathUtil.getFileName((String)targetFile);
                } else {
                    path = targetFile;
                    filename = "__init__.py";
                }
                psiFile = PyExtractSuperclassHelper.placeFile(project, path, filename);
            } else {
                psiFile = file.isDirectory() ? PyExtractSuperclassHelper.placeFile(project, file.getPath(), "__init__.py") : PsiManager.getInstance((Project)project).findFile(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        LOG.assertTrue(psiFile != null);
        if (psiFile.getLastChild() != null) {
            psiFile.add((PsiElement)PyElementGenerator.getInstance(project).createFromText(LanguageLevel.PYTHON27, PsiWhiteSpace.class, "\n\n"));
        }
        newClass = (PyClass)psiFile.add((PsiElement)newClass);
        PyClassRefactoringUtil.insertImport((PsiElement)clazz, Collections.singleton(newClass));
        return newClass;
    }

    public static PsiFile placeFile(Project project, String path, String filename) throws IOException {
        return PyExtractSuperclassHelper.placeFile(project, path, filename, null);
    }

    public static PsiFile placeFile(Project project, String path, String filename, @Nullable String content2) throws IOException {
        PsiDirectory psiDir = PyExtractSuperclassHelper.createDirectories(project, path);
        LOG.assertTrue(psiDir != null);
        PsiFile psiFile = psiDir.findFile(filename);
        if (psiFile == null) {
            PsiDocumentManager manager;
            Document document;
            psiFile = psiDir.createFile(filename);
            if (content2 != null && (document = (manager = PsiDocumentManager.getInstance((Project)project)).getDocument(psiFile)) != null) {
                document.setText((CharSequence)content2);
                manager.commitDocument(document);
            }
        }
        return psiFile;
    }

    @Nullable
    private static PsiDirectory createDirectories(Project project, String target) throws IOException {
        String relativePath = null;
        VirtualFile closestRoot = null;
        target = FileUtil.toSystemIndependentName((String)target);
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        ArrayList<VirtualFile> allRoots = new ArrayList<VirtualFile>();
        ContainerUtil.addAll(allRoots, (Object[])projectRootManager.getContentRoots());
        ContainerUtil.addAll(allRoots, (Object[])projectRootManager.getContentSourceRoots());
        allRoots.sort(Comparator.comparingInt(vf -> vf.getPath().length()).reversed());
        for (VirtualFile file : allRoots) {
            String rootPath = file.getPath();
            if (!target.startsWith(rootPath)) continue;
            relativePath = target.substring(rootPath.length());
            closestRoot = file;
            break;
        }
        if (closestRoot == null) {
            throw new IOException("Can't find '" + target + "' among roots");
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String[] dirs = relativePath.split("/");
        int i = 0;
        if (dirs[0].isEmpty()) {
            i = 1;
        }
        VirtualFile resultDir = closestRoot;
        while (i < dirs.length) {
            VirtualFile subdir = resultDir.findChild(dirs[i]);
            if (subdir != null) {
                if (!subdir.isDirectory()) {
                    throw new IOException("Expected resultDir, but got non-resultDir: " + subdir.getPath());
                }
            } else {
                subdir = resultDir.createChildDirectory((Object)lfs, dirs[i]);
            }
            if (subdir.findChild("__init__.py") == null) {
                subdir.createChildData((Object)lfs, "__init__.py");
            }
            resultDir = subdir;
            ++i;
        }
        return psiManager.findDirectory(resultDir);
    }

    public static String getRefactoringId() {
        return "refactoring.python.extract.superclass";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMemberInfos";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractSuperclass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isObjectParentDeclaredExplicitly";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "placeNewClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

