/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.FileContentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    public static final Key<LanguageLevel> PYTHON_LANGUAGE_LEVEL = Key.create((String)"PYTHON_LANGUAGE_LEVEL");
    public static final Map<LanguageLevel, LanguageLevel> COMPATIBLE_LEVELS;
    private final Map<Module, Sdk> myModuleSdks = ContainerUtil.createWeakMap();
    private static final FileAttribute PERSISTENCE;

    private static void addCompatiblePair(Map<LanguageLevel, LanguageLevel> levels, LanguageLevel l1, LanguageLevel l2) {
        levels.put(l1, l2);
        levels.put(l2, l1);
    }

    public static void pushLanguageLevel(Project project) {
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new PythonLanguageLevelPusher()});
    }

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        Map<Module, Sdk> moduleSdks = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        Set distinctSdks = (Set)StreamEx.ofValues(moduleSdks).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        this.myModuleSdks.putAll(moduleSdks);
        PyUtil.invalidateLanguageLevelCache(project);
        this.updateSdkLanguageLevels(project, distinctSdks);
        project.putUserData(PYTHON_LANGUAGE_LEVEL, (Object)PyUtil.guessLanguageLevel(project));
    }

    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key<LanguageLevel> key = LanguageLevel.KEY;
        if (key == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return languageLevel;
    }

    @Nullable
    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        return PythonLanguageLevelPusher.getFileLanguageLevel(project, file);
    }

    @Nullable
    public static LanguageLevel getFileLanguageLevel(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            return LanguageLevel.FORCE_LANGUAGE_LEVEL;
        }
        if (file == null) {
            return null;
        }
        Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, file);
        if (sdk != null) {
            return PythonSdkType.getLanguageLevelForSdk(sdk);
        }
        return PyUtil.guessLanguageLevelWithCaching(project);
    }

    @Nullable
    private static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile file) {
        Module module2;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        if ((module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            if (sdk != null) {
                return sdk;
            }
            return null;
        }
        return PythonLanguageLevelPusher.findSdkForFileOutsideTheProject(project, file);
    }

    @Nullable
    private static Sdk findSdkForFileOutsideTheProject(Project project, VirtualFile file) {
        if (file != null) {
            List orderEntries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orderEntries) {
                if (!(orderEntry instanceof JdkOrderEntry)) continue;
                return ((JdkOrderEntry)orderEntry).getJdk();
            }
        }
        return null;
    }

    @NotNull
    public LanguageLevel getImmediateValue(@NotNull Module module2) {
        if (module2 == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            LanguageLevel languageLevel = LanguageLevel.FORCE_LANGUAGE_LEVEL;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(9);
            }
            return languageLevel;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(module2);
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        return languageLevel;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        return true;
    }

    private static boolean areLanguageLevelsCompatible(LanguageLevel oldLevel, LanguageLevel newLevel) {
        return oldLevel != null && newLevel != null && COMPATIBLE_LEVELS.get((Object)oldLevel) == newLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (fileOrDir == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        if (level == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        LanguageLevel oldLanguageLevel = null;
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
                oldLanguageLevel = Arrays.stream(LanguageLevel.values()).filter(it -> it.ordinal() == oldLevelOrdinal).findFirst().orElse(null);
            }
            finally {
                iStream.close();
            }
        }
        try (DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        }
        if (!PythonLanguageLevelPusher.areLanguageLevelsCompatible(oldLanguageLevel, level) || !ProjectFileIndex.getInstance((Project)project).isInContent(fileOrDir)) {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, PythonLanguageLevelPusher::isPythonFile);
        }
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !PythonLanguageLevelPusher.isPythonFile(child)) continue;
            PythonLanguageLevelPusher.clearSdkPathCache(child);
        }
    }

    private static boolean isPythonFile(VirtualFile child) {
        return ((Object)((Object)PythonFileType.INSTANCE)).equals(FileTypeRegistry.getInstance().getFileTypeByFileName(child.getNameSequence()));
    }

    private static void clearSdkPathCache(@NotNull VirtualFile child) {
        Project[] projects;
        if (child == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, child);
            if (sdk == null) continue;
            PythonSdkPathCache pathCache = PythonSdkPathCache.getInstance(project, sdk);
            pathCache.clearCache();
        }
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(18);
        }
        Map<Module, Sdk> moduleSdks = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        Set distinctSdks = (Set)StreamEx.ofValues(moduleSdks).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        boolean needToReparseOpenFiles = StreamEx.of(moduleSdks.entrySet()).anyMatch(entry -> {
            Module module2 = (Module)entry.getKey();
            Sdk newSdk = (Sdk)entry.getValue();
            Sdk oldSdk = this.myModuleSdks.get(module2);
            return this.myModuleSdks.containsKey(module2) && newSdk != oldSdk;
        });
        this.myModuleSdks.putAll(moduleSdks);
        PyUtil.invalidateLanguageLevelCache(project);
        this.updateSdkLanguageLevels(project, distinctSdks);
        if (needToReparseOpenFiles) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project.isDisposed()) {
                    return;
                }
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            });
        }
    }

    @NotNull
    private static Map<Module, Sdk> getPythonModuleSdks(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(19);
        }
        LinkedHashMap<Module, Sdk> result = new LinkedHashMap<Module, Sdk>();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            if (!PythonLanguageLevelPusher.isPythonModule(module2)) continue;
            result.put(module2, PythonSdkType.findPythonSdk(module2));
        }
        LinkedHashMap<Module, Sdk> linkedHashMap = result;
        if (linkedHashMap == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    private static boolean isPythonModule(@NotNull Module module2) {
        Facet[] allFacets;
        ModuleType moduleType;
        if (module2 == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(21);
        }
        if ((moduleType = ModuleType.get((Module)module2)) instanceof PythonModuleTypeBase) {
            return true;
        }
        for (Facet facet : allFacets = FacetManager.getInstance((Module)module2).getAllFacets()) {
            if (!(facet.getConfiguration() instanceof PythonFacetSettings)) continue;
            return true;
        }
        return false;
    }

    private void updateSdkLanguageLevels(final @NotNull Project project, final @NotNull Set<Sdk> sdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(22);
        }
        if (sdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(23);
        }
        if (sdks.isEmpty()) {
            return;
        }
        DumbService dumbService = DumbService.getInstance((Project)project);
        final DumbModeTask task2 = new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                List tasks = (List)ReadAction.compute(() -> PythonLanguageLevelPusher.this.getRootUpdateTasks(project, sdks));
                PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible((List)tasks);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    snapshot.logResponsivenessSinceCreation("Pushing Python language level to " + tasks.size() + " roots in " + sdks.size() + " SDKs");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$1", "performInDumbMode"));
            }
        };
        project.getMessageBus().connect((Disposable)task2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                DumbService.getInstance((Project)project).cancelTask(task2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$2", "rootsChanged"));
            }
        });
        dumbService.queueTask(task2);
    }

    private List<Runnable> getRootUpdateTasks(@NotNull Project project, @NotNull Set<Sdk> sdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(24);
        }
        if (sdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(25);
        }
        ArrayList<Runnable> results = new ArrayList<Runnable>();
        for (Sdk sdk : sdks) {
            LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
            for (VirtualFile root : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!root.isValid() || PyTypeShed.INSTANCE.isInside(root)) continue;
                VirtualFile parent = root.getParent();
                boolean shouldSuppressSizeLimit = parent != null && parent.getName().equals("python_stubs");
                results.add(new UpdateRootTask(project, root, languageLevel, shouldSuppressSizeLimit));
            }
        }
        return results;
    }

    public static void setForcedLanguageLevel(Project project, @Nullable LanguageLevel languageLevel) {
        LanguageLevel.FORCE_LANGUAGE_LEVEL = languageLevel;
        PythonLanguageLevelPusher.pushLanguageLevel(project);
    }

    public void flushLanguageLevelCache() {
        this.myModuleSdks.clear();
    }

    static {
        EnumMap compatLevels = Maps.newEnumMap(LanguageLevel.class);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON26, LanguageLevel.PYTHON27);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON33, LanguageLevel.PYTHON34);
        COMPATIBLE_LEVELS = Maps.immutableEnumMap((Map)compatLevels);
        PERSISTENCE = new FileAttribute("python_language_level_persistence", 2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonModuleSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileLanguageLevel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileSdk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clearSdkPathCache";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPythonModuleSdks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPythonModule";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkLanguageLevels";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRootUpdateTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class UpdateRootTask
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final boolean myShouldSuppressSizeLimit;

        UpdateRootTask(@NotNull Project project, @NotNull VirtualFile root, LanguageLevel languageLevel, boolean shouldSuppressSizeLimit) {
            if (project == null) {
                UpdateRootTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UpdateRootTask.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                UpdateRootTask.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myLanguageLevel = languageLevel;
            this.myShouldSuppressSizeLimit = shouldSuppressSizeLimit;
        }

        @Override
        public void run() {
            if (this.myProject.isDisposed() || !((Boolean)ReadAction.compute(() -> this.myRoot.isValid())).booleanValue()) {
                return;
            }
            final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            final PushedFilePropertiesUpdater propertiesUpdater = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (Boolean)ReadAction.compute(() -> {
                        if (fileTypeManager.isFileIgnored(file)) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            propertiesUpdater.findAndUpdateValue(file, (FilePropertyPusher)PythonLanguageLevelPusher.this, (Object)UpdateRootTask.this.myLanguageLevel);
                        }
                        if (UpdateRootTask.this.myShouldSuppressSizeLimit) {
                            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
                        }
                        return true;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask$1", "visitFile"));
                }
            });
        }

        public String toString() {
            return "UpdateRootTask{myRoot=" + this.myRoot + ", myLanguageLevel=" + (Object)((Object)this.myLanguageLevel) + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

