/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBoundFunction;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.TypeEvalStack;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedRatedResolveResult;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallExpressionHelper {
    private PyCallExpressionHelper() {
    }

    @Nullable
    public static Pair<String, PyFunction> interpretAsModifierWrappingCall(PyCallExpression redefiningCall) {
        PsiElement original;
        PyExpression possible_original_ref;
        PyExpression[] args;
        PyArgumentList argumentList;
        String refName;
        PyReferenceExpression referenceExpr;
        PyExpression redefining_callee = redefiningCall.getCallee();
        if (redefiningCall.isCalleeText("classmethod", "staticmethod") && (referenceExpr = (PyReferenceExpression)redefining_callee) != null && ("classmethod".equals(refName = referenceExpr.getReferencedName()) || "staticmethod".equals(refName)) && PyBuiltinCache.isInBuiltins(referenceExpr) && (argumentList = redefiningCall.getArgumentList()) != null && (args = argumentList.getArguments()).length == 1 && (possible_original_ref = args[0]) instanceof PyReferenceExpression && (original = ((PyReferenceExpression)possible_original_ref).getReference().resolve()) instanceof PyFunction) {
            return Pair.create((Object)refName, (Object)((PyFunction)original));
        }
        return null;
    }

    @Nullable
    public static PyClass resolveCalleeClass(PyCallExpression us) {
        PyExpression resolved;
        PyExpression callee = us.getCallee();
        if (callee instanceof PyReferenceExpression) {
            PyReferenceExpression ref = (PyReferenceExpression)callee;
            QualifiedResolveResult resolveResult = ref.followAssignmentsChain(PyResolveContext.noImplicits());
            resolved = resolveResult.getElement();
        } else {
            resolved = callee;
        }
        if (resolved instanceof PyClass) {
            return (PyClass)((Object)resolved);
        }
        if (resolved instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)((Object)resolved);
            return pyFunction.getContainingClass();
        }
        return null;
    }

    @NotNull
    public static List<PyCallExpression.PyMarkedCallee> multiResolveCallee(@NotNull PyCallExpression call, @NotNull PyResolveContext resolveContext, int implicitOffset) {
        PyExpression callee;
        List<PyCallExpression.PyMarkedCallee> calleesFromProviders;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(0);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(1);
        }
        if ((calleesFromProviders = PyCallExpressionHelper.getCalleesFromProviders(callee = call.getCallee(), resolveContext.getTypeEvalContext())) != null) {
            List<PyCallExpression.PyMarkedCallee> list = calleesFromProviders;
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(2);
            }
            return list;
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        ArrayList<PyCallExpression.PyMarkedCallee> ratedMarkedCallees = new ArrayList<PyCallExpression.PyMarkedCallee>();
        for (QualifiedRatedResolveResult resolveResult : PyCallExpressionHelper.multiResolveCallee(call.getCallee(), resolveContext)) {
            for (ClarifiedResolveResult clarifiedResolveResult : PyCallExpressionHelper.clarifyResolveResult(call, resolveResult, resolveContext)) {
                PyCallExpression.PyMarkedCallee markedCallee2 = PyCallExpressionHelper.markResolveResult(clarifiedResolveResult, context, implicitOffset);
                if (markedCallee2 == null) continue;
                ratedMarkedCallees.add(markedCallee2);
            }
        }
        List<PyCallExpression.PyMarkedCallee> list = PyCallExpressionHelper.forEveryScopeTakeOverloadsOtherwiseImplementations(ratedMarkedCallees, PyCallExpression.PyMarkedCallee::getElement, context).collect(Collectors.groupingBy(markedCallee -> markedCallee.getCallableType(), LinkedHashMap::new, Collectors.toList())).values().stream().map(callees -> callees.stream().max(Comparator.comparingInt(RatedResolveResult::getRate)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static List<PyCallExpression.PyMarkedCallee> getCalleesFromProviders(@Nullable PyExpression callee, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(4);
        }
        if (callee instanceof PyReferenceExpression) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)callee;
            List callees = StreamEx.of((Collection)PyTypeProvider.EP_NAME.getExtensionList()).map(provider -> provider.getReferenceExpressionType(referenceExpression, context)).select(PyCallableType.class).map(type -> new PyCallExpression.PyMarkedCallee((PyCallableType)type, null, null, 0, false, 0)).toList();
            if (!callees.isEmpty()) {
                return callees;
            }
        }
        return null;
    }

    @NotNull
    private static List<QualifiedRatedResolveResult> multiResolveCallee(@Nullable PyExpression callee, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(5);
        }
        if (callee instanceof PyReferenceExpression) {
            List<QualifiedRatedResolveResult> list = ((PyReferenceExpression)callee).multiFollowAssignmentsChain(resolveContext);
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (callee instanceof PyLambdaExpression) {
            List<QualifiedRatedResolveResult> list = Collections.singletonList(new QualifiedRatedResolveResult((PsiElement)callee, Collections.emptyList(), 0, false));
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<QualifiedRatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<ClarifiedResolveResult> clarifyResolveResult(@NotNull PyCallExpression call, @NotNull QualifiedRatedResolveResult resolveResult, @NotNull PyResolveContext resolveContext) {
        PsiElement resolved;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(9);
        }
        if (resolveResult == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(10);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(11);
        }
        if ((resolved = resolveResult.getElement()) instanceof PyClass) {
            List list = ContainerUtil.map(((PyClass)resolved).multiFindInitOrNew(true, resolveContext.getTypeEvalContext()), function -> new ClarifiedResolveResult(resolveResult, (PsiElement)function, null, true));
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (resolved instanceof PyCallExpression) {
            List<? extends RatedResolveResult> dunderCall;
            PyCallExpression resolvedCall = (PyCallExpression)resolved;
            Pair<String, PyFunction> wrapperInfo = PyCallExpressionHelper.interpretAsModifierWrappingCall(resolvedCall);
            if (wrapperInfo != null) {
                String wrapperName = (String)wrapperInfo.getFirst();
                PyFunction.Modifier wrappedModifier = "classmethod".equals(wrapperName) ? PyFunction.Modifier.CLASSMETHOD : ("staticmethod".equals(wrapperName) ? PyFunction.Modifier.STATICMETHOD : null);
                ClarifiedResolveResult result = new ClarifiedResolveResult(resolveResult, (PsiElement)wrapperInfo.getSecond(), wrappedModifier, false);
                List<ClarifiedResolveResult> list = Collections.singletonList(result);
                if (list == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(13);
                }
                return list;
            }
            PyType resolvedCallType = resolveContext.getTypeEvalContext().getType(resolvedCall);
            if (resolvedCallType instanceof PyClassLikeType && !ContainerUtil.isEmpty(dunderCall = ((PyClassLikeType)resolvedCallType).resolveMember("__call__", resolvedCall, AccessDirection.READ, resolveContext, true))) {
                List list = StreamEx.of(dunderCall).map(RatedResolveResult::getElement).nonNull().map(element -> new ClarifiedResolveResult(resolveResult, (PsiElement)element, null, false)).toList();
                if (list == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(14);
                }
                return list;
            }
        } else if (resolved instanceof PyFunction) {
            PyFunction function2 = (PyFunction)resolved;
            TypeEvalContext context = resolveContext.getTypeEvalContext();
            if (function2.getProperty() != null && PyCallExpressionHelper.isQualifiedByInstance((PyCallable)function2, resolveResult.getQualifiers(), context)) {
                PyType type = context.getReturnType(function2);
                List<ClarifiedResolveResult> list = type instanceof PyFunctionType ? Collections.singletonList(new ClarifiedResolveResult(resolveResult, (PsiElement)((PyFunctionType)type).getCallable(), null, false)) : Collections.emptyList();
                if (list == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(15);
                }
                return list;
            }
        }
        boolean isConstructor = resolved instanceof PyFunction && PyCallExpressionHelper.isConstructorName(((PyFunction)resolved).getName()) && call.getReceiver((PyCallable)resolved) == null;
        List<ClarifiedResolveResult> list = resolved != null ? Collections.singletonList(new ClarifiedResolveResult(resolveResult, resolved, null, isConstructor)) : Collections.emptyList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    private static PyCallExpression.PyMarkedCallee markResolveResult(@NotNull ClarifiedResolveResult resolveResult, @NotNull TypeEvalContext context, int implicitOffset) {
        PsiElement clarifiedResolved;
        if (resolveResult == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(18);
        }
        if (!((clarifiedResolved = resolveResult.myClarifiedResolved) instanceof PyTypedElement)) {
            return null;
        }
        PyCallableType callableType = PyUtil.as(context.getType((PyTypedElement)clarifiedResolved), PyCallableType.class);
        if (callableType == null) {
            return null;
        }
        if (clarifiedResolved instanceof PyCallable) {
            PyCallable callable = (PyCallable)clarifiedResolved;
            PyFunction.Modifier originalModifier = callable instanceof PyFunction ? ((PyFunction)callable).getModifier() : null;
            PyFunction.Modifier resolvedModifier = (PyFunction.Modifier)((Object)ObjectUtils.chooseNotNull((Object)((Object)originalModifier), (Object)((Object)resolveResult.myWrappedModifier)));
            boolean isConstructorCall = resolveResult.myIsConstructor;
            List<PyExpression> qualifiers = resolveResult.myOriginalResolveResult.getQualifiers();
            boolean isByInstance = isConstructorCall || PyCallExpressionHelper.isQualifiedByInstance(callable, qualifiers, context) || callable instanceof PyBoundFunction;
            PyExpression lastQualifier = (PyExpression)ContainerUtil.getLastItem(qualifiers);
            boolean isByClass = lastQualifier != null && PyCallExpressionHelper.isQualifiedByClass(callable, lastQualifier, context);
            int resolvedImplicitOffset = implicitOffset + PyCallExpressionHelper.getImplicitArgumentCount(callable, resolvedModifier, isConstructorCall, isByInstance, isByClass);
            return new PyCallExpression.PyMarkedCallee(callableType, callable, resolvedModifier, Math.max(0, resolvedImplicitOffset), resolveResult.myOriginalResolveResult.isImplicit(), resolveResult.myOriginalResolveResult.getRate());
        }
        return new PyCallExpression.PyMarkedCallee(callableType, null, null, implicitOffset, resolveResult.myOriginalResolveResult.isImplicit(), resolveResult.myOriginalResolveResult.getRate());
    }

    public static int getImplicitArgumentCount(@NotNull PyReferenceExpression callReference, @NotNull PyFunction function, @NotNull PyResolveContext resolveContext) {
        if (callReference == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(19);
        }
        if (function == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(20);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(21);
        }
        QualifiedResolveResult followed = callReference.followAssignmentsChain(resolveContext);
        List<PyExpression> qualifiers = followed.getQualifiers();
        PyExpression firstQualifier = (PyExpression)ContainerUtil.getFirstItem(qualifiers);
        boolean isByInstance = PyCallExpressionHelper.isQualifiedByInstance((PyCallable)function, qualifiers, resolveContext.getTypeEvalContext());
        boolean isConstructorCall = PyCallExpressionHelper.isConstructorName(function.getName()) && (!callReference.isQualified() || !PyCallExpressionHelper.isConstructorName(callReference.getName()));
        boolean isByClass = firstQualifier != null && PyCallExpressionHelper.isQualifiedByClass(function, firstQualifier, resolveContext.getTypeEvalContext());
        return PyCallExpressionHelper.getImplicitArgumentCount(function, function.getModifier(), isConstructorCall, isByInstance, isByClass);
    }

    private static boolean isConstructorName(@Nullable String name) {
        return "__new__".equals(name) || "__init__".equals(name);
    }

    private static int getImplicitArgumentCount(PyCallable callable, PyFunction.Modifier modifier, boolean isConstructorCall, boolean isByInstance, boolean isByClass) {
        PyFunction method;
        PyParameter first;
        PyNamedParameter named;
        int implicit_offset = 0;
        boolean firstIsArgsOrKwargs = false;
        PyParameter[] parameters = callable.getParameterList().getParameters();
        if (parameters.length > 0 && (named = (first = parameters[0]).getAsNamed()) != null && (named.isPositionalContainer() || named.isKeywordContainer())) {
            firstIsArgsOrKwargs = true;
        }
        if (!firstIsArgsOrKwargs && (isByInstance || isConstructorCall)) {
            ++implicit_offset;
        }
        if ((method = callable.asMethod()) == null) {
            return implicit_offset;
        }
        if ("__new__".equals(method.getName())) {
            return isConstructorCall ? 1 : 0;
        }
        if (!isByInstance && !isByClass && "__init__".equals(method.getName())) {
            return 1;
        }
        if (modifier == PyFunction.Modifier.STATICMETHOD) {
            if (isByInstance && implicit_offset > 0) {
                --implicit_offset;
            }
        } else if (modifier == PyFunction.Modifier.CLASSMETHOD && !isByInstance) {
            ++implicit_offset;
        }
        return implicit_offset;
    }

    private static boolean isQualifiedByInstance(@Nullable PyCallable resolved, @NotNull List<PyExpression> qualifiers, @NotNull TypeEvalContext context) {
        PyDocStringOwner owner;
        if (qualifiers == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(23);
        }
        if (!((owner = (PyDocStringOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolved, PyDocStringOwner.class)) instanceof PyClass)) {
            return false;
        }
        if (qualifiers.isEmpty()) {
            return true;
        }
        for (PyExpression qualifier : qualifiers) {
            if (qualifier == null || !PyCallExpressionHelper.isQualifiedByInstance(resolved, qualifier, context)) continue;
            return true;
        }
        return false;
    }

    private static boolean isQualifiedByInstance(@Nullable PyCallable resolved, @NotNull PyExpression qualifier, @NotNull TypeEvalContext context) {
        if (qualifier == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(25);
        }
        if (PyCallExpressionHelper.isQualifiedByClass(resolved, qualifier, context)) {
            return false;
        }
        PyType qualifierType = context.getType(qualifier);
        return qualifierType == null || !(qualifierType instanceof PyModuleType);
    }

    private static boolean isQualifiedByClass(@Nullable PyCallable resolved, @NotNull PyExpression qualifier, @NotNull TypeEvalContext context) {
        PyType qualifierType;
        if (qualifier == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(27);
        }
        if ((qualifierType = context.getType(qualifier)) instanceof PyClassType) {
            PyClassType qualifierClassType = (PyClassType)qualifierType;
            return qualifierClassType.isDefinition() && PyCallExpressionHelper.belongsToSpecifiedClassHierarchy((PsiElement)resolved, qualifierClassType.getPyClass(), context);
        }
        if (qualifierType instanceof PyClassLikeType) {
            return ((PyClassLikeType)qualifierType).isDefinition();
        }
        if (qualifierType instanceof PyUnionType) {
            Collection<PyType> members = ((PyUnionType)qualifierType).getMembers();
            if (members.stream().allMatch(PyClassType.class::isInstance)) {
                return ((StreamEx)StreamEx.of(members).select(PyClassType.class).filter(type -> PyCallExpressionHelper.belongsToSpecifiedClassHierarchy((PsiElement)resolved, type.getPyClass(), context))).allMatch(PyInstantiableType::isDefinition);
            }
        }
        return false;
    }

    private static boolean belongsToSpecifiedClassHierarchy(@Nullable PsiElement element, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyClass parent;
        if (cls == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(28);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(29);
        }
        return (parent = (PyClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PyClass.class)) != null && (cls.isSubclass(parent, context) || parent.isSubclass(cls, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyType getCallType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(30);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(31);
        }
        if (!TypeEvalStack.mayEvaluate((PsiElement)call)) {
            return null;
        }
        try {
            PyExpression callee = call.getCallee();
            if (callee instanceof PyReferenceExpression) {
                PyResolveContext resolveContext;
                List<QualifiedRatedResolveResult> resolveResults;
                Stream<QualifiedRatedResolveResult> overloadsOtherwiseImplementations;
                List members;
                PyExpression[] args;
                Maybe<PyType> superCallType;
                if ("super".equals(callee.getText()) && (superCallType = PyCallExpressionHelper.getSuperCallType(call, context)).isDefined()) {
                    PyType pyType = superCallType.value();
                    return pyType;
                }
                if ("type".equals(callee.getText()) && (args = call.getArguments()).length == 1) {
                    PyExpression arg = args[0];
                    PyType argType = context.getType(arg);
                    if (argType instanceof PyClassType) {
                        PyClassType classType = (PyClassType)argType;
                        if (!classType.isDefinition()) {
                            PyClass cls = classType.getPyClass();
                            PyType pyType = context.getType(cls);
                            return pyType;
                        }
                    } else {
                        PyType classType = null;
                        return classType;
                    }
                }
                if (!(members = ((StreamEx)StreamEx.of(PyUtil.filterTopPriorityResults((overloadsOtherwiseImplementations = PyCallExpressionHelper.forEveryScopeTakeOverloadsOtherwiseImplementations(resolveResults = PyCallExpressionHelper.multiResolveCallee(callee, resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context)), RatedResolveResult::getElement, context)).collect(Collectors.toList()))).map(ResolveResult::getElement).nonNull().peek(element -> PyUtil.verboseOnly(() -> PyPsiUtils.assertValid(element)))).map(element -> PyCallExpressionHelper.getCallTargetReturnType(call, element, context)).nonNull().map(Ref::get).toList()).isEmpty()) {
                    PyType pyType = PyUnionType.union(members);
                    return pyType;
                }
            }
            if (callee != null) {
                PyType type = context.getType(callee);
                if (type instanceof PyCallableType) {
                    PyCallableType callableType = (PyCallableType)type;
                    PyType pyType = callableType.getCallType(context, call);
                    return pyType;
                }
                if (type instanceof PyUnionType) {
                    PyType pyType = PyCallExpressionHelper.getCallResultTypeFromUnion(call, context, (PyUnionType)type);
                    return pyType;
                }
            }
            PyType pyType = null;
            return pyType;
        }
        finally {
            TypeEvalStack.evaluated((PsiElement)call);
        }
    }

    @Nullable
    private static PyType getCallResultTypeFromUnion(@NotNull PyCallSiteExpression call, @NotNull TypeEvalContext context, @NotNull PyUnionType type) {
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(32);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(33);
        }
        if (type == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(34);
        }
        HashSet<PyType> callResultTypes = new HashSet<PyType>();
        for (PyType memberType : type.getMembers()) {
            PyType callResultType;
            PyCallableType callableMemberType;
            Boolean callable = PyTypeChecker.isCallable(memberType);
            if (callable == null || !callable.booleanValue() || !(memberType instanceof PyCallableType) || !(callableMemberType = (PyCallableType)memberType).isCallable() || (callResultType = callableMemberType.getCallType(context, call)) == null) continue;
            callResultTypes.add(callResultType);
        }
        return PyUnionType.union(callResultTypes);
    }

    @Nullable
    private static Ref<? extends PyType> getCallTargetReturnType(@NotNull PyCallExpression call, @NotNull PsiElement target, @NotNull TypeEvalContext context) {
        PyFunction f;
        Ref<PyType> providedOverridingType;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(35);
        }
        if (target == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(37);
        }
        if ((providedOverridingType = PyReferenceExpressionImpl.getReferenceTypeFromOverridingProviders(target, context, (PsiElement)call)) != null && providedOverridingType.get() instanceof PyCallableType) {
            return Ref.create((Object)((PyCallableType)providedOverridingType.get()).getCallType(context, call));
        }
        PyClass cls = null;
        PyFunction init = null;
        if (target instanceof PyClass) {
            cls = (PyClass)target;
            init = cls.findInitOrNew(true, context);
        } else if (target instanceof PyFunction && PyCallExpressionHelper.isConstructorName((f = (PyFunction)target).getName())) {
            init = f;
            cls = f.getContainingClass();
        }
        if (init != null) {
            PyFunction newMethod;
            PyType t = init.getCallType(context, call);
            if (cls != null && cls != init.getContainingClass()) {
                if (t instanceof PyTupleType) {
                    PyTupleType tupleType = (PyTupleType)t;
                    PyTupleType newTupleType = new PyTupleType(cls, tupleType.getElementTypes(), tupleType.isHomogeneous());
                    return Ref.create((Object)newTupleType);
                }
                if (t instanceof PyCollectionType) {
                    List<PyType> elementTypes = ((PyCollectionType)t).getElementTypes();
                    return Ref.create((Object)new PyCollectionTypeImpl(cls, false, elementTypes));
                }
                return Ref.create((Object)new PyClassTypeImpl(cls, false));
            }
            if (t != null) {
                return Ref.create((Object)t);
            }
            if (cls != null && (newMethod = cls.findMethodByName("__new__", true, context)) != null && !PyBuiltinCache.getInstance((PsiElement)call).isBuiltin(newMethod)) {
                return Ref.create((Object)PyUnionType.createWeakType(new PyClassTypeImpl(cls, false)));
            }
        }
        if (cls != null) {
            return Ref.create((Object)new PyClassTypeImpl(cls, false));
        }
        Ref<PyType> providedType = PyReferenceExpressionImpl.getReferenceTypeFromProviders(target, context, (PsiElement)call);
        if (providedType != null && providedType.get() instanceof PyCallableType) {
            return Ref.create((Object)((PyCallableType)providedType.get()).getCallType(context, call));
        }
        Ref<PyType> propertyCallType = PyCallExpressionHelper.getPropertyCallType(call, target, context);
        if (propertyCallType != null) {
            return propertyCallType;
        }
        if (target instanceof PyCallable) {
            PyCallable callable = (PyCallable)target;
            return Ref.create((Object)callable.getCallType(context, call));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getPropertyCallType(@NotNull PyCallExpression call, @NotNull PsiElement target, @NotNull TypeEvalContext context) {
        PyType propertyType;
        PyCallable callable;
        Property property;
        PyClass containingClass;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(38);
        }
        if (target == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(39);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(40);
        }
        if (target instanceof PyCallable && target instanceof PyPossibleClassMember && (containingClass = ((PyPossibleClassMember)target).getContainingClass()) != null && (property = containingClass.findPropertyByCallable(callable = (PyCallable)target)) != null && (propertyType = property.getType(call.getReceiver(callable), context)) instanceof PyCallableType) {
            return Ref.create((Object)((PyCallableType)propertyType).getCallType(context, call));
        }
        return null;
    }

    @NotNull
    private static Maybe<PyType> getSuperCallType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        PyArgumentList argumentList;
        PyClass must_be_super;
        PsiElement must_be_super_init;
        PyExpression callee;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(42);
        }
        if ((callee = call.getCallee()) instanceof PyReferenceExpression && (must_be_super_init = ((PyReferenceExpression)callee).getReference().resolve()) instanceof PyFunction && (must_be_super = ((PyFunction)must_be_super_init).getContainingClass()) == PyBuiltinCache.getInstance((PsiElement)call).getClass("super") && (argumentList = call.getArgumentList()) != null) {
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)call, PyClass.class);
            PyExpression[] args = argumentList.getArguments();
            if (containingClass != null && args.length > 1) {
                PyExpression first_arg = args[0];
                if (first_arg instanceof PyReferenceExpression) {
                    PsiElement possible_class;
                    PyReferenceExpression firstArgRef = (PyReferenceExpression)first_arg;
                    PyExpression qualifier = firstArgRef.getQualifier();
                    if (qualifier != null && "__class__".equals(firstArgRef.getReferencedName())) {
                        PyParameterList parameterList;
                        PsiElement element;
                        PsiReference qRef = qualifier.getReference();
                        PsiElement psiElement = element = qRef == null ? null : qRef.resolve();
                        if (element instanceof PyParameter && (parameterList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class)) != null && element == parameterList.getParameters()[0]) {
                            Maybe<PyType> maybe = new Maybe<PyType>(PyCallExpressionHelper.getSuperCallTypeForArguments(context, containingClass, args[1]));
                            if (maybe == null) {
                                PyCallExpressionHelper.$$$reportNull$$$0(43);
                            }
                            return maybe;
                        }
                    }
                    if ((possible_class = firstArgRef.getReference().resolve()) instanceof PyClass && ((PyClass)possible_class).isNewStyleClass(context)) {
                        PyClass first_class = (PyClass)possible_class;
                        Maybe<PyType> maybe = new Maybe<PyType>(PyCallExpressionHelper.getSuperCallTypeForArguments(context, first_class, args[1]));
                        if (maybe == null) {
                            PyCallExpressionHelper.$$$reportNull$$$0(44);
                        }
                        return maybe;
                    }
                }
            } else if (call.getContainingFile() instanceof PyFile && ((PyFile)call.getContainingFile()).getLanguageLevel().isPy3K() && containingClass != null) {
                Maybe<PyType> maybe = new Maybe<PyType>(PyCallExpressionHelper.getSuperClassUnionType(containingClass, context));
                if (maybe == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(45);
                }
                return maybe;
            }
        }
        Maybe<PyType> maybe = new Maybe<PyType>();
        if (maybe == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(46);
        }
        return maybe;
    }

    @Nullable
    private static PyType getSuperCallTypeForArguments(@NotNull TypeEvalContext context, @NotNull PyClass firstClass, @Nullable PyExpression second_arg) {
        PyType second_type;
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(47);
        }
        if (firstClass == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(48);
        }
        if (second_arg != null && (second_type = context.getType(second_arg)) instanceof PyClassType) {
            PyClass nextAfterFirstInMro;
            PyClass secondClass = ((PyClassType)second_type).getPyClass();
            if (CompletionUtil.getOriginalOrSelf((PsiElement)firstClass) == secondClass) {
                return PyCallExpressionHelper.getSuperClassUnionType(firstClass, context);
            }
            if (secondClass.isSubclass(firstClass, context) && (nextAfterFirstInMro = (PyClass)((StreamEx)((StreamEx)StreamEx.of(secondClass.getAncestorClasses(context)).dropWhile(it -> it != firstClass)).skip(1L)).findFirst().orElse(null)) != null) {
                return new PyClassTypeImpl(nextAfterFirstInMro, false);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getSuperClassUnionType(@NotNull PyClass pyClass, TypeEvalContext context) {
        PyClass[] supers;
        if (pyClass == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(49);
        }
        if ((supers = pyClass.getSuperClasses(context)).length > 0) {
            if (supers.length == 1) {
                return new PyClassTypeImpl(supers[0], false);
            }
            ArrayList<PyType> superTypes = new ArrayList<PyType>();
            for (PyClass aSuper : supers) {
                superTypes.add(new PyClassTypeImpl(aSuper, false));
            }
            return PyUnionType.union(superTypes);
        }
        return null;
    }

    @NotNull
    public static List<PyCallExpression.PyArgumentsMapping> multiMapArguments(@NotNull PyCallExpression callExpression, @NotNull PyResolveContext resolveContext, int implicitOffset) {
        PyArgumentList argumentList;
        if (callExpression == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(50);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(51);
        }
        if ((argumentList = callExpression.getArgumentList()) == null) {
            List<PyCallExpression.PyArgumentsMapping> list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(52);
            }
            return list;
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        List list = ContainerUtil.map(callExpression.multiResolveCallee(resolveContext, implicitOffset), markedCallee -> PyCallExpressionHelper.mapArguments(callExpression, argumentList, markedCallee, context));
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(53);
        }
        return list;
    }

    @NotNull
    public static PyCallExpression.PyArgumentsMapping mapArguments(@NotNull PyCallExpression callExpression, @NotNull PyCallExpression.PyMarkedCallee markedCallee, @NotNull TypeEvalContext context) {
        PyArgumentList argumentList;
        if (callExpression == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(54);
        }
        if (markedCallee == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(56);
        }
        if ((argumentList = callExpression.getArgumentList()) == null) {
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpression.PyArgumentsMapping.empty(callExpression);
            if (pyArgumentsMapping == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(57);
            }
            return pyArgumentsMapping;
        }
        PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpressionHelper.mapArguments(callExpression, argumentList, markedCallee, context);
        if (pyArgumentsMapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(58);
        }
        return pyArgumentsMapping;
    }

    @NotNull
    private static PyCallExpression.PyArgumentsMapping mapArguments(@NotNull PyCallExpression callExpression, @NotNull PyArgumentList argumentList, @NotNull PyCallExpression.PyMarkedCallee markedCallee, @NotNull TypeEvalContext context) {
        List<PyCallableParameter> parameters;
        if (callExpression == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(59);
        }
        if (argumentList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(60);
        }
        if (markedCallee == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(62);
        }
        if ((parameters = markedCallee.getCallableType().getParameters(context)) == null) {
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpression.PyArgumentsMapping.empty(callExpression);
            if (pyArgumentsMapping == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(63);
            }
            return pyArgumentsMapping;
        }
        int safeImplicitOffset = Math.min(markedCallee.getImplicitOffset(), parameters.size());
        List<PyCallableParameter> explicitParameters = parameters.subList(safeImplicitOffset, parameters.size());
        List<PyCallableParameter> implicitParameters = parameters.subList(0, safeImplicitOffset);
        List<PyExpression> arguments = Arrays.asList(argumentList.getArguments());
        ArgumentMappingResults mappingResults = PyCallExpressionHelper.analyzeArguments(arguments, explicitParameters);
        PyCallExpression.PyArgumentsMapping pyArgumentsMapping = new PyCallExpression.PyArgumentsMapping(callExpression, markedCallee, implicitParameters, mappingResults.getMappedParameters(), mappingResults.getUnmappedParameters(), mappingResults.getUnmappedArguments(), mappingResults.getParametersMappedToVariadicPositionalArguments(), mappingResults.getParametersMappedToVariadicKeywordArguments(), mappingResults.getMappedTupleParameters());
        if (pyArgumentsMapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(64);
        }
        return pyArgumentsMapping;
    }

    @NotNull
    public static List<PyCallExpression.PyArgumentsMapping> mapArguments(@NotNull PyCallSiteExpression callSite, @NotNull PyResolveContext resolveContext) {
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(65);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(66);
        }
        ArrayList<PyCallExpression.PyArgumentsMapping> results = new ArrayList<PyCallExpression.PyArgumentsMapping>();
        for (Pair<PyCallable, PyCallableType> callableAndType : PyCallExpressionHelper.multiResolveCalleeFunction(callSite, resolveContext)) {
            results.add(PyCallExpressionHelper.mapArguments(callSite, (PyCallableType)callableAndType.second, (PyCallable)callableAndType.first, resolveContext));
        }
        ArrayList<PyCallExpression.PyArgumentsMapping> arrayList = results;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(67);
        }
        return arrayList;
    }

    @NotNull
    private static List<Pair<PyCallable, PyCallableType>> multiResolveCalleeFunction(@NotNull PyCallSiteExpression callSite, @NotNull PyResolveContext resolveContext) {
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(68);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(69);
        }
        if (callSite instanceof PyCallExpression) {
            List<PyCallExpression.PyMarkedCallee> callees = ((PyCallExpression)callSite).multiResolveCallee(resolveContext);
            List list = ContainerUtil.map(PyUtil.filterTopPriorityResults(callees), callee -> Pair.create((Object)callee.getElement(), (Object)callee.getCallableType()));
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(70);
            }
            return list;
        }
        ArrayList<Pair<PyCallable, PyCallableType>> results = new ArrayList<Pair<PyCallable, PyCallableType>>();
        for (PsiElement result : PyUtil.multiResolveTopPriority((PsiElement)callSite, resolveContext)) {
            PyType resultType;
            if (result instanceof PyTypedElement && (resultType = resolveContext.getTypeEvalContext().getType((PyTypedElement)result)) instanceof PyCallableType) {
                PyCallable callable = PyUtil.as(result, PyCallable.class);
                results.add((Pair<PyCallable, PyCallableType>)Pair.create((Object)callable, (Object)((PyCallableType)resultType)));
                continue;
            }
            List<Pair<PyCallable, PyCallableType>> list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(71);
            }
            return list;
        }
        ArrayList<Pair<PyCallable, PyCallableType>> arrayList = results;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(72);
        }
        return arrayList;
    }

    @NotNull
    public static PyCallExpression.PyArgumentsMapping mapArguments(@NotNull PyCallSiteExpression callSite, @NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        PyCallableType callableType;
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(73);
        }
        if (callable == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(74);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(75);
        }
        if ((callableType = PyUtil.as(context.getType(callable), PyCallableType.class)) == null) {
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpression.PyArgumentsMapping.empty(callSite);
            if (pyArgumentsMapping == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(76);
            }
            return pyArgumentsMapping;
        }
        PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpressionHelper.mapArguments(callSite, callableType, callable, PyResolveContext.noImplicits().withTypeEvalContext(context));
        if (pyArgumentsMapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(77);
        }
        return pyArgumentsMapping;
    }

    @NotNull
    private static PyCallExpression.PyArgumentsMapping mapArguments(@NotNull PyCallSiteExpression callSite, @NotNull PyCallableType callableType, @Nullable PyCallable callable, @NotNull PyResolveContext resolveContext) {
        List<PyCallableParameter> parameters;
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(78);
        }
        if (callableType == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(79);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(80);
        }
        if ((parameters = callableType.getParameters(resolveContext.getTypeEvalContext())) == null) {
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpression.PyArgumentsMapping.empty(callSite);
            if (pyArgumentsMapping == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(81);
            }
            return pyArgumentsMapping;
        }
        List<PyExpression> arguments = callSite.getArguments(callable);
        List<PyCallableParameter> explicitParameters = PyCallExpressionHelper.filterExplicitParameters(parameters, callable, callSite, resolveContext);
        List<PyCallableParameter> implicitParameters = parameters.subList(0, parameters.size() - explicitParameters.size());
        ArgumentMappingResults mappingResults = PyCallExpressionHelper.analyzeArguments(arguments, explicitParameters);
        PyCallExpression.PyMarkedCallee markedCallee = new PyCallExpression.PyMarkedCallee(callableType, callable, null, 0, false, 0);
        PyCallExpression.PyArgumentsMapping pyArgumentsMapping = new PyCallExpression.PyArgumentsMapping(callSite, markedCallee, implicitParameters, mappingResults.getMappedParameters(), mappingResults.getUnmappedParameters(), mappingResults.getUnmappedArguments(), mappingResults.getParametersMappedToVariadicPositionalArguments(), mappingResults.getParametersMappedToVariadicKeywordArguments(), mappingResults.getMappedTupleParameters());
        if (pyArgumentsMapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(82);
        }
        return pyArgumentsMapping;
    }

    @NotNull
    public static List<PyExpression> getArgumentsMappedToPositionalContainer(@NotNull Map<PyExpression, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(83);
        }
        List list = StreamEx.ofKeys(mapping, PyCallableParameter::isPositionalContainer).toList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(84);
        }
        return list;
    }

    @NotNull
    public static List<PyExpression> getArgumentsMappedToKeywordContainer(@NotNull Map<PyExpression, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(85);
        }
        List list = StreamEx.ofKeys(mapping, PyCallableParameter::isKeywordContainer).toList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(86);
        }
        return list;
    }

    @NotNull
    public static Map<PyExpression, PyCallableParameter> getRegularMappedParameters(@NotNull Map<PyExpression, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(87);
        }
        LinkedHashMap<PyExpression, PyCallableParameter> result = new LinkedHashMap<PyExpression, PyCallableParameter>();
        for (Map.Entry<PyExpression, PyCallableParameter> entry : mapping.entrySet()) {
            PyExpression argument = entry.getKey();
            PyCallableParameter parameter = entry.getValue();
            if (parameter.isPositionalContainer() || parameter.isKeywordContainer()) continue;
            result.put(argument, parameter);
        }
        LinkedHashMap<PyExpression, PyCallableParameter> linkedHashMap = result;
        if (linkedHashMap == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(88);
        }
        return linkedHashMap;
    }

    @Nullable
    public static PyCallableParameter getMappedPositionalContainer(@NotNull Map<PyExpression, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(89);
        }
        return mapping.values().stream().filter(p -> p.isPositionalContainer()).findFirst().orElse(null);
    }

    @Nullable
    public static PyCallableParameter getMappedKeywordContainer(@NotNull Map<PyExpression, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(90);
        }
        return mapping.values().stream().filter(p -> p.isKeywordContainer()).findFirst().orElse(null);
    }

    @NotNull
    private static ArgumentMappingResults analyzeArguments(@NotNull List<PyExpression> arguments, @NotNull List<PyCallableParameter> parameters) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(91);
        }
        if (parameters == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(92);
        }
        boolean positionalOnlyMode = ContainerUtil.exists(parameters, p -> p.getParameter() instanceof PySlashParameter);
        boolean seenSingleStar = false;
        boolean mappedVariadicArgumentsToParameters = false;
        LinkedHashMap<PyExpression, PyCallableParameter> mappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        ArrayList<PyCallableParameter> unmappedParameters = new ArrayList<PyCallableParameter>();
        ArrayList<PyExpression> unmappedArguments = new ArrayList<PyExpression>();
        ArrayList<PyCallableParameter> parametersMappedToVariadicKeywordArguments = new ArrayList<PyCallableParameter>();
        ArrayList<PyCallableParameter> parametersMappedToVariadicPositionalArguments = new ArrayList<PyCallableParameter>();
        LinkedHashMap<PyExpression, PyCallableParameter> tupleMappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        PositionalArgumentsAnalysisResults positionalResults = PyCallExpressionHelper.filterPositionalAndVariadicArguments(arguments);
        List<PyKeywordArgument> keywordArguments = PyCallExpressionHelper.filterKeywordArguments(arguments);
        List variadicPositionalArguments = positionalResults.variadicPositionalArguments;
        LinkedHashSet positionalComponentsOfVariadicArguments = new LinkedHashSet(positionalResults.componentsOfVariadicPositionalArguments);
        List<PyExpression> variadicKeywordArguments = PyCallExpressionHelper.filterVariadicKeywordArguments(arguments);
        List allPositionalArguments = positionalResults.allPositionalArguments;
        for (PyCallableParameter parameter : parameters) {
            PyParameter psi = parameter.getParameter();
            if (psi instanceof PyNamedParameter || psi == null) {
                PyExpression positionalArgument;
                PyKeywordArgument keywordArgument;
                String parameterName = parameter.getName();
                if (parameter.isPositionalContainer()) {
                    for (PyExpression pyExpression : allPositionalArguments) {
                        if (pyExpression == null) continue;
                        mappedParameters.put(pyExpression, parameter);
                    }
                    if (variadicPositionalArguments.size() == 1) {
                        mappedParameters.put((PyExpression)variadicPositionalArguments.get(0), parameter);
                    }
                    allPositionalArguments.clear();
                    variadicPositionalArguments.clear();
                    continue;
                }
                if (parameter.isKeywordContainer()) {
                    for (PyKeywordArgument pyKeywordArgument : keywordArguments) {
                        mappedParameters.put(pyKeywordArgument, parameter);
                    }
                    if (variadicKeywordArguments.size() == 1) {
                        mappedParameters.put(variadicKeywordArguments.get(0), parameter);
                    }
                    keywordArguments.clear();
                    variadicKeywordArguments.clear();
                    continue;
                }
                if (seenSingleStar) {
                    keywordArgument = PyCallExpressionHelper.removeKeywordArgument(keywordArguments, parameterName);
                    if (keywordArgument != null) {
                        mappedParameters.put(keywordArgument, parameter);
                        continue;
                    }
                    if (variadicKeywordArguments.isEmpty()) {
                        if (parameter.hasDefaultValue()) continue;
                        unmappedParameters.add(parameter);
                        continue;
                    }
                    parametersMappedToVariadicKeywordArguments.add(parameter);
                    mappedVariadicArgumentsToParameters = true;
                    continue;
                }
                if (positionalOnlyMode) {
                    positionalArgument = (PyExpression)PyCallExpressionHelper.next(allPositionalArguments);
                    if (positionalArgument != null) {
                        mappedParameters.put(positionalArgument, parameter);
                        continue;
                    }
                    if (parameter.hasDefaultValue()) continue;
                    unmappedParameters.add(parameter);
                    continue;
                }
                if (allPositionalArguments.isEmpty()) {
                    keywordArgument = PyCallExpressionHelper.removeKeywordArgument(keywordArguments, parameterName);
                    if (keywordArgument != null) {
                        mappedParameters.put(keywordArgument, parameter);
                        continue;
                    }
                    if (variadicPositionalArguments.isEmpty() && variadicKeywordArguments.isEmpty() && !parameter.hasDefaultValue()) {
                        unmappedParameters.add(parameter);
                        continue;
                    }
                    if (!variadicPositionalArguments.isEmpty()) {
                        parametersMappedToVariadicPositionalArguments.add(parameter);
                    }
                    if (!variadicKeywordArguments.isEmpty()) {
                        parametersMappedToVariadicKeywordArguments.add(parameter);
                    }
                    mappedVariadicArgumentsToParameters = true;
                    continue;
                }
                positionalArgument = (PyExpression)PyCallExpressionHelper.next(allPositionalArguments);
                if (positionalArgument != null) {
                    mappedParameters.put(positionalArgument, parameter);
                    if (!positionalComponentsOfVariadicArguments.contains(positionalArgument)) continue;
                    parametersMappedToVariadicPositionalArguments.add(parameter);
                    continue;
                }
                if (parameter.hasDefaultValue()) continue;
                unmappedParameters.add(parameter);
                continue;
            }
            if (psi instanceof PyTupleParameter) {
                PyExpression positionalArgument = (PyExpression)PyCallExpressionHelper.next(allPositionalArguments);
                if (positionalArgument != null) {
                    tupleMappedParameters.put(positionalArgument, parameter);
                    TupleMappingResults tupleMappingResults = PyCallExpressionHelper.mapComponentsOfTupleParameter(positionalArgument, (PyTupleParameter)psi);
                    mappedParameters.putAll(tupleMappingResults.getParameters());
                    unmappedParameters.addAll(tupleMappingResults.getUnmappedParameters());
                    unmappedArguments.addAll(tupleMappingResults.getUnmappedArguments());
                    continue;
                }
                if (variadicPositionalArguments.isEmpty()) {
                    if (parameter.hasDefaultValue()) continue;
                    unmappedParameters.add(parameter);
                    continue;
                }
                mappedVariadicArgumentsToParameters = true;
                continue;
            }
            if (psi instanceof PySlashParameter) {
                positionalOnlyMode = false;
                continue;
            }
            if (psi instanceof PySingleStarParameter) {
                seenSingleStar = true;
                continue;
            }
            if (parameter.hasDefaultValue()) continue;
            unmappedParameters.add(parameter);
        }
        if (mappedVariadicArgumentsToParameters) {
            variadicPositionalArguments.clear();
            variadicKeywordArguments.clear();
        }
        unmappedArguments.addAll(allPositionalArguments);
        unmappedArguments.addAll(keywordArguments);
        unmappedArguments.addAll(variadicPositionalArguments);
        unmappedArguments.addAll(variadicKeywordArguments);
        ArgumentMappingResults argumentMappingResults = new ArgumentMappingResults(mappedParameters, unmappedParameters, unmappedArguments, parametersMappedToVariadicPositionalArguments, parametersMappedToVariadicKeywordArguments, tupleMappedParameters);
        if (argumentMappingResults == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(93);
        }
        return argumentMappingResults;
    }

    @NotNull
    private static <E> Stream<E> forEveryScopeTakeOverloadsOtherwiseImplementations(@NotNull Collection<E> elements, @NotNull Function<? super E, PsiElement> mapper, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(94);
        }
        if (mapper == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(95);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(96);
        }
        if (!PyCallExpressionHelper.containsOverloadsAndImplementations(elements, mapper, context)) {
            Stream<E> stream = elements.stream();
            if (stream == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(97);
            }
            return stream;
        }
        Stream stream = StreamEx.of(elements).groupingBy(element -> Optional.ofNullable(ScopeUtil.getScopeOwner((PsiElement)mapper.apply((Object)element)))).values().stream().flatMap(oneScopeElements -> PyCallExpressionHelper.takeOverloadsOtherwiseImplementations(oneScopeElements, mapper, context));
        if (stream == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(98);
        }
        return stream;
    }

    private static <E> boolean containsOverloadsAndImplementations(@NotNull Collection<E> elements, @NotNull Function<? super E, PsiElement> mapper, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(99);
        }
        if (mapper == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(100);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(101);
        }
        boolean containsOverloads = false;
        boolean containsImplementations = false;
        for (E element : elements) {
            PsiElement mapped = mapper.apply(element);
            if (mapped == null) continue;
            boolean overload = PyiUtil.isOverload(mapped, context);
            if (!(containsOverloads |= overload) || !(containsImplementations |= !overload)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static <E> Stream<E> takeOverloadsOtherwiseImplementations(@NotNull List<E> elements, @NotNull Function<? super E, PsiElement> mapper, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(102);
        }
        if (mapper == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(103);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(104);
        }
        if (!PyCallExpressionHelper.containsOverloadsAndImplementations(elements, mapper, context)) {
            Stream stream = elements.stream();
            if (stream == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(105);
            }
            return stream;
        }
        Stream<Object> stream = elements.stream().filter(element -> {
            PsiElement mapped = (PsiElement)mapper.apply((Object)element);
            return mapped != null && PyiUtil.isOverload(mapped, context);
        });
        if (stream == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(106);
        }
        return stream;
    }

    @NotNull
    private static TupleMappingResults mapComponentsOfTupleParameter(@Nullable PyExpression argument, @NotNull PyTupleParameter parameter) {
        if (parameter == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(107);
        }
        ArrayList<PyCallableParameter> unmappedParameters = new ArrayList<PyCallableParameter>();
        ArrayList<PyExpression> unmappedArguments = new ArrayList<PyExpression>();
        LinkedHashMap<PyExpression, PyCallableParameter> mappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        if ((argument = PyPsiUtils.flattenParens(argument)) instanceof PySequenceExpression) {
            int i;
            PySequenceExpression sequenceExpr = (PySequenceExpression)argument;
            PyExpression[] argumentComponents = sequenceExpr.getElements();
            PyParameter[] parameterComponents = parameter.getContents();
            for (i = 0; i < parameterComponents.length; ++i) {
                PyParameter param = parameterComponents[i];
                if (i < argumentComponents.length) {
                    PyExpression arg = argumentComponents[i];
                    if (arg != null) {
                        if (param instanceof PyNamedParameter) {
                            mappedParameters.put(arg, PyCallableParameterImpl.psi(param));
                            continue;
                        }
                        if (param instanceof PyTupleParameter) {
                            TupleMappingResults nestedResults = PyCallExpressionHelper.mapComponentsOfTupleParameter(arg, (PyTupleParameter)param);
                            mappedParameters.putAll(nestedResults.getParameters());
                            unmappedParameters.addAll(nestedResults.getUnmappedParameters());
                            unmappedArguments.addAll(nestedResults.getUnmappedArguments());
                            continue;
                        }
                        unmappedArguments.add(arg);
                        continue;
                    }
                    unmappedParameters.add(PyCallableParameterImpl.psi(param));
                    continue;
                }
                unmappedParameters.add(PyCallableParameterImpl.psi(param));
            }
            if (argumentComponents.length > parameterComponents.length) {
                for (i = parameterComponents.length; i < argumentComponents.length; ++i) {
                    PyExpression arg = argumentComponents[i];
                    if (arg == null) continue;
                    unmappedArguments.add(arg);
                }
            }
        }
        TupleMappingResults tupleMappingResults = new TupleMappingResults(mappedParameters, unmappedParameters, unmappedArguments);
        if (tupleMappingResults == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(108);
        }
        return tupleMappingResults;
    }

    @Nullable
    private static PyKeywordArgument removeKeywordArgument(@NotNull List<PyKeywordArgument> arguments, @Nullable String name) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(109);
        }
        PyKeywordArgument result = null;
        for (PyKeywordArgument argument : arguments) {
            String keyword = argument.getKeyword();
            if (keyword == null || !keyword.equals(name)) continue;
            result = argument;
            break;
        }
        if (result != null) {
            arguments.remove(result);
        }
        return result;
    }

    @NotNull
    private static List<PyKeywordArgument> filterKeywordArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(110);
        }
        ArrayList<PyKeywordArgument> results = new ArrayList<PyKeywordArgument>();
        for (PyExpression argument : arguments) {
            if (!(argument instanceof PyKeywordArgument)) continue;
            results.add((PyKeywordArgument)argument);
        }
        ArrayList<PyKeywordArgument> arrayList = results;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(111);
        }
        return arrayList;
    }

    @NotNull
    private static PositionalArgumentsAnalysisResults filterPositionalAndVariadicArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(112);
        }
        ArrayList<PyExpression> variadicArguments = new ArrayList<PyExpression>();
        ArrayList<PyExpression> allPositionalArguments = new ArrayList<PyExpression>();
        ArrayList<PyExpression> componentsOfVariadicPositionalArguments = new ArrayList<PyExpression>();
        boolean seenVariadicPositionalArgument = false;
        boolean seenVariadicKeywordArgument = false;
        boolean seenKeywordArgument = false;
        for (PyExpression argument : arguments) {
            if (argument instanceof PyStarArgument) {
                if (((PyStarArgument)argument).isKeyword()) {
                    seenVariadicKeywordArgument = true;
                    continue;
                }
                seenVariadicPositionalArgument = true;
                PyExpression expr = PyPsiUtils.flattenParens((PyExpression)PsiTreeUtil.getChildOfType((PsiElement)argument, PyExpression.class));
                if (expr instanceof PySequenceExpression) {
                    PySequenceExpression sequenceExpr = (PySequenceExpression)expr;
                    List<PyExpression> elements = Arrays.asList(sequenceExpr.getElements());
                    allPositionalArguments.addAll(elements);
                    componentsOfVariadicPositionalArguments.addAll(elements);
                    continue;
                }
                variadicArguments.add(argument);
                continue;
            }
            if (argument instanceof PyKeywordArgument) {
                seenKeywordArgument = true;
                continue;
            }
            if (seenKeywordArgument || seenVariadicKeywordArgument || seenVariadicPositionalArgument && LanguageLevel.forElement((PsiElement)argument).isOlderThan(LanguageLevel.PYTHON35)) continue;
            allPositionalArguments.add(argument);
        }
        PositionalArgumentsAnalysisResults positionalArgumentsAnalysisResults = new PositionalArgumentsAnalysisResults(allPositionalArguments, componentsOfVariadicPositionalArguments, variadicArguments);
        if (positionalArgumentsAnalysisResults == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(113);
        }
        return positionalArgumentsAnalysisResults;
    }

    @NotNull
    private static List<PyExpression> filterVariadicKeywordArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(114);
        }
        ArrayList<PyExpression> results = new ArrayList<PyExpression>();
        for (PyExpression argument : arguments) {
            if (argument == null || !PyCallExpressionHelper.isVariadicKeywordArgument(argument)) continue;
            results.add(argument);
        }
        ArrayList<PyExpression> arrayList = results;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(115);
        }
        return arrayList;
    }

    public static boolean isVariadicKeywordArgument(@NotNull PyExpression argument) {
        if (argument == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(116);
        }
        return argument instanceof PyStarArgument && ((PyStarArgument)argument).isKeyword();
    }

    public static boolean isVariadicPositionalArgument(@NotNull PyExpression argument) {
        if (argument == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(117);
        }
        return argument instanceof PyStarArgument && !((PyStarArgument)argument).isKeyword();
    }

    @Nullable
    private static <T> T next(@NotNull List<T> list) {
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(118);
        }
        return list.isEmpty() ? null : (T)list.remove(0);
    }

    @NotNull
    private static List<PyCallableParameter> filterExplicitParameters(@NotNull List<PyCallableParameter> parameters, @Nullable PyCallable callable, @NotNull PyCallSiteExpression callSite, @NotNull PyResolveContext resolveContext) {
        PyCallExpression callExpr;
        PyExpression callee;
        if (parameters == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(119);
        }
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(120);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(121);
        }
        int implicitOffset = callSite instanceof PyCallExpression ? ((callee = (callExpr = (PyCallExpression)callSite).getCallee()) instanceof PyReferenceExpression && callable instanceof PyFunction ? PyCallExpressionHelper.getImplicitArgumentCount((PyReferenceExpression)callee, (PyFunction)callable, resolveContext) : 0) : 1;
        List<PyCallableParameter> list = parameters.subList(Math.min(implicitOffset, parameters.size()), parameters.size());
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(122);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 93: 
            case 97: 
            case 98: 
            case 105: 
            case 106: 
            case 108: 
            case 111: 
            case 113: 
            case 115: 
            case 122: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 93: 
            case 97: 
            case 98: 
            case 105: 
            case 106: 
            case 108: 
            case 111: 
            case 113: 
            case 115: 
            case 122: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 21: 
            case 51: 
            case 66: 
            case 69: 
            case 80: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 93: 
            case 97: 
            case 98: 
            case 105: 
            case 106: 
            case 108: 
            case 111: 
            case 113: 
            case 115: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper";
                break;
            }
            case 4: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 40: 
            case 42: 
            case 47: 
            case 56: 
            case 62: 
            case 75: 
            case 96: 
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callReference";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiers";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstClass";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 50: 
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markedCallee";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 65: 
            case 68: 
            case 73: 
            case 78: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableType";
                break;
            }
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 91: 
            case 109: 
            case 110: 
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 92: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 94: 
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 95: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCallee";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "clarifyResolveResult";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperCallType";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "multiMapArguments";
                break;
            }
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 76: 
            case 77: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "mapArguments";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCalleeFunction";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsMappedToPositionalContainer";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsMappedToKeywordContainer";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularMappedParameters";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeArguments";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "forEveryScopeTakeOverloadsOtherwiseImplementations";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "takeOverloadsOtherwiseImplementations";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "mapComponentsOfTupleParameter";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "filterKeywordArguments";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPositionalAndVariadicArguments";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "filterVariadicKeywordArguments";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExplicitParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCallee";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 93: 
            case 97: 
            case 98: 
            case 105: 
            case 106: 
            case 108: 
            case 111: 
            case 113: 
            case 115: 
            case 122: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCalleesFromProviders";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clarifyResolveResult";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "markResolveResult";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitArgumentCount";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isQualifiedByInstance";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isQualifiedByClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "belongsToSpecifiedClassHierarchy";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCallResultTypeFromUnion";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCallTargetReturnType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyCallType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallType";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallTypeForArguments";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassUnionType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "multiMapArguments";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "mapArguments";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCalleeFunction";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsMappedToPositionalContainer";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsMappedToKeywordContainer";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getRegularMappedParameters";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getMappedPositionalContainer";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getMappedKeywordContainer";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "analyzeArguments";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "forEveryScopeTakeOverloadsOtherwiseImplementations";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "containsOverloadsAndImplementations";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "takeOverloadsOtherwiseImplementations";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "mapComponentsOfTupleParameter";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "removeKeywordArgument";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "filterKeywordArguments";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "filterPositionalAndVariadicArguments";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "filterVariadicKeywordArguments";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isVariadicKeywordArgument";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isVariadicPositionalArgument";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "filterExplicitParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 93: 
            case 97: 
            case 98: 
            case 105: 
            case 106: 
            case 108: 
            case 111: 
            case 113: 
            case 115: 
            case 122: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClarifiedResolveResult {
        @NotNull
        private final QualifiedRatedResolveResult myOriginalResolveResult;
        @NotNull
        private final PsiElement myClarifiedResolved;
        @Nullable
        private final PyFunction.Modifier myWrappedModifier;
        private final boolean myIsConstructor;

        ClarifiedResolveResult(@NotNull QualifiedRatedResolveResult originalResolveResult, @NotNull PsiElement clarifiedResolved, @Nullable PyFunction.Modifier wrappedModifier, boolean isConstructor) {
            if (originalResolveResult == null) {
                ClarifiedResolveResult.$$$reportNull$$$0(0);
            }
            if (clarifiedResolved == null) {
                ClarifiedResolveResult.$$$reportNull$$$0(1);
            }
            this.myOriginalResolveResult = originalResolveResult;
            this.myClarifiedResolved = clarifiedResolved;
            this.myWrappedModifier = wrappedModifier;
            this.myIsConstructor = isConstructor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clarifiedResolved";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$ClarifiedResolveResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PositionalArgumentsAnalysisResults {
        @NotNull
        private final List<PyExpression> allPositionalArguments;
        @NotNull
        private final List<PyExpression> componentsOfVariadicPositionalArguments;
        @NotNull
        private final List<PyExpression> variadicPositionalArguments;

        PositionalArgumentsAnalysisResults(@NotNull List<PyExpression> allPositionalArguments, @NotNull List<PyExpression> componentsOfVariadicPositionalArguments, @NotNull List<PyExpression> variadicPositionalArguments) {
            if (allPositionalArguments == null) {
                PositionalArgumentsAnalysisResults.$$$reportNull$$$0(0);
            }
            if (componentsOfVariadicPositionalArguments == null) {
                PositionalArgumentsAnalysisResults.$$$reportNull$$$0(1);
            }
            if (variadicPositionalArguments == null) {
                PositionalArgumentsAnalysisResults.$$$reportNull$$$0(2);
            }
            this.allPositionalArguments = allPositionalArguments;
            this.componentsOfVariadicPositionalArguments = componentsOfVariadicPositionalArguments;
            this.variadicPositionalArguments = variadicPositionalArguments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allPositionalArguments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentsOfVariadicPositionalArguments";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variadicPositionalArguments";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$PositionalArgumentsAnalysisResults";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TupleMappingResults {
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myParameters;
        @NotNull
        private final List<PyCallableParameter> myUnmappedParameters;
        @NotNull
        private final List<PyExpression> myUnmappedArguments;

        TupleMappingResults(@NotNull Map<PyExpression, PyCallableParameter> mappedParameters, @NotNull List<PyCallableParameter> unmappedParameters, @NotNull List<PyExpression> unmappedArguments) {
            if (mappedParameters == null) {
                TupleMappingResults.$$$reportNull$$$0(0);
            }
            if (unmappedParameters == null) {
                TupleMappingResults.$$$reportNull$$$0(1);
            }
            if (unmappedArguments == null) {
                TupleMappingResults.$$$reportNull$$$0(2);
            }
            this.myParameters = mappedParameters;
            this.myUnmappedParameters = unmappedParameters;
            this.myUnmappedArguments = unmappedArguments;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myParameters;
            if (map2 == null) {
                TupleMappingResults.$$$reportNull$$$0(3);
            }
            return map2;
        }

        @NotNull
        public List<PyCallableParameter> getUnmappedParameters() {
            List<PyCallableParameter> list = this.myUnmappedParameters;
            if (list == null) {
                TupleMappingResults.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public List<PyExpression> getUnmappedArguments() {
            List<PyExpression> list = this.myUnmappedArguments;
            if (list == null) {
                TupleMappingResults.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedArguments";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$TupleMappingResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$TupleMappingResults";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ArgumentMappingResults {
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedParameters;
        @NotNull
        private final List<PyCallableParameter> myUnmappedParameters;
        @NotNull
        private final List<PyExpression> myUnmappedArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicPositionalArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicKeywordArguments;
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedTupleParameters;

        public ArgumentMappingResults(@NotNull Map<PyExpression, PyCallableParameter> mappedParameters, @NotNull List<PyCallableParameter> unmappedParameters, @NotNull List<PyExpression> unmappedArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicPositionalArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicKeywordArguments, @NotNull Map<PyExpression, PyCallableParameter> mappedTupleParameters) {
            if (mappedParameters == null) {
                ArgumentMappingResults.$$$reportNull$$$0(0);
            }
            if (unmappedParameters == null) {
                ArgumentMappingResults.$$$reportNull$$$0(1);
            }
            if (unmappedArguments == null) {
                ArgumentMappingResults.$$$reportNull$$$0(2);
            }
            if (parametersMappedToVariadicPositionalArguments == null) {
                ArgumentMappingResults.$$$reportNull$$$0(3);
            }
            if (parametersMappedToVariadicKeywordArguments == null) {
                ArgumentMappingResults.$$$reportNull$$$0(4);
            }
            if (mappedTupleParameters == null) {
                ArgumentMappingResults.$$$reportNull$$$0(5);
            }
            this.myMappedParameters = mappedParameters;
            this.myUnmappedParameters = unmappedParameters;
            this.myUnmappedArguments = unmappedArguments;
            this.myParametersMappedToVariadicPositionalArguments = parametersMappedToVariadicPositionalArguments;
            this.myParametersMappedToVariadicKeywordArguments = parametersMappedToVariadicKeywordArguments;
            this.myMappedTupleParameters = mappedTupleParameters;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedParameters;
            if (map2 == null) {
                ArgumentMappingResults.$$$reportNull$$$0(6);
            }
            return map2;
        }

        @NotNull
        public List<PyCallableParameter> getUnmappedParameters() {
            List<PyCallableParameter> list = this.myUnmappedParameters;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(7);
            }
            return list;
        }

        @NotNull
        public List<PyExpression> getUnmappedArguments() {
            List<PyExpression> list = this.myUnmappedArguments;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicPositionalArguments() {
            List<PyCallableParameter> list = this.myParametersMappedToVariadicPositionalArguments;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicKeywordArguments() {
            List<PyCallableParameter> list = this.myParametersMappedToVariadicKeywordArguments;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(10);
            }
            return list;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedTupleParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedTupleParameters;
            if (map2 == null) {
                ArgumentMappingResults.$$$reportNull$$$0(11);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedArguments";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedTupleParameters";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$ArgumentMappingResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$ArgumentMappingResults";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedParameters";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedParameters";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedTupleParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

