/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyAnnotationOwnerStub;
import com.jetbrains.python.psi.stubs.PyTypeCommentOwnerStub;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBaseElementImpl<T extends StubElement>
extends StubBasedPsiElementBase<T>
implements PyElement {
    public PyBaseElementImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public PyBaseElementImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PythonLanguage getLanguage() {
        PythonLanguage pythonLanguage = (PythonLanguage)PythonFileType.INSTANCE.getLanguage();
        if (pythonLanguage == null) {
            PyBaseElementImpl.$$$reportNull$$$0(0);
        }
        return pythonLanguage;
    }

    public String toString() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos >= 0) {
            className = className.substring(pos + 1);
        }
        className = StringUtil.trimEnd((String)className, (String)"Impl");
        return className;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement element = PyiUtil.getOriginalElement(this);
        PsiElement psiElement = element != null ? element : super.getNavigationElement();
        if (psiElement == null) {
            PyBaseElementImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PyBaseElementImpl.$$$reportNull$$$0(2);
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)this));
        if (visitor2 instanceof PyElementVisitor) {
            this.acceptPyVisitor((PyElementVisitor)visitor2);
        } else {
            super.accept(visitor2);
        }
    }

    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyElement(this);
    }

    @NotNull
    protected <T extends PyElement> T[] childrenToPsi(TokenSet filterSet, T[] array) {
        ASTNode[] nodes = this.getNode().getChildren(filterSet);
        PyElement[] pyElementArray = PyPsiUtils.nodesToPsi((ASTNode[])nodes, array);
        if (pyElementArray == null) {
            PyBaseElementImpl.$$$reportNull$$$0(3);
        }
        return pyElementArray;
    }

    @Nullable
    protected <T extends PyElement> T childToPsi(TokenSet filterSet, int index) {
        ASTNode[] nodes = this.getNode().getChildren(filterSet);
        if (nodes.length <= index) {
            return null;
        }
        return (T)((PyElement)nodes[index].getPsi());
    }

    @Nullable
    protected <T extends PyElement> T childToPsi(IElementType elType) {
        ASTNode node = this.getNode().findChildByType(elType);
        if (node == null) {
            return null;
        }
        return (T)((PyElement)node.getPsi());
    }

    @Nullable
    protected <T extends PyElement> T childToPsi(@NotNull TokenSet elTypes) {
        ASTNode node;
        if (elTypes == null) {
            PyBaseElementImpl.$$$reportNull$$$0(4);
        }
        return (T)((node = this.getNode().findChildByType(elTypes)) != null ? (PyElement)node.getPsi() : null);
    }

    @NotNull
    protected <T extends PyElement> T childToPsiNotNull(TokenSet filterSet, int index) {
        T child = this.childToPsi(filterSet, index);
        if (child == null) {
            throw new RuntimeException("child must not be null: expression text " + this.getText());
        }
        T t = child;
        if (t == null) {
            PyBaseElementImpl.$$$reportNull$$$0(5);
        }
        return t;
    }

    @NotNull
    protected <T extends PyElement> T childToPsiNotNull(IElementType elType) {
        T child = this.childToPsi(elType);
        if (child == null) {
            throw new RuntimeException("child must not be null; expression text " + this.getText());
        }
        T t = child;
        if (t == null) {
            PyBaseElementImpl.$$$reportNull$$$0(6);
        }
        return t;
    }

    public PsiReference findReferenceAt(int offset) {
        PyResolveContext resolveContext;
        PsiElement element = this.findElementAt(offset);
        if (element == null || element instanceof OuterLanguageElement) {
            return null;
        }
        offset = this.getTextRange().getStartOffset() + offset - element.getTextRange().getStartOffset();
        ArrayList<PsiReference> referencesList = new ArrayList<PsiReference>();
        PsiFile file = element.getContainingFile();
        PyResolveContext pyResolveContext = resolveContext = file != null ? PyResolveContext.defaultContext().withTypeEvalContext(TypeEvalContext.codeAnalysis(file.getProject(), file)) : PyResolveContext.defaultContext();
        while (element != null) {
            PyBaseElementImpl.addReferences(offset, element, referencesList, resolveContext);
            offset = element.getStartOffsetInParent() + offset;
            if (element instanceof PsiFile) break;
            element = element.getParent();
        }
        if (referencesList.isEmpty()) {
            return null;
        }
        if (referencesList.size() == 1) {
            return (PsiReference)referencesList.get(0);
        }
        return new PsiMultiReference(referencesList.toArray(PsiReference.EMPTY_ARRAY), ((PsiReference)referencesList.get(referencesList.size() - 1)).getElement());
    }

    private static void addReferences(int offset, PsiElement element, Collection<PsiReference> outReferences, PyResolveContext resolveContext) {
        PsiReference[] references2;
        if (element instanceof PyReferenceOwner) {
            PsiReference[] psiReferenceArray;
            PsiPolyVariantReference reference = ((PyReferenceOwner)element).getReference(resolveContext);
            if (reference == null) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            } else {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = reference;
            }
            references2 = psiReferenceArray;
        } else {
            references2 = element.getReferences();
        }
        for (PsiReference reference : references2) {
            for (TextRange range : ReferenceRange.getRanges((PsiReference)reference)) {
                assert (range != null) : reference;
                if (!range.containsOffset(offset)) continue;
                outReferences.add(reference);
            }
        }
    }

    @Nullable
    protected static <T extends StubBasedPsiElement<? extends PyAnnotationOwnerStub> & PyAnnotationOwner> String getAnnotationContentFromStubOrPsi(@NotNull T elem) {
        PyAnnotationOwnerStub stub;
        if (elem == null) {
            PyBaseElementImpl.$$$reportNull$$$0(7);
        }
        if ((stub = (PyAnnotationOwnerStub)elem.getStub()) != null) {
            return stub.getAnnotation();
        }
        return PyBaseElementImpl.getAnnotationContentFromPsi(elem);
    }

    @Nullable
    protected static <T extends PyAnnotationOwner> String getAnnotationContentFromPsi(@NotNull T elem) {
        PyExpression annotationValue;
        PyAnnotation annotation;
        if (elem == null) {
            PyBaseElementImpl.$$$reportNull$$$0(8);
        }
        if ((annotation = elem.getAnnotation()) != null && (annotationValue = annotation.getValue()) != null) {
            return annotationValue.getText();
        }
        return null;
    }

    @Nullable
    protected static <T extends StubBasedPsiElement<? extends PyTypeCommentOwnerStub> & PyTypeCommentOwner> String getTypeCommentAnnotationFromStubOrPsi(@NotNull T elem) {
        PyTypeCommentOwnerStub stub;
        if (elem == null) {
            PyBaseElementImpl.$$$reportNull$$$0(9);
        }
        if ((stub = (PyTypeCommentOwnerStub)elem.getStub()) != null) {
            return stub.getTypeComment();
        }
        PsiComment comment = ((PyTypeCommentOwner)elem).getTypeComment();
        if (comment != null) {
            return PyTypingTypeProvider.getTypeCommentValue(comment.getText());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyBaseElementImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elTypes";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyBaseElementImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenToPsi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "childToPsiNotNull";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "childToPsi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationContentFromStubOrPsi";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationContentFromPsi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentAnnotationFromStubOrPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

