/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyCustomPackageManagers;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyUnsupportedPackageManager;
import com.jetbrains.python.packaging.pipenv.PyPipEnvPackageManagementService;
import com.jetbrains.python.packaging.pipenv.PyPipEnvPackageManager;
import com.jetbrains.python.packaging.ui.PyCondaManagementService;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyPackageManagersImpl
extends PyPackageManagers {
    private final Map<String, PyPackageManager> myInstances = new HashMap<String, PyPackageManager>();

    @Override
    @NotNull
    public synchronized PyPackageManager forSdk(@NotNull Sdk sdk) {
        String key;
        PyPackageManager manager;
        if (sdk == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(0);
        }
        if ((manager = this.myInstances.get(key = PythonSdkType.getSdkKey(sdk))) == null) {
            VirtualFile homeDirectory = sdk.getHomeDirectory();
            PyPackageManager customPackageManager = PyCustomPackageManagers.tryCreateCustomPackageManager(sdk);
            manager = customPackageManager != null ? customPackageManager : (PythonSdkType.isRemote(sdk) ? new PyUnsupportedPackageManager(sdk) : (PipenvKt.isPipEnv(sdk) ? new PyPipEnvPackageManager(sdk) : (PyCondaPackageManagerImpl.isConda(sdk) && homeDirectory != null && PyCondaPackageService.getCondaExecutable(sdk.getHomePath()) != null ? new PyCondaPackageManagerImpl(sdk) : new PyPackageManagerImpl(sdk))));
            this.myInstances.put(key, manager);
        }
        PyPackageManager pyPackageManager = manager;
        if (pyPackageManager == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(1);
        }
        return pyPackageManager;
    }

    public PyPackageManagementService getManagementService(Project project, Sdk sdk) {
        if (PyCondaPackageManagerImpl.isConda(sdk)) {
            return new PyCondaManagementService(project, sdk);
        }
        if (PipenvKt.isPipEnv(sdk)) {
            return new PyPipEnvPackageManagementService(project, sdk);
        }
        return new PyPackageManagementService(project, sdk);
    }

    @Override
    public void clearCache(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(2);
        }
        String key = PythonSdkType.getSdkKey(sdk);
        this.myInstances.remove(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagersImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagersImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forSdk";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

