/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCondaPackageManagerImpl
extends PyPackageManagerImpl {
    @Nullable
    private volatile List<PyPackage> mySideCache;
    public static final String PYTHON = "python";
    public boolean useConda;

    public boolean useConda() {
        return this.useConda;
    }

    public void useConda(boolean conda) {
        this.useConda = conda;
    }

    PyCondaPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(0);
        }
        super(sdk);
        this.mySideCache = null;
        this.useConda = true;
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        if (extraArgs == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.useConda) {
            if (requirements == null) {
                return;
            }
            ArrayList<String> arguments = new ArrayList<String>();
            for (PyRequirement requirement : requirements) {
                arguments.add(requirement.getPresentableText());
            }
            arguments.add("-y");
            if (!extraArgs.contains("-U")) {
                arguments.addAll(extraArgs);
            }
            this.getCondaOutput("install", arguments);
        } else {
            super.install(requirements, extraArgs);
        }
    }

    private ProcessOutput getCondaOutput(@NotNull String command, List<String> arguments) throws ExecutionException {
        if (command == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(2);
        }
        Sdk sdk = this.getSdk();
        String path = this.getCondaDirectory();
        if (path == null) {
            throw new PyExecutionException("Empty conda name for " + sdk.getHomePath(), command, arguments);
        }
        ArrayList parameters = Lists.newArrayList((Object[])new String[]{command, "-p", path});
        parameters.addAll(arguments);
        return PyCondaRunKt.runConda(sdk, (List<String>)parameters);
    }

    @Nullable
    private String getCondaDirectory() {
        VirtualFile condaDirectory = PyCondaPackageManagerImpl.getCondaDirectory(this.getSdk());
        return condaDirectory == null ? null : condaDirectory.getPath();
    }

    @Nullable
    public static VirtualFile getCondaDirectory(@NotNull Sdk sdk) {
        VirtualFile homeDirectory;
        if (sdk == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(3);
        }
        if ((homeDirectory = sdk.getHomeDirectory()) == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return homeDirectory.getParent();
        }
        return homeDirectory.getParent().getParent();
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.useConda) {
            super.install(requirementString);
        } else {
            this.getCondaOutput("install", Lists.newArrayList((Object[])new String[]{requirementString, "-y"}));
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        if (packages == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.useConda) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (PyPackage aPackage : packages) {
                arguments.add(aPackage.getName());
            }
            arguments.add("-y");
            this.getCondaOutput("remove", arguments);
        } else {
            super.uninstall(packages);
        }
    }

    @Override
    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        List<PyPackage> pipPackages = super.collectPackages();
        ProcessOutput output = this.getCondaOutput("list", Lists.newArrayList((Object[])new String[]{"-e"}));
        Set condaPackages = Sets.newConcurrentHashSet(this.parseCondaToolOutput(output.getStdout()));
        if (this.useConda) {
            this.mySideCache = pipPackages;
            ArrayList arrayList = Lists.newArrayList((Iterable)condaPackages);
            if (arrayList == null) {
                PyCondaPackageManagerImpl.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        this.mySideCache = Lists.newArrayList((Iterable)condaPackages);
        List<PyPackage> list = super.collectPackages();
        if (list == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        return this.useConda || super.hasManagement();
    }

    @NotNull
    private List<PyPackage> parseCondaToolOutput(@NotNull String s) throws ExecutionException {
        if (s == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(8);
        }
        String[] lines = StringUtil.splitByLines((String)s);
        ArrayList<PyPackage> packages = new ArrayList<PyPackage>();
        for (String line2 : lines) {
            if (line2.startsWith("#")) continue;
            List fields = StringUtil.split((String)line2, (String)"=");
            if (fields.size() < 3) {
                throw new PyExecutionException("Invalid conda output format", "conda", Collections.emptyList());
            }
            String name = (String)fields.get(0);
            String version = (String)fields.get(1);
            ArrayList<PyRequirement> requirements = new ArrayList<PyRequirement>();
            if (fields.size() >= 4) {
                String requiresLine = (String)fields.get(3);
                String requiresSpec = StringUtil.join((Collection)StringUtil.split((String)requiresLine, (String)":"), (String)"\n");
                requirements.addAll(this.parseRequirements(requiresSpec));
            }
            if ("Python".equals(name)) continue;
            packages.add(new PyPackage(name, version, "", requirements));
        }
        ArrayList<PyPackage> arrayList = packages;
        if (arrayList == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(10);
        }
        return PyCondaPackageManagerImpl.isCondaVirtualEnv(sdk.getHomePath());
    }

    public static boolean isCondaVirtualEnv(@Nullable String sdkPath) {
        VirtualFile condaMeta = PyCondaPackageManagerImpl.findCondaMeta(sdkPath);
        if (condaMeta == null) {
            return false;
        }
        VirtualFile envs = condaMeta.getParent().findChild("envs");
        return envs == null;
    }

    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(11);
        }
        return PyCondaPackageManagerImpl.isConda(sdk.getHomePath());
    }

    public static boolean isConda(@Nullable String sdkPath) {
        return PyCondaPackageManagerImpl.findCondaMeta(sdkPath) != null;
    }

    @Nullable
    private static VirtualFile findCondaMeta(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        VirtualFile homeDirectory = StandardFileSystems.local().findFileByPath(sdkPath);
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile condaParent = SystemInfo.isWindows ? homeDirectory.getParent() : homeDirectory.getParent().getParent();
        return condaParent.findChild("conda-meta");
    }

    @NotNull
    public static String createVirtualEnv(@Nullable String condaExecutable, @NotNull String destinationDir, @NotNull String version) throws ExecutionException {
        if (destinationDir == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(12);
        }
        if (version == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(13);
        }
        if (condaExecutable == null) {
            throw new PyExecutionException("Cannot find conda", "Conda", Collections.emptyList(), new ProcessOutput());
        }
        ArrayList parameters = Lists.newArrayList((Object[])new String[]{"create", "-p", destinationDir, "-y", "python=" + version});
        PyCondaRunKt.runConda(condaExecutable, (List<String>)parameters);
        String binary = PythonSdkType.getPythonExecutable(destinationDir);
        String binaryFallback = destinationDir + File.separator + "bin" + File.separator + PYTHON;
        String string = binary != null ? binary : binaryFallback;
        if (string == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> packagesCache = this.mySideCache;
        if (packagesCache == null) {
            return null;
        }
        ArrayList packages = Lists.newArrayList(packagesCache);
        List<PyPackage> condaPackages = super.getPackages();
        if (condaPackages == null) {
            return null;
        }
        packages.addAll(condaPackages);
        return Collections.unmodifiableList(packages);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCondaToolOutput";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCondaOutput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCondaDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uninstall";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseCondaToolOutput";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

