/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class CreateClassQuickFix
implements LocalQuickFix {
    private final String myClassName;
    private final SmartPsiElementPointer<PsiElement> myAnchor;

    public CreateClassQuickFix(String className, PsiElement anchor) {
        this.myClassName = className;
        Project project = anchor.getProject();
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(anchor);
        PsiLanguageInjectionHost notInjectedAnchor = injectionHost != null ? injectionHost : anchor;
        this.myAnchor = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)notInjectedAnchor);
    }

    @NotNull
    public String getName() {
        if (this.myAnchor instanceof PyFile) {
            String string = "Create class '" + this.myClassName + "' in module " + ((PyFile)this.myAnchor).getName();
            if (string == null) {
                CreateClassQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = "Create class '" + this.myClassName + "'";
        if (string == null) {
            CreateClassQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create class" == null) {
            CreateClassQuickFix.$$$reportNull$$$0(2);
        }
        return "Create class";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement anchor;
        if (project == null) {
            CreateClassQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            CreateClassQuickFix.$$$reportNull$$$0(4);
        }
        if ((anchor = this.myAnchor.getElement()) == null || !anchor.isValid()) {
            return;
        }
        if (!(anchor instanceof PyFile)) {
            anchor = PyPsiUtils.getParentRightBefore(anchor, (PsiElement)anchor.getContainingFile());
            assert (anchor != null);
        }
        PyClass pyClass = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyClass.class, "class " + this.myClassName + "(object):\n    pass");
        pyClass = anchor instanceof PyFile ? (PyClass)anchor.add((PsiElement)pyClass) : (PyClass)anchor.getParent().addBefore((PsiElement)pyClass, anchor);
        pyClass = (PyClass)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)pyClass);
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)pyClass);
        builder.replaceElement((PsiElement)pyClass.getSuperClassExpressions()[0], "object");
        builder.replaceElement((PsiElement)pyClass.getStatementList(), "pass");
        FileEditor editor2 = FileEditorManager.getInstance((Project)project).getSelectedEditor(anchor.getContainingFile().getVirtualFile());
        if (!(editor2 instanceof TextEditor)) {
            return;
        }
        builder.run(((TextEditor)editor2).getEditor(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

