/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyNonAsciiCharInspection
extends PyInspection {
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.non.ascii", new Object[0]);
        if (string == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    public JComponent createOptionsPanel() {
        JComboBox<String> defaultEncoding = new JComboBox<String>(PyEncodingUtil.POSSIBLE_ENCODINGS);
        defaultEncoding.setSelectedItem(this.myDefaultEncoding);
        defaultEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyNonAsciiCharInspection.this.myDefaultEncoding = (String)cb.getSelectedItem();
            }
        });
        JComboBox<String> encodingFormat = new JComboBox<String>(PyEncodingUtil.ENCODING_FORMAT);
        encodingFormat.setSelectedIndex(this.myEncodingFormatIndex);
        encodingFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyNonAsciiCharInspection.this.myEncodingFormatIndex = cb.getSelectedIndex();
            }
        });
        return PyEncodingUtil.createEncodingOptionsPanel(defaultEncoding, encodingFormat);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        public void visitComment(PsiComment node) {
            this.checkString((PsiElement)node, node.getText());
        }

        private void checkString(PsiElement node, String value) {
            if (LanguageLevel.forElement(node).isPython2()) {
                PsiFile file = node.getContainingFile();
                if (file == null) {
                    return;
                }
                String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(file);
                boolean hasNonAscii = false;
                CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
                int length = value.length();
                char c = '\u0000';
                for (int i = 0; i < length; ++i) {
                    c = value.charAt(i);
                    if (asciiEncoder.canEncode(c)) continue;
                    hasNonAscii = true;
                    break;
                }
                if (hasNonAscii && charsetString == null) {
                    this.registerProblem(node, "Non-ASCII character " + c + " in file, but no encoding declared", new AddEncodingQuickFix(PyNonAsciiCharInspection.this.myDefaultEncoding, PyNonAsciiCharInspection.this.myEncodingFormatIndex));
                }
            }
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            this.checkString(node, node.getText());
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            this.checkString((PsiElement)node, node.getText());
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            this.checkString(node, node.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyNonAsciiCharInspection$Visitor", "<init>"));
        }
    }
}

