/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.pipenv.UsePipEnvQuickFix;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInterpreterInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.invalid.interpreter", new Object[0]);
        if (string == null) {
            PyInterpreterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyInterpreterInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyInterpreterInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyInterpreterInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ConfigureInterpreterFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            if ("Configure Python interpreter" == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(0);
            }
            return "Configure Python interpreter";
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(2);
            }
            ConfigureInterpreterFix.showProjectInterpreterDialog(project);
        }

        public static void showProjectInterpreterDialog(@NotNull Project project) {
            if (project == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(3);
            }
            ShowSettingsUtil.getInstance().showSettingsDialog(project, "Project Interpreter");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "showProjectInterpreterDialog";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            String product;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            if (module2 == null) {
                return;
            }
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            boolean pyCharm = PlatformUtils.isPyCharm();
            String interpreterOwner = pyCharm ? "project" : "module";
            ArrayList<Object> fixes = new ArrayList<Object>();
            if (UsePipEnvQuickFix.Companion.isApplicable(module2)) {
                fixes.add(new UsePipEnvQuickFix(sdk, module2));
            }
            if (pyCharm) {
                fixes.add(new ConfigureInterpreterFix());
            }
            String string = product = pyCharm ? "PyCharm" : "Python plugin";
            if (sdk == null) {
                this.registerProblem((PsiElement)node, "No Python interpreter configured for the " + interpreterOwner, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            } else {
                String associatedName;
                Module associatedModule2 = PySdkExtKt.getAssociatedModule(sdk);
                String string2 = associatedName = associatedModule2 != null ? associatedModule2.getName() : PySdkExtKt.getAssociatedModulePath(sdk);
                if (PipenvKt.isPipEnv(sdk) && associatedModule2 != module2) {
                    String message = associatedName != null ? "Pipenv interpreter is associated with another " + interpreterOwner + ": '" + associatedName + "'" : "Pipenv interpreter is not associated with any " + interpreterOwner;
                    this.registerProblem((PsiElement)node, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                } else if (PythonSdkType.isInvalid(sdk)) {
                    this.registerProblem((PsiElement)node, "Invalid Python interpreter selected for the " + interpreterOwner, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                } else {
                    LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
                    if (!LanguageLevel.SUPPORTED_LEVELS.contains((Object)languageLevel)) {
                        this.registerProblem((PsiElement)node, "Python " + (Object)((Object)languageLevel) + " has reached its end-of-life date and it is no longer supported in " + product + ".", fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor", "<init>"));
        }
    }
}

