/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.stdlib.PyDataclassParameters;
import com.jetbrains.python.codeInsight.stdlib.PyDataclassesKt;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyDataclassInspection;
import com.jetbrains.python.inspections.PyDataclassInspection$Visitor$visitPyDelStatement$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyNamedTupleInspection;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.stubs.PyDataclassFieldStubImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyDataclassFieldStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "Visitor", "intellij.python.community.impl"})
public final class PyDataclassInspection
extends PyInspection {
    private static final Set<String> ORDER_OPERATORS;
    private static final Set<String> DATACLASSES_HELPERS;
    private static final Set<String> ATTRS_HELPERS;
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new Visitor(holder, session);
    }

    static {
        Companion = new Companion(null);
        ORDER_OPERATORS = SetsKt.setOf((Object[])new String[]{"__lt__", "__le__", "__gt__", "__ge__"});
        DATACLASSES_HELPERS = SetsKt.setOf((Object[])new String[]{"dataclasses.fields", "dataclasses.asdict", "dataclasses.astuple", "dataclasses.replace"});
        ATTRS_HELPERS = SetsKt.setOf((Object[])new String[]{"attr.fields", "attr.fields_dict", "attr.asdict", "attr.astuple", "attr.assoc", "attr.evolve"});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J2\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010 \u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010+\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010,\u001a\u00020\b2\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u0012H\u0002J\u001a\u00104\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u0012H\u0002J.\u00105\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$2\f\u00106\u001a\b\u0012\u0004\u0012\u00020!07H\u0002J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0016J\u0012\u0010;\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010=\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010>\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010?H\u0016J\u0012\u0010@\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010AH\u0016J\u0012\u0010B\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010!H\u0016\u00a8\u0006C"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "checkMutatingFrozenAttribute", "", "expression", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "getDataclassHierarchyOrder", "Lkotlin/Pair;", "Lcom/jetbrains/python/inspections/PyDataclassInspection$Companion$ClassOrder;", "Lcom/jetbrains/python/codeInsight/stdlib/PyDataclassParameters$Type;", "cls", "Lcom/jetbrains/python/psi/PyClass;", "operator", "", "getDataclassOrder", "getInstancePyClass", "element", "Lcom/jetbrains/python/psi/PyTypedElement;", "isExpectedDataclass", "", "type", "Lcom/jetbrains/python/psi/types/PyType;", "dataclassType", "allowDefinition", "allowInstance", "allowSubclass", "isInitVar", "field", "Lcom/jetbrains/python/psi/PyTargetExpression;", "processAnnotationsExistence", "dataclassParameters", "Lcom/jetbrains/python/codeInsight/stdlib/PyDataclassParameters;", "processAsInitVar", "postInit", "Lcom/jetbrains/python/psi/PyFunction;", "processAttrIbFunctionCalls", "processAttrsDefaultThroughDecorator", "processAttrsInitializersAndValidators", "processAttrsParameters", "processAttrsPostInitDefinition", "processDataclassParameters", "processDefaultFieldValue", "processFieldFunctionCall", "processHelperAttrsArgument", "argument", "Lcom/jetbrains/python/psi/PyExpression;", "calleeQName", "processHelperDataclassArgument", "processPostInitDefinition", "localInitVars", "", "visitPyBinaryExpression", "node", "Lcom/jetbrains/python/psi/PyBinaryExpression;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyClass", "visitPyDelStatement", "Lcom/jetbrains/python/psi/PyDelStatement;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitPyTargetExpression", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyTargetExpression(@Nullable PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            if (node != null) {
                this.checkMutatingFrozenAttribute(node);
            }
        }

        @Override
        public void visitPyDelStatement(@Nullable PyDelStatement node) {
            super.visitPyDelStatement(node);
            if (node != null) {
                Object[] objectArray = node.getTargets();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node\n          .targets");
                Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])objectArray);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyDelStatement$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$forEach$iv = sequence;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyReferenceExpression it = (PyReferenceExpression)element$iv;
                    boolean bl = false;
                    this.checkMutatingFrozenAttribute(it);
                }
            }
        }

        @Override
        public void visitPyClass(@Nullable PyClass node) {
            super.visitPyClass(node);
            if (node != null) {
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyDataclassParameters dataclassParameters = PyDataclassesKt.parseDataclassParameters(node, typeEvalContext);
                if (dataclassParameters != null) {
                    if (dataclassParameters.getType() == PyDataclassParameters.Type.STD) {
                        this.processDataclassParameters(node, dataclassParameters);
                        PyFunction postInit = node.findMethodByName("__post_init__", false, this.myTypeEvalContext);
                        boolean bl = false;
                        List localInitVars = new ArrayList();
                        node.processClassLevelDeclarations(new PsiScopeProcessor(this, postInit, localInitVars){
                            final /* synthetic */ Visitor this$0;
                            final /* synthetic */ PyFunction $postInit;
                            final /* synthetic */ List $localInitVars;

                            public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                if (element instanceof PyTargetExpression) {
                                    if (!PyTypingTypeProvider.isClassVar((PyAnnotationOwner)element, this.this$0.myTypeEvalContext)) {
                                        Visitor.access$processDefaultFieldValue(this.this$0, (PyTargetExpression)element);
                                        PyTargetExpression pyTargetExpression = Visitor.access$processAsInitVar(this.this$0, (PyTargetExpression)element, this.$postInit);
                                        if (pyTargetExpression != null) {
                                            PyTargetExpression pyTargetExpression2 = pyTargetExpression;
                                            boolean bl = false;
                                            boolean bl2 = false;
                                            PyTargetExpression it = pyTargetExpression2;
                                            boolean bl3 = false;
                                            this.$localInitVars.add(it);
                                        }
                                    }
                                    Visitor.access$processFieldFunctionCall(this.this$0, (PyTargetExpression)element);
                                }
                                return true;
                            }
                            {
                                this.this$0 = visitor2;
                                this.$postInit = pyFunction;
                                this.$localInitVars = list;
                            }
                        });
                        if (postInit != null) {
                            this.processPostInitDefinition(node, postInit, dataclassParameters, localInitVars);
                        }
                    } else if (dataclassParameters.getType() == PyDataclassParameters.Type.ATTRS) {
                        this.processAttrsParameters(node, dataclassParameters);
                        PyFunction pyFunction = node.findMethodByName("__attrs_post_init__", false, this.myTypeEvalContext);
                        if (pyFunction != null) {
                            PyFunction pyFunction2 = pyFunction;
                            boolean bl = false;
                            boolean bl2 = false;
                            PyFunction it = pyFunction2;
                            boolean bl3 = false;
                            PyFunction pyFunction3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction3, (String)"it");
                            this.processAttrsPostInitDefinition(pyFunction3, dataclassParameters);
                        }
                        this.processAttrsDefaultThroughDecorator(node);
                        this.processAttrsInitializersAndValidators(node);
                        this.processAttrIbFunctionCalls(node);
                    }
                    this.processAnnotationsExistence(node, dataclassParameters);
                    Function1 function1 = (Function1)new Function1<PyClass, Boolean>(this){
                        final /* synthetic */ Visitor this$0;

                        public final boolean invoke(@NotNull PyClass it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            TypeEvalContext typeEvalContext = this.this$0.myTypeEvalContext;
                            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                            return PyDataclassesKt.parseDataclassParameters(it, typeEvalContext) != null;
                        }
                        {
                            this.this$0 = visitor2;
                            super(1);
                        }
                    };
                    boolean bl = dataclassParameters.getType() == PyDataclassParameters.Type.STD;
                    TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext2, (String)"myTypeEvalContext");
                    PyNamedTupleInspection.Companion.inspectFieldsOrder(node, (Function1<? super PyClass, Boolean>)function1, bl, typeEvalContext2, (Function3<? super PsiElement, ? super String, ? super ProblemHighlightType, Unit>)((Function3)new Function3<PsiElement, String, ProblemHighlightType, Unit>(this){

                        public final void invoke(PsiElement p1, String p2, ProblemHighlightType p3) {
                            ((Visitor)((Object)this.receiver)).registerProblem(p1, p2, p3);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Visitor.class);
                        }

                        public final String getName() {
                            return "registerProblem";
                        }

                        public final String getSignature() {
                            return "registerProblem(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;)V";
                        }
                    }), (Function1<? super PyTargetExpression, Boolean>)((Function1)new Function1<PyTargetExpression, Boolean>(this){
                        final /* synthetic */ Visitor this$0;

                        public final boolean invoke(@NotNull PyTargetExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            PyTargetExpressionStub stub = (PyTargetExpressionStub)it.getStub();
                            PyDataclassFieldStub fieldStub = stub == null ? PyDataclassFieldStubImpl.Companion.create(it) : stub.getCustomStub(PyDataclassFieldStub.class);
                            return !(fieldStub != null && !fieldStub.initValue() || fieldStub == null && it.getAnnotationValue() == null || PyTypingTypeProvider.isClassVar(it, this.this$0.myTypeEvalContext));
                        }
                        {
                            this.this$0 = visitor2;
                            super(1);
                        }
                    }), (Function1<? super PyTargetExpression, Boolean>)((Function1)new Function1<PyTargetExpression, Boolean>(dataclassParameters, node){
                        final /* synthetic */ PyDataclassParameters $dataclassParameters;
                        final /* synthetic */ PyClass $node;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean invoke(@NotNull PyTargetExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            PyDataclassFieldStub fieldStub = PyDataclassFieldStubImpl.Companion.create(it);
                            if (fieldStub != null) {
                                if (fieldStub.hasDefault()) return true;
                                if (fieldStub.hasDefaultFactory()) return true;
                                if (this.$dataclassParameters.getType() != PyDataclassParameters.Type.ATTRS) return false;
                                PyFunction[] pyFunctionArray = this.$node.getMethods();
                                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"node.methods");
                                PyFunction[] $this$any$iv = pyFunctionArray;
                                boolean $i$f$any = false;
                                PyFunction[] pyFunctionArray2 = $this$any$iv;
                                int n = pyFunctionArray2.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PyFunction element$iv;
                                    PyFunction m = element$iv = pyFunctionArray2[n2];
                                    boolean bl = false;
                                    PyFunction pyFunction = m;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"m");
                                    PyDecoratorList pyDecoratorList = pyFunction.getDecoratorList();
                                    if ((pyDecoratorList != null ? pyDecoratorList.findDecorator(it.getName() + ".default") : null) != null) {
                                        return true;
                                    }
                                    boolean bl2 = false;
                                    if (bl2) {
                                        return true;
                                    }
                                    ++n2;
                                }
                                return false;
                            }
                            PyExpression assignedValue = it.findAssignedValue();
                            if (assignedValue == null) return false;
                            if (PyDataclassesKt.resolvesToOmittedDefault(assignedValue, this.$dataclassParameters.getType())) return false;
                            return true;
                        }
                        {
                            this.$dataclassParameters = pyDataclassParameters;
                            this.$node = pyClass;
                            super(1);
                        }
                    }));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyBinaryExpression(node);
            String leftOperator = node.getReferencedName();
            if (leftOperator != null && ORDER_OPERATORS.contains(leftOperator)) {
                void leftOrder;
                PyClass pyClass = this.getInstancePyClass(node.getLeftExpression());
                if (pyClass == null) {
                    return;
                }
                PyClass leftClass = pyClass;
                PyClass pyClass2 = this.getInstancePyClass(node.getRightExpression());
                if (pyClass2 == null) {
                    return;
                }
                PyClass rightClass = pyClass2;
                Pair<Companion.ClassOrder, PyDataclassParameters.Type> pair = this.getDataclassHierarchyOrder(leftClass, leftOperator);
                Companion.ClassOrder classOrder = (Companion.ClassOrder)((Object)pair.component1());
                PyDataclassParameters.Type leftType = (PyDataclassParameters.Type)((Object)pair.component2());
                if (leftOrder == Companion.ClassOrder.MANUALLY) {
                    return;
                }
                Pair<Companion.ClassOrder, PyDataclassParameters.Type> pair2 = this.getDataclassHierarchyOrder(rightClass, PyNames.leftToRightOperatorName(leftOperator));
                Companion.ClassOrder rightOrder = (Companion.ClassOrder)((Object)pair2.component1());
                if (Intrinsics.areEqual((Object)leftClass, (Object)rightClass)) {
                    if (leftOrder == Companion.ClassOrder.DC_UNORDERED && rightOrder != Companion.ClassOrder.MANUALLY) {
                        this.registerProblem(node.getPsiOperator(), '\'' + leftOperator + "' not supported between instances of '" + leftClass.getName() + '\'', ProblemHighlightType.GENERIC_ERROR);
                    }
                } else if (leftOrder == Companion.ClassOrder.DC_ORDERED || leftOrder == Companion.ClassOrder.DC_UNORDERED || rightOrder == Companion.ClassOrder.DC_ORDERED || rightOrder == Companion.ClassOrder.DC_UNORDERED) {
                    if (leftOrder == Companion.ClassOrder.DC_ORDERED && leftType == PyDataclassParameters.Type.ATTRS && rightClass.isSubclass(leftClass, this.myTypeEvalContext)) {
                        return;
                    }
                    this.registerProblem(node.getPsiOperator(), '\'' + leftOperator + "' not supported between instances of '" + leftClass.getName() + "' and '" + rightClass.getName() + '\'', ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        @Override
        public void visitPyCallExpression(@Nullable PyCallExpression node) {
            super.visitPyCallExpression(node);
            if (node != null) {
                String calleeQName;
                PyCallable callee;
                PyCallExpression.PyMarkedCallee markedCallee;
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
                List<PyCallExpression.PyMarkedCallee> list = node.multiResolveCallee(resolveContext);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"node.multiResolveCallee(resolveContext)");
                PyCallExpression.PyMarkedCallee pyMarkedCallee = markedCallee = (PyCallExpression.PyMarkedCallee)CollectionsKt.singleOrNull(list);
                PyCallable pyCallable = callee = pyMarkedCallee != null ? pyMarkedCallee.getElement() : null;
                String string = calleeQName = pyCallable != null ? pyCallable.getQualifiedName() : null;
                if (markedCallee != null && callee != null) {
                    PyExpression dataclassArgument;
                    Object v7;
                    PyDataclassParameters.Type dataclassType;
                    block12: {
                        PyDataclassParameters.Type type;
                        if (CollectionsKt.contains((Iterable)DATACLASSES_HELPERS, (Object)calleeQName)) {
                            type = PyDataclassParameters.Type.STD;
                        } else if (CollectionsKt.contains((Iterable)ATTRS_HELPERS, (Object)calleeQName)) {
                            type = PyDataclassParameters.Type.ATTRS;
                        } else {
                            return;
                        }
                        dataclassType = type;
                        PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpressionHelper.mapArguments(node, markedCallee, this.myTypeEvalContext);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pyArgumentsMapping, (String)"PyCallExpressionHelper.m\u2026allee, myTypeEvalContext)");
                        PyCallExpression.PyArgumentsMapping mapping = pyArgumentsMapping;
                        List<PyCallableParameter> list2 = callee.getParameters(this.myTypeEvalContext);
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callee.getParameters(myTypeEvalContext)");
                        PyCallableParameter dataclassParameter = (PyCallableParameter)CollectionsKt.firstOrNull(list2);
                        Iterable $this$firstOrNull$iv = mapping.getMappedParameters().entrySet();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Map.Entry it = (Map.Entry)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((PyCallableParameter)it.getValue()), (Object)dataclassParameter)) continue;
                            v7 = element$iv;
                            break block12;
                        }
                        v7 = null;
                    }
                    Map.Entry entry = v7;
                    PyExpression pyExpression = dataclassArgument = entry != null ? (PyExpression)entry.getKey() : null;
                    if (dataclassType == PyDataclassParameters.Type.STD) {
                        String string2 = calleeQName;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.processHelperDataclassArgument(dataclassArgument, string2);
                    } else if (dataclassType == PyDataclassParameters.Type.ATTRS) {
                        String string3 = calleeQName;
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.processHelperAttrsArgument(dataclassArgument, string3);
                    }
                }
            }
        }

        @Override
        public void visitPyReferenceExpression(@Nullable PyReferenceExpression node) {
            super.visitPyReferenceExpression(node);
            if (node != null && node.isQualified()) {
                Object[] resolved;
                PyClass pyClass = this.getInstancePyClass(node.getQualifier());
                if (pyClass == null) {
                    return;
                }
                PyClass cls = pyClass;
                Object[] objectArray = node.getReference(this.getResolveContext()).multiResolve(false);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node.getReference(resolv\u2026text).multiResolve(false)");
                Object[] objectArray2 = resolved = objectArray;
                boolean bl = false;
                Object[] objectArray3 = objectArray2;
                boolean bl2 = false;
                if (!(objectArray3.length == 0)) {
                    boolean bl3;
                    block5: {
                        Sequence $this$all$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])resolved), (Function1)visitPyReferenceExpression.1.INSTANCE);
                        boolean $i$f$all = false;
                        for (Object element$iv : $this$all$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl4 = false;
                            if (it instanceof PyTargetExpression && this.isInitVar((PyTargetExpression)it)) continue;
                            bl3 = false;
                            break block5;
                        }
                        bl3 = true;
                    }
                    if (bl3) {
                        this.registerProblem(node.getLastChild(), '\'' + cls.getName() + "' object could have no attribute '" + node.getName() + "' because it is declared as init-only", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkMutatingFrozenAttribute(PyQualifiedExpression expression) {
            boolean bl;
            PyClass cls;
            block6: {
                void $this$mapNotNullTo$iv$iv;
                PyClass pyClass = this.getInstancePyClass(expression.getQualifier());
                if (pyClass == null) {
                    return;
                }
                cls = pyClass;
                StreamEx streamEx = StreamEx.of((Object)cls).append((Collection)cls.getAncestorClasses(this.myTypeEvalContext));
                Intrinsics.checkExpressionValueIsNotNull((Object)streamEx, (String)"StreamEx\n          .of(c\u2026asses(myTypeEvalContext))");
                Iterable $this$mapNotNull$iv = (Iterable)streamEx;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PyDataclassParameters pyDataclassParameters;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    PyClass it = (PyClass)element$iv$iv;
                    boolean bl3 = false;
                    PyClass pyClass2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyClass2, (String)"it");
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyDataclassesKt.parseDataclassParameters(pyClass2, typeEvalContext) == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    PyDataclassParameters it$iv$iv = pyDataclassParameters;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PyDataclassParameters it = (PyDataclassParameters)element$iv;
                        boolean bl7 = false;
                        if (!it.getFrozen()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.registerProblem((PsiElement)expression, '\'' + cls.getName() + "' object attribute '" + expression.getName() + "' is read-only", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final Pair<Companion.ClassOrder, PyDataclassParameters.Type> getDataclassHierarchyOrder(PyClass cls, String operator) {
            Pair<Companion.ClassOrder, PyDataclassParameters.Type> seenUnordered = null;
            Iterator iterator = StreamEx.of((Object)cls).append((Collection)cls.getAncestorClasses(this.myTypeEvalContext)).iterator();
            while (iterator.hasNext()) {
                PyClass current;
                PyClass pyClass = current = (PyClass)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"current");
                Pair<Companion.ClassOrder, PyDataclassParameters.Type> order = this.getDataclassOrder(pyClass, operator);
                if ((Companion.ClassOrder)((Object)order.getFirst()) == Companion.ClassOrder.DC_UNORDERED) {
                    seenUnordered = order;
                    continue;
                }
                if ((Companion.ClassOrder)((Object)order.getFirst()) == Companion.ClassOrder.UNKNOWN) continue;
                return order;
            }
            return seenUnordered != null ? seenUnordered : TuplesKt.to((Object)((Object)Companion.ClassOrder.UNKNOWN), null);
        }

        private final Pair<Companion.ClassOrder, PyDataclassParameters.Type> getDataclassOrder(PyClass cls, String operator) {
            PyClassLikeType type = cls.getType(this.myTypeEvalContext);
            if (operator != null && type != null && !UtilKt.isNullOrEmpty((Collection)type.resolveMember(operator, null, AccessDirection.READ, this.getResolveContext(), false))) {
                return TuplesKt.to((Object)((Object)Companion.ClassOrder.MANUALLY), null);
            }
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters(cls, typeEvalContext);
            if (pyDataclassParameters == null) {
                return TuplesKt.to((Object)((Object)Companion.ClassOrder.UNKNOWN), null);
            }
            PyDataclassParameters parameters = pyDataclassParameters;
            return parameters.getOrder() ? TuplesKt.to((Object)((Object)Companion.ClassOrder.DC_ORDERED), (Object)((Object)parameters.getType())) : TuplesKt.to((Object)((Object)Companion.ClassOrder.DC_UNORDERED), (Object)((Object)parameters.getType()));
        }

        private final PyClass getInstancePyClass(PyTypedElement element) {
            PyClassType type;
            PyType pyType;
            PyType pyType2;
            PyTypedElement pyTypedElement = element;
            if (pyTypedElement != null) {
                PyTypedElement pyTypedElement2 = pyTypedElement;
                boolean bl = false;
                boolean bl2 = false;
                PyTypedElement it = pyTypedElement2;
                boolean bl3 = false;
                pyType2 = this.myTypeEvalContext.getType(it);
            } else {
                pyType2 = pyType = null;
            }
            if (!(pyType2 instanceof PyClassType)) {
                pyType = null;
            }
            return (type = (PyClassType)pyType) != null && !type.isDefinition() ? type.getPyClass() : null;
        }

        private final void processDataclassParameters(PyClass cls, PyDataclassParameters dataclassParameters) {
            if (!dataclassParameters.getEq() && dataclassParameters.getOrder()) {
                this.registerProblem((PsiElement)dataclassParameters.getEqArgument(), "'eq' must be true if 'order' is true", ProblemHighlightType.GENERIC_ERROR);
            }
            boolean initMethodExists = false;
            boolean reprMethodExists = false;
            boolean eqMethodExists = false;
            boolean orderMethodsExist = false;
            boolean mutatingMethodsExist = false;
            boolean hashMethodExists = false;
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"cls.methods");
            PyFunction[] $this$forEach$iv = pyFunctionArray;
            boolean $i$f$forEach = false;
            PyFunction[] pyFunctionArray2 = $this$forEach$iv;
            int n = pyFunctionArray2.length;
            for (int i = 0; i < n; ++i) {
                PyFunction element$iv;
                PyFunction it = element$iv = pyFunctionArray2[i];
                boolean bl = false;
                PyFunction pyFunction = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"it");
                String string = pyFunction.getName();
                if (Intrinsics.areEqual((Object)string, (Object)"__init__")) {
                    initMethodExists = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__repr__")) {
                    reprMethodExists = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__eq__")) {
                    eqMethodExists = true;
                    continue;
                }
                if (CollectionsKt.contains((Iterable)ORDER_OPERATORS, (Object)string)) {
                    orderMethodsExist = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__setattr__") || Intrinsics.areEqual((Object)string, (Object)"__delattr__")) {
                    mutatingMethodsExist = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"__hash__")) continue;
                hashMethodExists = true;
            }
            hashMethodExists = hashMethodExists || cls.findClassAttribute("__hash__", false, this.myTypeEvalContext) != null;
            $i$f$forEach = false;
            List useless = new ArrayList();
            if (dataclassParameters.getInit() && initMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getInitArgument(), (Object)"init", (Object)"__init__"));
            }
            if (dataclassParameters.getRepr() && reprMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getReprArgument(), (Object)"repr", (Object)"__repr__"));
            }
            if (dataclassParameters.getEq() && eqMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getEqArgument(), (Object)"eq", (Object)"__eq__"));
            }
            Iterable $this$forEach$iv2 = useless;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Triple it = (Triple)element$iv;
                boolean bl = false;
                this.registerProblem((PsiElement)it.getFirst(), '\'' + (String)it.getSecond() + "' is ignored if the class already defines '" + (String)it.getThird() + "' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            if (dataclassParameters.getOrder() && orderMethodsExist) {
                this.registerProblem((PsiElement)dataclassParameters.getOrderArgument(), "'order' should be false if the class defines one of order methods", ProblemHighlightType.GENERIC_ERROR);
            }
            if (dataclassParameters.getFrozen() && mutatingMethodsExist) {
                this.registerProblem((PsiElement)dataclassParameters.getFrozenArgument(), "'frozen' should be false if the class defines '__setattr__' or '__delattr__'", ProblemHighlightType.GENERIC_ERROR);
            }
            if (dataclassParameters.getUnsafeHash() && hashMethodExists) {
                this.registerProblem((PsiElement)dataclassParameters.getUnsafeHashArgument(), "'unsafe_hash' should be false if the class defines '__hash__'", ProblemHighlightType.GENERIC_ERROR);
            }
            Boolean frozenInHierarchy = null;
            Iterator iterator = StreamEx.of((Object)cls).append((Collection)cls.getAncestorClasses(this.myTypeEvalContext)).iterator();
            while (iterator.hasNext()) {
                PyClass current;
                PyClass pyClass = current = (PyClass)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"current");
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseStdDataclassParameters(pyClass, typeEvalContext);
                if (pyDataclassParameters == null) {
                    continue;
                }
                boolean currentFrozen = pyDataclassParameters.getFrozen();
                if (frozenInHierarchy == null) {
                    frozenInHierarchy = currentFrozen;
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)frozenInHierarchy, (Object)currentFrozen) ^ true)) continue;
                PyExpression pyExpression = dataclassParameters.getFrozenArgument();
                this.registerProblem(pyExpression != null ? (PsiElement)pyExpression : cls.getNameIdentifier(), "Frozen dataclasses can not inherit non-frozen one and vice versa", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processAttrsParameters(PyClass cls, PyDataclassParameters dataclassParameters) {
            Object it;
            PyFunction initMethod = null;
            PyFunction reprMethod = null;
            PyFunction strMethod = null;
            boolean bl = false;
            List cmpMethods = new ArrayList();
            boolean bl2 = false;
            List mutatingMethods = new ArrayList();
            PsiNameIdentifierOwner hashMethod = null;
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"cls.methods");
            PyFunction[] $this$forEach$iv = pyFunctionArray;
            boolean $i$f$forEach2 = false;
            PyFunction[] pyFunctionArray2 = $this$forEach$iv;
            int n = pyFunctionArray2.length;
            for (int i = 0; i < n; ++i) {
                PyFunction element$iv;
                PyFunction it2 = element$iv = pyFunctionArray2[i];
                boolean bl3 = false;
                PyFunction pyFunction = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"it");
                String string = pyFunction.getName();
                if (Intrinsics.areEqual((Object)string, (Object)"__init__")) {
                    initMethod = it2;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__repr__")) {
                    reprMethod = it2;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__str__")) {
                    strMethod = it2;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__eq__") || CollectionsKt.contains((Iterable)ORDER_OPERATORS, (Object)string)) {
                    cmpMethods.add(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__setattr__") || Intrinsics.areEqual((Object)string, (Object)"__delattr__")) {
                    mutatingMethods.add(it2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"__hash__")) continue;
                hashMethod = it2;
            }
            PsiNameIdentifierOwner psiNameIdentifierOwner = hashMethod;
            if (psiNameIdentifierOwner == null) {
                psiNameIdentifierOwner = cls.findClassAttribute("__hash__", false, this.myTypeEvalContext);
            }
            hashMethod = psiNameIdentifierOwner;
            $i$f$forEach2 = false;
            List problems = new ArrayList();
            if (dataclassParameters.getInit() && initMethod != null) {
                problems.add(TuplesKt.to((Object)initMethod, (Object)"init"));
            }
            if (dataclassParameters.getRepr() && reprMethod != null) {
                problems.add(TuplesKt.to((Object)reprMethod, (Object)"repr"));
            }
            if (PyEvaluator.evaluateAsBoolean(PyUtil.peelArgument(dataclassParameters.getOthers().get("str")), false) && strMethod != null) {
                problems.add(TuplesKt.to((Object)strMethod, (Object)"str"));
            }
            if (dataclassParameters.getOrder()) {
                Collection $i$f$forEach2 = cmpMethods;
                boolean bl4 = false;
                if (!$i$f$forEach2.isEmpty()) {
                    Iterable $this$forEach$iv2 = cmpMethods;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        it = (PyFunction)element$iv;
                        boolean bl5 = false;
                        problems.add(TuplesKt.to((Object)it, (Object)"cmp"));
                    }
                }
            }
            if (dataclassParameters.getFrozen()) {
                Iterable $this$forEach$iv2 = mutatingMethods;
                boolean $i$f$forEach3 = false;
                if (!$this$forEach$iv2.isEmpty()) {
                    $this$forEach$iv2 = mutatingMethods;
                    $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        it = (PyFunction)element$iv;
                        boolean bl6 = false;
                        problems.add(TuplesKt.to((Object)it, (Object)"frozen"));
                    }
                }
            }
            if (dataclassParameters.getUnsafeHash() && hashMethod != null) {
                problems.add(TuplesKt.to((Object)hashMethod, (Object)"hash"));
            }
            Iterable $this$forEach$iv3 = problems;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv3) {
                PsiNameIdentifierOwner psiNameIdentifierOwner2;
                it = (Pair)element$iv;
                boolean bl7 = false;
                if ((PsiNameIdentifierOwner)it.getFirst() == null) continue;
                boolean bl8 = false;
                boolean bl9 = false;
                PsiNameIdentifierOwner $this$apply = psiNameIdentifierOwner2;
                boolean bl10 = false;
                this.registerProblem($this$apply.getNameIdentifier(), '\'' + $this$apply.getName() + "' is ignored if the class already defines '" + (String)it.getSecond() + "' parameter", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            if (dataclassParameters.getOrder() && dataclassParameters.getFrozen() && hashMethod != null) {
                PsiNameIdentifierOwner psiNameIdentifierOwner3 = hashMethod;
                this.registerProblem((PsiElement)(psiNameIdentifierOwner3 != null ? psiNameIdentifierOwner3.getNameIdentifier() : null), "'__hash__' is ignored if the class already defines 'cmp' and 'frozen' parameters", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private final void processDefaultFieldValue(PyTargetExpression field) {
            if (field.getAnnotationValue() == null) {
                return;
            }
            PyExpression value = field.findAssignedValue();
            if (PyUtil.isForbiddenMutableDefault(value, this.myTypeEvalContext)) {
                PyExpression pyExpression = value;
                this.registerProblem((PsiElement)value, "Mutable default '" + (pyExpression != null ? pyExpression.getText() : null) + "' is not allowed. Use 'default_factory'", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processAttrsDefaultThroughDecorator(PyClass cls) {
            boolean bl = false;
            Map initializers = new LinkedHashMap();
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"cls.methods");
            Object $this$forEach$iv = pyFunctionArray;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv;
            int n = ((PyFunction[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2;
                Object[] decorators;
                PyFunction element$iv;
                PyFunction method = element$iv = object[i];
                boolean bl2 = false;
                PyFunction pyFunction = method;
                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"method");
                PyDecoratorList pyDecoratorList = pyFunction.getDecoratorList();
                Object object3 = decorators = pyDecoratorList != null ? pyDecoratorList.getDecorators() : null;
                if (decorators == null) continue;
                if ((String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])decorators), (Function1)processAttrsDefaultThroughDecorator.1.1.INSTANCE), (Function1)processAttrsDefaultThroughDecorator.1.2.INSTANCE), (Function1)processAttrsDefaultThroughDecorator.1.3.INSTANCE)) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Object name = object2;
                boolean bl5 = false;
                PyTargetExpression attribute = cls.findClassAttribute((String)name, false, this.myTypeEvalContext);
                if (attribute == null) continue;
                ((List)initializers.computeIfAbsent(name, processAttrsDefaultThroughDecorator.1.4.1.INSTANCE)).add(method);
                PyDataclassFieldStub stub = PyDataclassFieldStubImpl.Companion.create(attribute);
                if (stub == null || !stub.hasDefault() && !stub.hasDefaultFactory()) continue;
                this.registerProblem(method.getNameIdentifier(), "A default is set using 'attr.ib()'", ProblemHighlightType.GENERIC_ERROR);
            }
            $this$forEach$iv = initializers.values();
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                List sameAttrInitializers = (List)element$iv;
                boolean bl6 = false;
                PyFunction first = (PyFunction)sameAttrInitializers.get(0);
                Sequence $this$forEach$iv2 = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)sameAttrInitializers), (int)1);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    PyFunction it = (PyFunction)element$iv2;
                    boolean bl7 = false;
                    this.registerProblem(it.getNameIdentifier(), "A default is set using '" + first.getName() + '\'', ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        private final void processAttrsInitializersAndValidators(PyClass cls) {
            cls.visitMethods((Processor<PyFunction>)((Processor)new Processor<PyFunction>(this){
                final /* synthetic */ Visitor this$0;

                public final boolean process(PyFunction method) {
                    Object[] decorators;
                    PyFunction pyFunction = method;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"method");
                    PyDecoratorList pyDecoratorList = pyFunction.getDecoratorList();
                    Object object = decorators = pyDecoratorList != null ? pyDecoratorList.getDecorators() : null;
                    if (decorators != null) {
                        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])decorators), (Function1)processAttrsInitializersAndValidators.1.INSTANCE), (Function1)processAttrsInitializersAndValidators.2.INSTANCE), (Function1)processAttrsInitializersAndValidators.3.INSTANCE);
                        boolean $i$f$forEach = false;
                        block8: for (E element$iv : $this$forEach$iv) {
                            PyParameterList actualParameters;
                            int n;
                            String it = (String)element$iv;
                            boolean bl = false;
                            switch (it) {
                                case "default": {
                                    n = 1;
                                    break;
                                }
                                case "validator": {
                                    n = 3;
                                    break;
                                }
                                default: {
                                    continue block8;
                                }
                            }
                            int expectedParameters = n;
                            Intrinsics.checkExpressionValueIsNotNull((Object)method.getParameterList(), (String)"method.parameterList");
                            if (actualParameters.getParameters().length == expectedParameters) continue;
                            String message = '\'' + method.getName() + "' should take only " + expectedParameters + " parameter" + (expectedParameters > 1 ? "s" : "");
                            this.this$0.registerProblem((PsiElement)actualParameters, message, ProblemHighlightType.GENERIC_ERROR);
                        }
                    }
                    return true;
                }
                {
                    this.this$0 = visitor2;
                }
            }), false, this.myTypeEvalContext);
        }

        private final void processAnnotationsExistence(PyClass cls, PyDataclassParameters dataclassParameters) {
            if (dataclassParameters.getType() == PyDataclassParameters.Type.STD || PyEvaluator.evaluateAsBoolean(PyUtil.peelArgument(dataclassParameters.getOthers().get("auto_attribs")), false)) {
                cls.processClassLevelDeclarations(new PsiScopeProcessor(this){
                    final /* synthetic */ Visitor this$0;

                    public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                        if (element instanceof PyTargetExpression && ((PyTargetExpression)element).getAnnotation() == null && PyDataclassFieldStubImpl.Companion.create((PyTargetExpression)element) != null) {
                            this.this$0.registerProblem(element, "Attribute '" + ((PyTargetExpression)element).getName() + "' lacks a type annotation", ProblemHighlightType.GENERIC_ERROR);
                        }
                        return true;
                    }
                    {
                        this.this$0 = visitor2;
                    }
                });
            }
        }

        private final void processAttrIbFunctionCalls(PyClass cls) {
            cls.processClassLevelDeclarations(new PsiScopeProcessor(this){
                final /* synthetic */ Visitor this$0;

                public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                    if (element instanceof PyTargetExpression) {
                        PyExpression pyExpression = ((PyTargetExpression)element).findAssignedValue();
                        if (!(pyExpression instanceof PyCallExpression)) {
                            pyExpression = null;
                        }
                        PyCallExpression call = (PyCallExpression)pyExpression;
                        PyDataclassFieldStub stub = PyDataclassFieldStubImpl.Companion.create((PyTargetExpression)element);
                        if (call != null && stub != null && stub.hasDefaultFactory()) {
                            if (stub.hasDefault()) {
                                this.this$0.registerProblem((PsiElement)call.getArgumentList(), "Cannot specify both 'default' and 'factory'", ProblemHighlightType.GENERIC_ERROR);
                            } else {
                                PyExpression pyExpression2 = call.getKeywordArgument("default");
                                PyExpression factory = call.getKeywordArgument("factory");
                                if (pyExpression2 != null && factory != null && !PyDataclassesKt.resolvesToOmittedDefault(pyExpression2, PyDataclassParameters.Type.ATTRS)) {
                                    this.this$0.registerProblem((PsiElement)call.getArgumentList(), "Cannot specify both 'default' and 'factory'", ProblemHighlightType.GENERIC_ERROR);
                                }
                            }
                        }
                    }
                    return true;
                }
                {
                    this.this$0 = visitor2;
                }
            });
        }

        private final PyTargetExpression processAsInitVar(PyTargetExpression field, PyFunction postInit) {
            if (this.isInitVar(field)) {
                if (postInit == null) {
                    this.registerProblem((PsiElement)field, "Attribute '" + field.getName() + "' is useless until '__post_init__' is declared", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                }
                return field;
            }
            return null;
        }

        private final void processFieldFunctionCall(PyTargetExpression field) {
            PyDataclassFieldStub pyDataclassFieldStub = PyDataclassFieldStubImpl.Companion.create(field);
            if (pyDataclassFieldStub == null) {
                return;
            }
            PyDataclassFieldStub fieldStub = pyDataclassFieldStub;
            PyExpression pyExpression = field.findAssignedValue();
            if (!(pyExpression instanceof PyCallExpression)) {
                pyExpression = null;
            }
            PyCallExpression pyCallExpression = (PyCallExpression)pyExpression;
            if (pyCallExpression == null) {
                return;
            }
            PyCallExpression call = pyCallExpression;
            if (PyTypingTypeProvider.isClassVar(field, this.myTypeEvalContext) || this.isInitVar(field)) {
                if (fieldStub.hasDefaultFactory()) {
                    this.registerProblem((PsiElement)call.getKeywordArgument("default_factory"), "Field cannot have a default factory", ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (fieldStub.hasDefault() && fieldStub.hasDefaultFactory()) {
                this.registerProblem((PsiElement)call.getArgumentList(), "Cannot specify both 'default' and 'default_factory'", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processPostInitDefinition(PyClass cls, PyFunction postInit, PyDataclassParameters dataclassParameters, List<? extends PyTargetExpression> localInitVars) {
            List list;
            if (!dataclassParameters.getInit()) {
                this.registerProblem(postInit.getNameIdentifier(), "'__post_init__' would not be called until 'init' parameter is set to True", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                return;
            }
            boolean bl = false;
            List allInitVars = new ArrayList();
            List<PyClass> list2 = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"cls.getAncestorClasses(myTypeEvalContext)");
            Iterator iterator = CollectionsKt.asReversedMutable(list2).iterator();
            while (iterator.hasNext()) {
                PyClass ancestor;
                PyClass pyClass = ancestor = (PyClass)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"ancestor");
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyDataclassesKt.parseStdDataclassParameters(pyClass, typeEvalContext) == null) continue;
                ancestor.processClassLevelDeclarations(new PsiScopeProcessor(this, allInitVars){
                    final /* synthetic */ Visitor this$0;
                    final /* synthetic */ List $allInitVars;

                    public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                        if (element instanceof PyTargetExpression && Visitor.access$isInitVar(this.this$0, (PyTargetExpression)element)) {
                            this.$allInitVars.add(element);
                        }
                        return true;
                    }
                    {
                        this.this$0 = visitor2;
                        this.$allInitVars = list;
                    }
                });
            }
            allInitVars.addAll((Collection)localInitVars);
            List list3 = postInit.getParameters(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"postInit.getParameters(myTypeEvalContext)");
            List implicitParameters = list3;
            if (implicitParameters.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                List list4 = ContainerUtil.subList((List)implicitParameters, (int)1);
                list = list4;
                Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"ContainerUtil.subList(implicitParameters, 1)");
            }
            List parameters = list;
            String message = "'__post_init__' should take all init-only variables" + (allInitVars.size() != localInitVars.size() ? " (incl. inherited)" : "") + ' ' + "in the same order as they are defined";
            if (parameters.size() != allInitVars.size()) {
                this.registerProblem((PsiElement)postInit.getParameterList(), message, ProblemHighlightType.GENERIC_ERROR);
            } else {
                boolean bl2;
                block8: {
                    Sequence $this$all$iv = SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)parameters), (Sequence)CollectionsKt.asSequence((Iterable)allInitVars));
                    boolean $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)((PyCallableParameter)it.getFirst()).getName(), (Object)((PyTargetExpression)it.getSecond()).getName())) continue;
                        bl2 = false;
                        break block8;
                    }
                    bl2 = true;
                }
                boolean bl4 = bl2;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean it = bl4;
                boolean bl7 = false;
                if (!it) {
                    this.registerProblem((PsiElement)postInit.getParameterList(), message);
                }
            }
        }

        private final void processAttrsPostInitDefinition(PyFunction postInit, PyDataclassParameters dataclassParameters) {
            if (!dataclassParameters.getInit()) {
                this.registerProblem(postInit.getNameIdentifier(), "'__attrs_post_init__' would not be called until 'init' parameter is set to True", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }
            if (postInit.getParameters(this.myTypeEvalContext).size() != 1) {
                this.registerProblem((PsiElement)postInit.getParameterList(), "'__attrs_post_init__' should not take any parameters except 'self'", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processHelperDataclassArgument(PyExpression argument, String calleeQName) {
            if (argument == null) {
                return;
            }
            boolean allowDefinition = Intrinsics.areEqual((Object)calleeQName, (Object)"dataclasses.fields");
            PyType type = this.myTypeEvalContext.getType(argument);
            if (!this.isExpectedDataclass(type, PyDataclassParameters.Type.STD, allowDefinition, true, Intrinsics.areEqual((Object)calleeQName, (Object)"dataclasses.asdict") ^ true)) {
                String message = '\'' + calleeQName + "' method should be called on dataclass instances" + (allowDefinition ? " or types" : "");
                this.registerProblem((PsiElement)argument, message);
            }
        }

        private final void processHelperAttrsArgument(PyExpression argument, String calleeQName) {
            if (argument == null) {
                return;
            }
            boolean instance = Intrinsics.areEqual((Object)calleeQName, (Object)"attr.fields") ^ true && Intrinsics.areEqual((Object)calleeQName, (Object)"attr.fields_dict") ^ true;
            if (!this.isExpectedDataclass(this.myTypeEvalContext.getType(argument), PyDataclassParameters.Type.ATTRS, !instance, instance, true)) {
                String message = '\'' + calleeQName + "' method should be called on attrs " + (instance ? "instances" : "types");
                this.registerProblem((PsiElement)argument, message);
            }
        }

        private final boolean isInitVar(PyTargetExpression field) {
            PyType pyType = this.myTypeEvalContext.getType(field);
            if (!(pyType instanceof PyClassType)) {
                pyType = null;
            }
            PyClassType pyClassType = (PyClassType)pyType;
            return Intrinsics.areEqual((Object)(pyClassType != null ? pyClassType.getClassQName() : null), (Object)"dataclasses.InitVar");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isExpectedDataclass(PyType type, PyDataclassParameters.Type dataclassType, boolean allowDefinition, boolean allowInstance, boolean allowSubclass) {
            PyClassLikeType it;
            if (type instanceof PyStructuralType) return true;
            if (PyTypeChecker.isUnknown(type, this.myTypeEvalContext)) {
                return true;
            }
            if (type instanceof PyUnionType) {
                PyType it2;
                Collection<PyType> collection = ((PyUnionType)type).getMembers();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"type.members");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    Object element$iv = iterator.next();
                    it2 = (PyType)element$iv;
                    boolean bl = false;
                } while (!this.isExpectedDataclass(it2, dataclassType, allowDefinition, allowInstance, allowSubclass));
                return true;
            }
            if (!(type instanceof PyClassType)) return false;
            if (!allowDefinition) {
                if (((PyClassType)type).isDefinition()) return false;
            }
            if (!allowInstance) {
                if (!((PyClassType)type).isDefinition()) return false;
            }
            PyClass pyClass = ((PyClassType)type).getPyClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"type.pyClass");
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters(pyClass, typeEvalContext);
            if ((pyDataclassParameters != null ? pyDataclassParameters.getType() : null) == dataclassType) return true;
            if (!allowSubclass) return false;
            List<PyClassLikeType> list = ((PyClassType)type).getAncestorTypes(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"type.getAncestorTypes(myTypeEvalContext)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (PyClassLikeType)element$iv;
                boolean bl = false;
            } while (!this.isExpectedDataclass(it, dataclassType, true, false, false));
            return true;
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            super(holder, session);
        }

        public static final /* synthetic */ void access$processDefaultFieldValue(Visitor $this, PyTargetExpression field) {
            $this.processDefaultFieldValue(field);
        }

        public static final /* synthetic */ PyTargetExpression access$processAsInitVar(Visitor $this, PyTargetExpression field, PyFunction postInit) {
            return $this.processAsInitVar(field, postInit);
        }

        public static final /* synthetic */ void access$processFieldFunctionCall(Visitor $this, PyTargetExpression field) {
            $this.processFieldFunctionCall(field);
        }

        public static final /* synthetic */ boolean access$isInitVar(Visitor $this, PyTargetExpression field) {
            return $this.isInitVar(field);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Companion;", "", "()V", "ATTRS_HELPERS", "", "", "DATACLASSES_HELPERS", "ORDER_OPERATORS", "ClassOrder", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Companion$ClassOrder;", "", "(Ljava/lang/String;I)V", "MANUALLY", "DC_ORDERED", "DC_UNORDERED", "UNKNOWN", "intellij.python.community.impl"})
        private static final class ClassOrder
        extends Enum<ClassOrder> {
            public static final /* enum */ ClassOrder MANUALLY;
            public static final /* enum */ ClassOrder DC_ORDERED;
            public static final /* enum */ ClassOrder DC_UNORDERED;
            public static final /* enum */ ClassOrder UNKNOWN;
            private static final /* synthetic */ ClassOrder[] $VALUES;

            static {
                ClassOrder[] classOrderArray = new ClassOrder[4];
                ClassOrder[] classOrderArray2 = classOrderArray;
                classOrderArray[0] = MANUALLY = new ClassOrder();
                classOrderArray[1] = DC_ORDERED = new ClassOrder();
                classOrderArray[2] = DC_UNORDERED = new ClassOrder();
                classOrderArray[3] = UNKNOWN = new ClassOrder();
                $VALUES = classOrderArray;
            }

            public static ClassOrder[] values() {
                return (ClassOrder[])$VALUES.clone();
            }

            public static ClassOrder valueOf(String string) {
                return Enum.valueOf(ClassOrder.class, string);
            }
        }
    }
}

