/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.override.PyOverrideImplementUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyImplementMethodsQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyAbstractClassInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.abstract.class", new Object[0]);
        if (string == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (session == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(PyClass pyClass) {
            if (this.isAbstract(pyClass) || PyProtocolsKt.isProtocol(pyClass, this.myTypeEvalContext)) {
                return;
            }
            List<PyFunction> toImplement = PyOverrideImplementUtil.getAllSuperAbstractMethods(pyClass, this.myTypeEvalContext);
            ASTNode nameNode = pyClass.getNameNode();
            if (!toImplement.isEmpty() && nameNode != null) {
                SmartList quickFixes = new SmartList((Object[])new LocalQuickFix[]{new PyImplementMethodsQuickFix(pyClass, toImplement), new SetABCMetaAsMetaclassQuickFix()});
                if (LanguageLevel.forElement((PsiElement)pyClass).isPy3K()) {
                    quickFixes.add((Object)new AddABCToSuperclassesQuickFix());
                }
                this.registerProblem(nameNode.getPsi(), PyBundle.message("INSP.NAME.abstract.class.$0.must.implement", pyClass.getName()), (LocalQuickFix[])quickFixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private boolean isAbstract(@NotNull PyClass pyClass) {
            PyClassLikeType metaClass;
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((metaClass = pyClass.getMetaClassType(false, this.myTypeEvalContext)) != null && "ABCMeta".equals(metaClass.getName())) {
                return true;
            }
            for (PyClassLikeType superClassType : pyClass.getSuperClassTypes(this.myTypeEvalContext)) {
                if (superClassType == null || !"abc.ABC".equals(superClassType.getClassQName())) continue;
                return true;
            }
            for (PyFunction method : pyClass.getMethods()) {
                if (!PyKnownDecoratorUtil.hasAbstractDecorator(method, this.myTypeEvalContext)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAbstract";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class SetABCMetaAsMetaclassQuickFix
        implements LocalQuickFix {
            private SetABCMetaAsMetaclassQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                if ("Set 'abc.ABCMeta' as metaclass" == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(0);
                }
                return "Set 'abc.ABCMeta' as metaclass";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PyClass cls;
                if (project == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(2);
                }
                if ((cls = PyUtil.as(descriptor2.getPsiElement().getParent(), PyClass.class)) == null) {
                    return;
                }
                PyClass abcMetaClass = PyPsiFacade.getInstance(project).createClassByQName("abc.ABCMeta", (PsiElement)cls);
                if (abcMetaClass == null) {
                    return;
                }
                TypeEvalContext context = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile());
                PyClassRefactoringUtil.addMetaClassIfNotExist(cls, abcMetaClass, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class AddABCToSuperclassesQuickFix
        implements LocalQuickFix {
            private AddABCToSuperclassesQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                if ("Add 'abc.ABC' to superclasses" == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(0);
                }
                return "Add 'abc.ABC' to superclasses";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PyClass cls;
                if (project == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(2);
                }
                if ((cls = PyUtil.as(descriptor2.getPsiElement().getParent(), PyClass.class)) == null) {
                    return;
                }
                PyClass abcClass = PyPsiFacade.getInstance(project).createClassByQName("abc.ABC", (PsiElement)cls);
                if (abcClass == null) {
                    return;
                }
                PyClassRefactoringUtil.addSuperclasses(project, cls, abcClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

