/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PyFromImportPostFormatProcessor
implements PostFormatProcessor {
    PyFromImportPostFormatProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = new Visitor(settings).processElement(source);
        if (psiElement == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(5);
        }
        TextRange textRange = new Visitor(settings).processTextRange(source, rangeToReformat);
        if (textRange == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyRecursiveElementVisitor {
        private final PostFormatProcessorHelper myHelper;
        private final List<PyFromImportStatement> myImportStatements;
        private PsiElement myRootElement;

        Visitor(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.myImportStatements = new ArrayList<PyFromImportStatement>();
            this.myHelper = new PostFormatProcessorHelper(settings.getCommonSettings((Language)PythonLanguage.getInstance()));
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            List importedNames;
            if (this.myHelper.isElementFullyInRange((PsiElement)node) && (importedNames = ContainerUtil.filter((Object[])node.getImportElements(), elem -> elem.getTextLength() != 0)).size() > 1) {
                boolean missingComma;
                PyCodeStyleSettings pySettings = (PyCodeStyleSettings)this.myHelper.getSettings().getRootSettings().getCustomSettings(PyCodeStyleSettings.class);
                boolean forcedParens = pySettings.FROM_IMPORT_PARENTHESES_FORCE_IF_MULTILINE && PostFormatProcessorHelper.isMultiline((PsiElement)node);
                boolean forcedComma = pySettings.FROM_IMPORT_TRAILING_COMMA_IF_MULTILINE && PostFormatProcessorHelper.isMultiline((PsiElement)node);
                PyImportElement lastImportedName = (PyImportElement)importedNames.get(importedNames.size() - 1);
                PsiElement afterLastName = PyPsiUtils.getNextNonCommentSibling((PsiElement)lastImportedName, true);
                PsiElement openingParen = node.getLeftParen();
                boolean bl = missingComma = afterLastName == null || afterLastName.getNode().getElementType() != PyTokenTypes.COMMA;
                if (forcedParens && openingParen == null || forcedComma && missingComma && openingParen != null) {
                    this.myImportStatements.add(node);
                }
            }
        }

        @NotNull
        public PsiElement processElement(@NotNull PsiElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.myRootElement = element;
            this.findAndReplaceFromImports(element);
            PsiElement psiElement = this.myRootElement;
            if (psiElement == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @NotNull
        public TextRange processTextRange(@NotNull PsiFile file, @NotNull TextRange range) {
            if (file == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (range == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            this.myHelper.setResultTextRange(range);
            this.findAndReplaceFromImports((PsiElement)file);
            TextRange textRange = this.myHelper.getResultTextRange();
            if (textRange == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private void findAndReplaceFromImports(@NotNull PsiElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (element.getLanguage().isKindOf((Language)PythonLanguage.INSTANCE)) {
                element.accept((PsiElementVisitor)this);
                Collections.reverse(this.myImportStatements);
                for (PyFromImportStatement statement : this.myImportStatements) {
                    PyFromImportStatement newStatement = this.replaceFromImport(statement);
                    if (this.myRootElement != statement) continue;
                    this.myRootElement = newStatement;
                }
            }
        }

        @NotNull
        private PyFromImportStatement replaceFromImport(@NotNull PyFromImportStatement fromImport) {
            if (fromImport == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            PyImportElement[] allNames = fromImport.getImportElements();
            PyImportElement firstName = allNames[0];
            PyElementGenerator generator = PyElementGenerator.getInstance(fromImport.getProject());
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)fromImport.getProject());
            if (fromImport.getLeftParen() == null) {
                String beforeFirstName = fromImport.getText().substring(0, firstName.getStartOffsetInParent());
                StringBuilder newStatementText = new StringBuilder(beforeFirstName);
                newStatementText.append("(");
                boolean lastElementWasComment = false;
                int lastVisibleNameCommaOffset = -1;
                for (PyImportElement cur = firstName; cur != null; cur = cur.getNextSibling()) {
                    if (cur instanceof PsiWhiteSpace) {
                        newStatementText.append(cur.getText().replace("\\", ""));
                    } else {
                        newStatementText.append(cur.getText());
                    }
                    if (cur instanceof PyImportElement && cur.getTextLength() != 0) {
                        lastVisibleNameCommaOffset = newStatementText.length();
                    } else if (lastVisibleNameCommaOffset != -1 && cur.getNode().getElementType() == PyTokenTypes.COMMA) {
                        lastVisibleNameCommaOffset = -1;
                    }
                    lastElementWasComment = cur instanceof PsiComment;
                }
                PyCodeStyleSettings pySettings = (PyCodeStyleSettings)this.myHelper.getSettings().getRootSettings().getCustomSettings(PyCodeStyleSettings.class);
                if (lastVisibleNameCommaOffset != -1 && pySettings.FROM_IMPORT_TRAILING_COMMA_IF_MULTILINE) {
                    newStatementText.insert(lastVisibleNameCommaOffset, ",");
                }
                if (lastElementWasComment) {
                    newStatementText.append("\n");
                }
                newStatementText.append(")");
                LanguageLevel level = LanguageLevel.forElement((PsiElement)fromImport);
                PyFromImportStatement newFromImport = generator.createFromText(level, PyFromImportStatement.class, newStatementText.toString());
                newFromImport = (PyFromImportStatement)fromImport.replace((PsiElement)newFromImport);
                newFromImport = (PyFromImportStatement)codeStyleManager.reformat((PsiElement)newFromImport, true);
                this.myHelper.updateResultRange(fromImport.getTextLength(), newFromImport.getTextLength());
                PyFromImportStatement pyFromImportStatement = newFromImport;
                if (pyFromImportStatement == null) {
                    Visitor.$$$reportNull$$$0(8);
                }
                return pyFromImportStatement;
            }
            int oldLength = fromImport.getTextLength();
            fromImport.addAfter(generator.createComma().getPsi(), (PsiElement)allNames[allNames.length - 1]);
            codeStyleManager.reformat((PsiElement)fromImport, true);
            this.myHelper.updateResultRange(oldLength, fromImport.getTextLength());
            PyFromImportStatement pyFromImportStatement = fromImport;
            if (pyFromImportStatement == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            return pyFromImportStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor$Visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromImport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor$Visitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processTextRange";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replaceFromImport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processElement";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processTextRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findAndReplaceFromImports";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceFromImport";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

