/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySmartStepIntoHandler
extends XSmartStepIntoHandler<PySmartStepIntoVariant> {
    private final XDebugSession mySession;
    private final PyDebugProcess myProcess;

    public PySmartStepIntoHandler(PyDebugProcess process2) {
        this.mySession = process2.getSession();
        this.myProcess = process2;
    }

    @NotNull
    public List<PySmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        ArrayList variants = Lists.newArrayList();
        HashSet visitedCalls = Sets.newHashSet();
        int line2 = position.getLine();
        XDebuggerUtil.getInstance().iterateLine(this.mySession.getProject(), document, line2, psiElement -> {
            PySmartStepIntoHandler.addVariants(document, line2, psiElement, variants, visitedCalls);
            return true;
        });
        ArrayList arrayList = variants;
        if (arrayList == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public void startStepInto(@NotNull PySmartStepIntoVariant smartStepIntoVariant) {
        if (smartStepIntoVariant == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        this.myProcess.startSmartStepInto(smartStepIntoVariant.getFunctionName());
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(3);
        }
        return PyBundle.message("debug.popup.title.step.into.function", new Object[0]);
    }

    private static void addVariants(Document document, int line2, @Nullable PsiElement element, List<PySmartStepIntoVariant> variants, Set<PyCallExpression> visited) {
        if (element == null) {
            return;
        }
        PyCallExpression expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (expression != null && expression.getTextRange().getEndOffset() <= document.getLineEndOffset(line2) && visited.add(expression)) {
            PySmartStepIntoHandler.addVariants(document, line2, expression.getParent(), variants, visited);
            PyExpression ref = expression.getCallee();
            variants.add(new PySmartStepIntoVariant(ref));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PySmartStepIntoHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartStepIntoVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PySmartStepIntoHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PySmartStepIntoVariant
    extends XSmartStepIntoVariant {
        private final PyElement myElement;

        public PySmartStepIntoVariant(PyElement element) {
            this.myElement = element;
        }

        public String getText() {
            return this.myElement.getText() + "()";
        }

        public String getFunctionName() {
            String name = this.myElement.getName();
            return name != null ? name : this.getText();
        }
    }
}

