/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions.convertToFString;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.codeInsight.intentions.convertToFString.BaseConvertToFStringProcessor;
import com.jetbrains.python.inspections.PyNewStyleStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewStyleConvertToFStringProcessor
extends BaseConvertToFStringProcessor<PyNewStyleStringFormatParser.Field> {
    public NewStyleConvertToFStringProcessor(@NotNull PyStringLiteralExpression pyString) {
        if (pyString == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(0);
        }
        super(pyString);
    }

    @Override
    @NotNull
    protected List<PyNewStyleStringFormatParser.Field> extractAllSubstitutionChunks() {
        List<PyNewStyleStringFormatParser.Field> list = PyNewStyleStringFormatParser.parse(this.myPyString.getText()).getAllFields();
        if (list == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<PyNewStyleStringFormatParser.Field> extractTopLevelSubstitutionChunks() {
        List<PyNewStyleStringFormatParser.Field> list = PyNewStyleStringFormatParser.parse(this.myPyString.getText()).getFields();
        if (list == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    protected PySubstitutionChunkReference createReference(@NotNull PyNewStyleStringFormatParser.Field field) {
        if (field == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(3);
        }
        PySubstitutionChunkReference pySubstitutionChunkReference = new PySubstitutionChunkReference(this.myPyString, field);
        if (pySubstitutionChunkReference == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(4);
        }
        return pySubstitutionChunkReference;
    }

    @Override
    protected boolean checkChunk(@NotNull PyNewStyleStringFormatParser.Field chunk) {
        if (chunk == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(5);
        }
        return true;
    }

    @Override
    @NotNull
    public PyExpression getWholeExpressionToReplace() {
        PyExpression pyExpression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myPyString, PyCallExpression.class);
        if (pyExpression == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(6);
        }
        return pyExpression;
    }

    @Override
    @Nullable
    protected PsiElement getValuesSource() {
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myPyString, PyCallExpression.class);
        assert (callExpression != null);
        return callExpression.getArgumentList();
    }

    @Override
    @Nullable
    protected PsiElement prepareExpressionToInject(@NotNull PyExpression expression, @NotNull PyNewStyleStringFormatParser.Field field) {
        PsiElement prepared;
        if (expression == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(7);
        }
        if (field == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(8);
        }
        if ((prepared = super.prepareExpressionToInject(expression, field)) == null) {
            return null;
        }
        if (!field.getAttributesAndLookups().isEmpty() && (prepared instanceof PyBinaryExpression || prepared instanceof PyPrefixExpression || prepared instanceof PyNumericLiteralExpression)) {
            return this.wrapExpressionInParentheses(prepared);
        }
        return prepared;
    }

    @Override
    protected boolean convertSubstitutionChunk(@NotNull PyNewStyleStringFormatParser.Field field, @NotNull StringBuilder fStringText) {
        TextRange specRange;
        if (field == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(9);
        }
        if (fStringText == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(10);
        }
        String stringText = this.myPyString.getText();
        fStringText.append("{");
        PySubstitutionChunkReference reference = this.createReference(field);
        PyExpression resolveResult = NewStyleConvertToFStringProcessor.adjustResolveResult(reference.resolve());
        if (resolveResult == null) {
            return false;
        }
        PsiElement adjusted = this.prepareExpressionToInject(resolveResult, field);
        if (adjusted == null) {
            return false;
        }
        fStringText.append(adjusted.getText());
        String quotedAttrsAndItems = this.quoteItemsInFragments(field);
        if (quotedAttrsAndItems == null) {
            return false;
        }
        fStringText.append(quotedAttrsAndItems);
        String conversion = field.getConversion();
        if (conversion != null) {
            fStringText.append(conversion);
        }
        if ((specRange = field.getFormatSpecRange()) != null) {
            int specOffset = specRange.getStartOffset();
            if (field.getDepth() == 1) {
                for (PyNewStyleStringFormatParser.Field nestedField : field.getNestedFields()) {
                    fStringText.append(stringText, specOffset, nestedField.getLeftBraceOffset());
                    specOffset = nestedField.getFieldEnd();
                    if (this.convertSubstitutionChunk(nestedField, fStringText)) continue;
                    return false;
                }
            }
            if (specOffset < specRange.getEndOffset()) {
                fStringText.append(stringText, specOffset, specRange.getEndOffset());
            }
        }
        fStringText.append("}");
        return true;
    }

    @Nullable
    private String quoteItemsInFragments(@NotNull PyNewStyleStringFormatParser.Field field) {
        if (field == null) {
            NewStyleConvertToFStringProcessor.$$$reportNull$$$0(11);
        }
        ArrayList<String> escaped = new ArrayList<String>();
        for (String part : field.getAttributesAndLookups()) {
            if (part.startsWith(".")) {
                escaped.add(part);
                continue;
            }
            if (!part.startsWith("[")) continue;
            if (part.contains("\\")) {
                return null;
            }
            String indexText = part.substring(1, part.length() - 1);
            if (indexText.matches("\\d+")) {
                escaped.add(part);
                continue;
            }
            char originalQuote = this.myNodeInfo.getSingleQuote();
            char targetQuote = PyStringLiteralUtil.flipQuote(originalQuote);
            if (indexText.indexOf(targetQuote) >= 0) {
                if (!this.myNodeInfo.isTripleQuoted() || indexText.indexOf(originalQuote) >= 0) {
                    return null;
                }
                targetQuote = originalQuote;
            }
            escaped.add("[" + targetQuote + indexText + targetQuote + "]");
        }
        return StringUtil.join(escaped, (String)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyString";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/convertToFString/NewStyleConvertToFStringProcessor";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fStringText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/convertToFString/NewStyleConvertToFStringProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractAllSubstitutionChunks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTopLevelSubstitutionChunks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWholeExpressionToReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkChunk";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareExpressionToInject";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertSubstitutionChunk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "quoteItemsInFragments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

