/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\b\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/PythonMinicondaLocator;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getMinicondaInstallerFile", "Ljava/io/File;", "getMinicondaInstallerFolder", "getMinicondaInstallerPath", "", "isInstallerExists", "", "intellij.python.community.impl"})
public final class PythonMinicondaLocator {
    private static final Logger LOG;
    public static final PythonMinicondaLocator INSTANCE;

    @Nullable
    public final String getMinicondaInstallerPath() {
        File file = this.getMinicondaInstallerFile();
        return file != null ? file.getAbsolutePath() : null;
    }

    @JvmStatic
    public static final boolean isInstallerExists() {
        return INSTANCE.getMinicondaInstallerFile() != null;
    }

    private final File getMinicondaInstallerFolder() {
        return new File(PathManager.getHomePath(), "minicondaInstaller");
    }

    private final File getMinicondaInstallerFile() {
        String string;
        if (SystemInfo.isWindows) {
            string = "Windows";
        } else if (SystemInfo.isLinux) {
            string = "Linux";
        } else if (SystemInfo.isMac) {
            string = "MacOSX";
        } else {
            LOG.error(SystemInfo.OS_NAME + " isn't expected as an operation system");
            throw (Throwable)new IllegalArgumentException("Wrong OS: " + SystemInfo.OS_NAME);
        }
        String osName = string;
        File installer = new File(this.getMinicondaInstallerFolder(), "Miniconda3-latest-" + osName + "-x86_64." + (SystemInfo.isWindows ? "exe" : "sh"));
        return installer.exists() ? installer : null;
    }

    private PythonMinicondaLocator() {
    }

    static {
        PythonMinicondaLocator pythonMinicondaLocator;
        INSTANCE = pythonMinicondaLocator = new PythonMinicondaLocator();
        Logger logger = Logger.getInstance(PythonMinicondaLocator.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Pytho\u2026condaLocator::class.java)");
        LOG = logger;
    }
}

