/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubParentStrategy
implements DomParentStrategy {
    private static final Logger LOG = Logger.getInstance(StubParentStrategy.class);
    protected final DomStub myStub;

    public StubParentStrategy(@NotNull DomStub stub) {
        if (stub == null) {
            StubParentStrategy.$$$reportNull$$$0(0);
        }
        this.myStub = stub;
    }

    public static StubParentStrategy createAttributeStrategy(@Nullable AttributeStub stub, @NotNull DomStub parent) {
        if (parent == null) {
            StubParentStrategy.$$$reportNull$$$0(1);
        }
        if (stub == null) {
            return new Empty(parent);
        }
        return new StubParentStrategy(stub){

            @Override
            public XmlElement getXmlElement() {
                DomInvocationHandler parentHandler = this.getParentHandler();
                if (parentHandler == null) {
                    LOG.error("no parent handler for " + this);
                    return null;
                }
                XmlTag tag = parentHandler.getXmlTag();
                if (tag == null) {
                    LOG.error("can't find tag for " + (Object)((Object)parentHandler) + "\nparent stub: " + this.myStub.getParentStub() + "\nparent's children: " + ((DomStub)this.myStub.getParentStub()).getChildrenStubs());
                    return null;
                }
                return tag.getAttribute(this.myStub.getName());
            }
        };
    }

    @Override
    public DomInvocationHandler getParentHandler() {
        DomStub parentStub = (DomStub)this.myStub.getParentStub();
        return parentStub == null ? null : parentStub.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlElement getXmlElement() {
        XmlTag[] tags;
        DomStub parentStub = (DomStub)this.myStub.getParentStub();
        if (parentStub == null) {
            return null;
        }
        List children2 = parentStub.getChildrenStubs();
        if (children2.isEmpty()) {
            return null;
        }
        XmlTag parentTag = parentStub.getHandler().getXmlTag();
        if (parentTag == null) {
            return null;
        }
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(true);
            tags = parentTag.getSubTags();
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(false);
        }
        int i = 0;
        String nameToFind = this.myStub.getName();
        for (XmlTag xmlTag : tags) {
            if (!nameToFind.equals(xmlTag.getName()) || xmlTag instanceof IncludedXmlTag || this.myStub.getIndex() != i++) continue;
            return xmlTag;
        }
        return null;
    }

    @Override
    @NotNull
    public DomParentStrategy refreshStrategy(DomInvocationHandler handler) {
        StubParentStrategy stubParentStrategy = this;
        if (stubParentStrategy == null) {
            StubParentStrategy.$$$reportNull$$$0(2);
        }
        return stubParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        if (element == null) {
            StubParentStrategy.$$$reportNull$$$0(3);
        }
        PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(element, DomManagerImpl.getDomManager(element.getProject()));
        if (physicalDomParentStrategy == null) {
            StubParentStrategy.$$$reportNull$$$0(4);
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy clearXmlElement() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        VirtualDomParentStrategy virtualDomParentStrategy = new VirtualDomParentStrategy(parent);
        if (virtualDomParentStrategy == null) {
            StubParentStrategy.$$$reportNull$$$0(5);
        }
        return virtualDomParentStrategy;
    }

    @Override
    public String checkValidity() {
        return null;
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler handler) {
        return this.getParentHandler().getFile();
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StubParentStrategy)) {
            return PhysicalDomParentStrategy.strategyEquals(this, obj);
        }
        if (obj == this) {
            return true;
        }
        StubParentStrategy other = (StubParentStrategy)obj;
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        if (!other.myStub.equals((Object)this.myStub)) {
            return false;
        }
        return Comparing.equal((Object)this.getContainingFile(this.myStub.getHandler()), (Object)other.getContainingFile(other.myStub.getHandler()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/stubs/StubParentStrategy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/stubs/StubParentStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setXmlElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "clearXmlElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeStrategy";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setXmlElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Empty
    extends StubParentStrategy {
        private final DomStub myParent;

        public Empty(DomStub parent) {
            super(parent);
            this.myParent = parent;
        }

        @Override
        public DomInvocationHandler getParentHandler() {
            return this.myParent.getHandler();
        }

        @Override
        public XmlElement getXmlElement() {
            return null;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }
    }
}

