/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomTemplateRunnerImpl
extends DomTemplateRunner {
    private final Project myProject;

    public DomTemplateRunnerImpl(Project project) {
        this.myProject = project;
    }

    public <T extends DomElement> void runTemplate(T t, String mappingId, Editor editor2) {
        this.runTemplate(t, mappingId, editor2, new HashMap<String, String>());
    }

    public <T extends DomElement> void runTemplate(T t, String mappingId, Editor editor2, @NotNull Map<String, String> predefinedVars) {
        if (predefinedVars == null) {
            DomTemplateRunnerImpl.$$$reportNull$$$0(0);
        }
        Template template = DomTemplateRunnerImpl.getTemplate(mappingId);
        this.runTemplate(t, editor2, template, predefinedVars);
    }

    public <T extends DomElement> void runTemplate(T t, Editor editor2, @Nullable Template template) {
        this.runTemplate(t, editor2, template, new HashMap<String, String>());
    }

    public <T extends DomElement> void runTemplate(T t, Editor editor2, @Nullable Template template, Map<String, String> predefinedVars) {
        if (template != null && t != null) {
            DomElement copy = t.createStableCopy();
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            XmlTag tag = copy.getXmlTag();
            assert (tag != null);
            editor2.getCaretModel().moveToOffset(tag.getTextRange().getStartOffset());
            copy.undefine();
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            template.setToReformat(true);
            TemplateManager.getInstance((Project)this.myProject).startTemplate(editor2, template, true, predefinedVars, null);
        }
    }

    @Nullable
    protected static Template getTemplate(String mappingId) {
        return mappingId != null ? TemplateSettings.getInstance().getTemplateById(mappingId) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedVars", "com/intellij/util/xml/impl/DomTemplateRunnerImpl", "runTemplate"));
    }
}

