'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _loaderUtils = require('loader-utils');

var _loaderUtils2 = _interopRequireDefault(_loaderUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function rel(p) {
  return _path2.default.relative(process.cwd(), p);
}

function processResult(loaderContext, result) {
  if (!result || typeof result !== 'object' || 'code' in result === false) {
    loaderContext.callback(new Error(`The returned result of module ${rel(loaderContext.resource)} is not an object with a 'code' property.`));

    return;
  }

  if (typeof result.code !== 'string' && result.code instanceof Buffer === false) {
    loaderContext.callback(new Error(`The returned code of module ${rel(loaderContext.resource)} is neither a string nor an instance of Buffer.`));

    return;
  }

  (result.dependencies || []).forEach(function (dep) {
    return loaderContext.addDependency(dep);
  });

  (result.contextDependencies || []).forEach(function (dep) {
    return loaderContext.addContextDependency(dep);
  });

  // Defaults to false which is a good default here because we assume that
  // results tend to be not cacheable when this loader is necessary
  loaderContext.cacheable(Boolean(result.cacheable));

  loaderContext.callback(null, result.code, result.sourceMap || null, result.ast || null);
}

function valLoader(content) {
  var _this = this;

  var options = _loaderUtils2.default.getOptions(this);
  var exports = this.exec(content, this.resource);
  var func = exports && exports.default ? exports.default : exports;

  if (typeof func !== 'function') {
    throw new Error(`Module ${rel(this.resource)} does not export a function as default.`);
  }

  var result = func(options);

  if (result && typeof result.then === 'function') {
    var callback = this.async();

    result.then(function (res) {
      return processResult(_this, res);
    }, callback);

    return;
  }

  // No return necessary because processResult calls this.callback()
  processResult(this, result);
}

exports.default = valLoader;