/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BlockManager;
import com.sun.java.help.search.BlockProcessor;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.Schema;
import java.io.UnsupportedEncodingException;

public class BtreeDict {
    protected static final int ENTHEADERLEN = 6;
    protected static final int BLOCKSIZE = 2048;
    protected static final int DATALEN = 2040;
    protected static final int MaxKeyLength = 255;
    protected static final int lastPtrIndex = 508;
    protected BlockManager blockManager;
    protected int root;
    protected int[] blocks;
    private boolean debug = false;

    protected BtreeDict() {
    }

    public BtreeDict(BtreeDictParameters btreeDictParameters) throws Exception {
        this.init(btreeDictParameters, false, new BlockFactory(){

            public Block makeBlock() {
                return new DictBlock();
            }
        });
        this.blocks = new int[btreeDictParameters.getFreeID()];
        this.setBlocks(this.blocks);
    }

    public int fetch(String string) throws Exception {
        byte[] byArray = string.getBytes("UTF8");
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        return this.find(this.accessBlock(this.root), byArray2);
    }

    public String fetch(int n) throws Exception {
        return this.findID(this.blocks[n], n);
    }

    public void close() throws Exception {
        this.blockManager.close();
    }

    protected void init(BtreeDictParameters btreeDictParameters, boolean bl, BlockFactory blockFactory) throws Exception {
        this.blockManager = new BlockManager(btreeDictParameters, bl, blockFactory);
        this.root = btreeDictParameters.getRootPosition();
    }

    protected void lock(Block block) {
        this.blockManager.lockBlock(block.number);
    }

    protected void unlock(Block block) {
        this.blockManager.unlockBlock(block.number);
    }

    protected DictBlock accessBlock(int n) throws Exception {
        return (DictBlock)this.blockManager.accessBlock(n);
    }

    protected DictBlock child(DictBlock dictBlock, int n) throws Exception {
        return this.accessBlock(dictBlock.getChildIdx(n));
    }

    private String findID(int n, int n2) throws Exception {
        return this.accessBlock(n).findID(n2);
    }

    private int find(DictBlock dictBlock, byte[] byArray, int n) throws Exception {
        return dictBlock.isLeaf ? 0 : this.find(this.child(dictBlock, n), byArray);
    }

    private int find(DictBlock dictBlock, byte[] byArray) throws Exception {
        int n = byArray.length - 1;
        int n2 = dictBlock.firstEntry();
        int n3 = dictBlock.free();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n2 != n3) {
            if (n5 == n4) {
                int n7;
                int n8 = dictBlock.entryKeyLength(n2);
                int n9 = dictBlock.entryKey(n2);
                for (n7 = 0; n7 < n8 && byArray[n4] == dictBlock.data[n9 + n7]; ++n7) {
                    ++n4;
                }
                if (n7 == n8) {
                    if (n4 == n) {
                        return dictBlock.entryID(n2);
                    }
                } else if ((byArray[n4] & 0xFF) < (dictBlock.data[n9 + n7] & 0xFF)) {
                    return this.find(dictBlock, byArray, n6);
                }
            } else if (n5 < n4) {
                return this.find(dictBlock, byArray, n2 == n3 ? dictBlock.numberOfEntries() : n6);
            }
            do {
                n2 = dictBlock.nextEntry(n2);
                ++n6;
            } while (dictBlock.entryCompression(n2) > n4);
            n5 = dictBlock.entryCompression(n2);
        }
        return this.find(dictBlock, byArray, dictBlock.numberOfEntries());
    }

    private void setBlocks(final int[] nArray) throws Exception {
        long l = System.currentTimeMillis();
        this.blockManager.mapBlocks(new BlockProcessor(){

            public void process(Block block) {
                ((DictBlock)block).setBlockNumbers(nArray);
            }
        });
        this.debug(System.currentTimeMillis() - l + " msec; TMAP");
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("BtreeDict: " + string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Schema schema = new Schema(null, stringArray[0], false);
            BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "TMAP");
            BtreeDict btreeDict = new BtreeDict(btreeDictParameters);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    protected class DictBlock
    extends Block {
        public DictBlock() {
            super(2048);
        }

        public int free() {
            return this.free + this.firstEntry();
        }

        public int numberOfEntries() {
            return this.integerAt(0);
        }

        public int nthPointer(int n) {
            return this.integerAt(4 * (n + 1));
        }

        public int getChildIdx(int n) {
            return this.nthPointer(508 - n);
        }

        public int entryKeyLength(int n) {
            return this.data[n] & 0xFF;
        }

        public int entryCompression(int n) {
            return this.data[n + 1] & 0xFF;
        }

        public int entryID(int n) {
            return this.integerAt(n + 2);
        }

        public int entryLength(int n) {
            return 6 + this.entryKeyLength(n);
        }

        public int entryKey(int n) {
            return n + 6;
        }

        public int firstEntry() {
            return 4;
        }

        public int nextEntry(int n) {
            return n + this.entryLength(n);
        }

        public void restoreKeyInBuffer(int n, byte[] byArray) {
            int n2 = this.entryKeyLength(n);
            int n3 = this.entryCompression(n);
            int n4 = this.entryKey(n);
            while (n2-- > 0) {
                byArray[n3++] = this.data[n4++];
            }
        }

        public String restoreKey(int n, byte[] byArray) {
            int n2 = this.entryKeyLength(n);
            int n3 = this.entryCompression(n);
            int n4 = this.entryKey(n);
            while (n2-- > 0) {
                byArray[n3++] = this.data[n4++];
            }
            String string = null;
            try {
                string = new String(byArray, 0, n3, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return string;
        }

        public String findID(int n) throws Exception {
            byte[] byArray = new byte[255];
            int n2 = this.free();
            int n3 = this.firstEntry();
            while (n3 < n2) {
                if (this.entryID(n3) == n) {
                    return this.restoreKey(n3, byArray);
                }
                this.restoreKeyInBuffer(n3, byArray);
                n3 = this.nextEntry(n3);
            }
            throw new Exception("ID not found in block");
        }

        protected void setBlockNumbers(int[] nArray) {
            int n = this.firstEntry();
            while (n < this.free) {
                nArray[this.entryID((int)n)] = this.number;
                n = this.nextEntry(n);
            }
        }
    }
}

