/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.codegen.AnnotationGen;
import jadx.core.codegen.ClassGen;
import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.NameGen;
import jadx.core.codegen.RegionGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.annotations.MethodParameters;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.FallbackModeVisitor;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.CodeGenUtils;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodGen {
    private static final Logger LOG = LoggerFactory.getLogger(MethodGen.class);
    private final MethodNode mth;
    private final ClassGen classGen;
    private final AnnotationGen annotationGen;
    private final NameGen nameGen;

    public MethodGen(ClassGen classGen, MethodNode mth) {
        this.mth = mth;
        this.classGen = classGen;
        this.annotationGen = classGen.getAnnotationGen();
        this.nameGen = new NameGen(mth, classGen.isFallbackMode());
    }

    public ClassGen getClassGen() {
        return this.classGen;
    }

    public NameGen getNameGen() {
        return this.nameGen;
    }

    public MethodNode getMethodNode() {
        return this.mth;
    }

    public boolean addDefinition(CodeWriter code) {
        Object def;
        if (this.mth.getMethodInfo().isClassInit()) {
            code.attachDefinition(this.mth);
            code.startLine("static");
            return true;
        }
        if (this.mth.contains(AFlag.ANONYMOUS_CONSTRUCTOR)) {
            code.startLine();
            code.attachDefinition(this.mth);
            return false;
        }
        this.annotationGen.addForMethod(code, this.mth);
        AccessInfo clsAccFlags = this.mth.getParentClass().getAccessFlags();
        AccessInfo ai = this.mth.getAccessFlags();
        if (clsAccFlags.isInterface()) {
            ai = ai.remove(1024);
            ai = ai.remove(1);
        }
        if (clsAccFlags.isAnnotation()) {
            ai = ai.remove(1);
        }
        if (this.mth.getMethodInfo().hasAlias() && !ai.isConstructor()) {
            CodeGenUtils.addRenamedComment(code, this.mth, this.mth.getName());
        }
        CodeGenUtils.addSourceFileInfo(code, this.mth);
        if (this.mth.contains(AFlag.INCONSISTENT_CODE)) {
            code.startLine("/* Code decompiled incorrectly, please refer to instructions dump. */");
        }
        code.startLineWithNum(this.mth.getSourceLine());
        code.add(ai.makeString());
        if (this.classGen.addGenericMap(code, this.mth.getGenericMap(), false)) {
            code.add(' ');
        }
        if (ai.isConstructor()) {
            code.attachDefinition(this.mth);
            code.add(this.classGen.getClassNode().getShortName());
        } else {
            this.classGen.useType(code, this.mth.getReturnType());
            code.add(' ');
            code.attachDefinition(this.mth);
            code.add(this.mth.getAlias());
        }
        code.add('(');
        List<RegisterArg> args = this.mth.getArguments(false);
        if (this.mth.getMethodInfo().isConstructor() && this.mth.getParentClass().contains(AType.ENUM_CLASS)) {
            if (args.size() == 2) {
                args.clear();
            } else if (args.size() > 2) {
                args = args.subList(2, args.size());
            } else {
                this.mth.addComment("JADX WARN: Incorrect number of args for enum constructor: " + args.size() + " (expected >= 2)");
            }
        } else if (this.mth.contains(AFlag.SKIP_FIRST_ARG)) {
            args = args.subList(1, args.size());
        }
        this.addMethodArguments(code, args);
        code.add(')');
        this.annotationGen.addThrows(this.mth, code);
        if (this.mth.getParentClass().getAccessFlags().isAnnotation() && (def = this.annotationGen.getAnnotationDefaultValue(this.mth.getName())) != null) {
            code.add(" default ");
            this.annotationGen.encodeValue(code, def);
        }
        return true;
    }

    private void addMethodArguments(CodeWriter code, List<RegisterArg> args) {
        MethodParameters paramsAnnotation = this.mth.get(AType.ANNOTATION_MTH_PARAMETERS);
        int i = 0;
        Iterator<RegisterArg> it = args.iterator();
        while (it.hasNext()) {
            RegisterArg mthArg = it.next();
            SSAVar ssaVar = mthArg.getSVar();
            CodeVar var = ssaVar == null ? CodeVar.fromMthArg(mthArg) : ssaVar.getCodeVar();
            if (paramsAnnotation != null) {
                this.annotationGen.addForParameter(code, paramsAnnotation, i);
            }
            if (var.isFinal()) {
                code.add("final ");
            }
            ArgType argType = var.getType() == ArgType.UNKNOWN ? mthArg.getInitType() : var.getType();
            if (!it.hasNext() && this.mth.getAccessFlags().isVarArgs()) {
                if (argType.isArray()) {
                    ArgType elType = argType.getArrayElement();
                    this.classGen.useType(code, elType);
                    code.add("...");
                } else {
                    this.mth.addComment("JADX INFO: Last argument in varargs method is not array: " + var);
                    this.classGen.useType(code, argType);
                }
            } else {
                this.classGen.useType(code, argType);
            }
            code.add(' ');
            code.add(this.nameGen.assignArg(var));
            ++i;
            if (!it.hasNext()) continue;
            code.add(", ");
        }
    }

    public void addInstructions(CodeWriter code) throws CodegenException {
        if (this.mth.root().getArgs().isFallbackMode()) {
            this.addFallbackMethodCode(code);
        } else if (this.classGen.isFallbackMode()) {
            this.dumpInstructions(code);
        } else {
            this.addRegionInsns(code);
        }
    }

    public void addRegionInsns(CodeWriter code) throws CodegenException {
        try {
            RegionGen regionGen = new RegionGen(this);
            regionGen.makeRegion(code, this.mth.getRegion());
        }
        catch (BootstrapMethodError | StackOverflowError e) {
            this.mth.addError("Method code generation error", new JadxOverflowException("StackOverflow"));
            this.classGen.insertDecompilationProblems(code, this.mth);
            this.dumpInstructions(code);
        }
        catch (Exception e) {
            if (this.mth.getParentClass().getTopParentClass().contains(AFlag.RESTART_CODEGEN)) {
                throw e;
            }
            this.mth.addError("Method code generation error", e);
            this.classGen.insertDecompilationProblems(code, this.mth);
            this.dumpInstructions(code);
        }
    }

    public void dumpInstructions(CodeWriter code) {
        code.startLine("/*");
        this.addFallbackMethodCode(code);
        code.startLine("*/");
        code.startLine("throw new UnsupportedOperationException(\"Method not decompiled: ").add(this.mth.getParentClass().getClassInfo().getAliasFullName()).add('.').add(this.mth.getAlias()).add('(').add(Utils.listToString(this.mth.getMethodInfo().getArgumentsTypes())).add("):").add(this.mth.getMethodInfo().getReturnType().toString()).add("\");");
    }

    public void addFallbackMethodCode(CodeWriter code) {
        InsnNode[] insnArr;
        if (this.mth.getInstructions() == null) {
            try {
                this.mth.unload();
                this.mth.load();
                DepthTraversal.visit((IDexTreeVisitor)new FallbackModeVisitor(), this.mth);
            }
            catch (DecodeException e) {
                LOG.error("Error reload instructions in fallback mode:", (Throwable)e);
                code.startLine("// Can't load method instructions: " + e.getMessage());
                return;
            }
        }
        if ((insnArr = this.mth.getInstructions()) == null) {
            code.startLine("// Can't load method instructions.");
            return;
        }
        code.incIndent();
        if (this.mth.getThisArg() != null) {
            code.startLine(this.nameGen.useArg(this.mth.getThisArg())).add(" = this;");
        }
        MethodGen.addFallbackInsns(code, this.mth, insnArr, true);
        code.decIndent();
    }

    public static void addFallbackInsns(CodeWriter code, MethodNode mth, InsnNode[] insnArr, boolean addLabels) {
        InsnGen insnGen = new InsnGen(MethodGen.getFallbackMethodGen(mth), true);
        boolean attachInsns = mth.root().getArgs().isJsonOutput();
        InsnNode prevInsn = null;
        for (InsnNode insn : insnArr) {
            if (insn == null) continue;
            if (addLabels && MethodGen.needLabel(insn, prevInsn)) {
                code.decIndent();
                code.startLine(MethodGen.getLabelName(insn.getOffset()) + ':');
                code.incIndent();
            }
            if (insn.getType() == InsnType.NOP) continue;
            try {
                ArgType varType;
                RegisterArg resArg;
                code.startLine();
                if (attachInsns) {
                    code.attachLineAnnotation(insn);
                }
                if ((resArg = insn.getResult()) != null && (varType = resArg.getInitType()).isTypeKnown()) {
                    code.add(varType.toString()).add(' ');
                }
                insnGen.makeInsn(insn, code, InsnGen.Flags.INLINE);
                CatchAttr catchAttr = insn.get(AType.CATCH_BLOCK);
                if (catchAttr != null) {
                    code.add("     // " + catchAttr);
                }
            }
            catch (CodegenException e) {
                LOG.debug("Error generate fallback instruction: ", e.getCause());
                code.startLine("// error: " + insn);
            }
            prevInsn = insn;
        }
    }

    private static boolean needLabel(InsnNode insn, InsnNode prevInsn) {
        if (insn.contains(AType.EXC_HANDLER)) {
            return true;
        }
        if (insn.contains(AType.JUMP)) {
            JumpInfo jump;
            List jumps;
            if (prevInsn != null && prevInsn.getType() == InsnType.IF && (jumps = insn.getAll(AType.JUMP)).size() == 1 && (jump = (JumpInfo)jumps.get(0)).getSrc() == prevInsn.getOffset() && jump.getDest() == insn.getOffset()) {
                int target = ((IfNode)prevInsn).getTarget();
                return insn.getOffset() == target;
            }
            return true;
        }
        return false;
    }

    public static MethodGen getFallbackMethodGen(MethodNode mth) {
        ClassGen clsGen = new ClassGen(mth.getParentClass(), null, false, true, true);
        return new MethodGen(clsGen, mth);
    }

    public static String getLabelName(int offset) {
        return "L_" + InsnUtils.formatOffset(offset);
    }
}

