/*
 * Decompiled with CFR 0.152.
 */
package jadx.core;

import jadx.core.codegen.CodeGen;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.ErrorsCounter;
import java.util.List;

public final class ProcessClass {
    private ProcessClass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(ClassNode cls, List<IDexTreeVisitor> passes, boolean generateCode) {
        if (!generateCode && cls.getState() == ProcessState.PROCESSED) {
            return;
        }
        Object object = ProcessClass.getSyncObj(cls);
        synchronized (object) {
            try {
                if (cls.getState() == ProcessState.NOT_LOADED) {
                    cls.load();
                    cls.setState(ProcessState.STARTED);
                    for (IDexTreeVisitor visitor : passes) {
                        DepthTraversal.visit(visitor, cls);
                    }
                    cls.setState(ProcessState.PROCESSED);
                }
                if (cls.getState() == ProcessState.PROCESSED && generateCode) {
                    ProcessClass.processDependencies(cls, passes);
                    CodeGen.generate(cls);
                }
            }
            catch (Exception e) {
                ErrorsCounter.classError(cls, e.getClass().getSimpleName(), e);
            }
        }
    }

    public static Object getSyncObj(ClassNode cls) {
        return cls.getClassInfo();
    }

    private static void processDependencies(ClassNode cls, List<IDexTreeVisitor> passes) {
        cls.getDependencies().forEach(depCls -> ProcessClass.process(depCls, passes, false));
    }
}

