/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.ui.codearea.AbstractCodeArea;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineNumbers
extends JPanel
implements CaretListener {
    private static final Logger LOG = LoggerFactory.getLogger(LineNumbers.class);
    private static final long serialVersionUID = -4978268673635308190L;
    private static final int NUM_HEIGHT = 2146483647;
    private static final Map<?, ?> DESKTOP_HINTS = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private final AbstractCodeArea codeArea;
    private boolean useSourceLines = true;
    private int lastDigits;
    private int lastLine;
    private Map<String, FontMetrics> fonts;
    private final transient Color numberColor;
    private final transient Color currentColor;
    private final transient Border border;

    public LineNumbers(AbstractCodeArea codeArea) {
        this.codeArea = codeArea;
        this.setFont(codeArea.getFont());
        SyntaxScheme syntaxScheme = codeArea.getSyntaxScheme();
        this.numberColor = syntaxScheme.getStyle((int)10).foreground;
        this.currentColor = syntaxScheme.getStyle((int)13).foreground;
        this.border = new MatteBorder(0, 0, 0, 1, syntaxScheme.getStyle((int)2).foreground);
        this.setBackground(codeArea.getBackground());
        this.setForeground(this.numberColor);
        this.setBorderGap(5);
        this.setPreferredWidth();
        codeArea.addCaretListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LineNumbers.this.useSourceLines = !LineNumbers.this.useSourceLines;
                    LineNumbers.this.repaint();
                }
            }
        });
    }

    public void setBorderGap(int borderGap) {
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(this.border, inner));
        this.lastDigits = 0;
    }

    private void setPreferredWidth() {
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), 3);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            if (d != null) {
                d.setSize(preferredWidth, 2146483647);
                this.setPreferredSize(d);
                this.setSize(d);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.applyRenderHints(g);
        Font font = this.codeArea.getFont();
        font = font.deriveFont(font.getSize2D() - 1.0f);
        g.setFont(font);
        Dimension size = this.getSize();
        g.setColor(this.codeArea.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        FontMetrics fontMetrics = this.codeArea.getFontMetrics(font);
        Insets insets = this.getInsets();
        int availableWidth = size.width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.codeArea.viewToModel(new Point(0, clip.y));
        int endOffset = this.codeArea.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                String lineNumber = this.getTextLineNumber(rowStartOffset);
                if (lineNumber != null) {
                    if (this.isCurrentLine(rowStartOffset)) {
                        g.setColor(this.currentColor);
                    } else {
                        g.setColor(this.numberColor);
                    }
                    int stringWidth = fontMetrics.stringWidth(lineNumber);
                    int x = availableWidth - stringWidth + insets.left;
                    int y = this.getOffsetY(rowStartOffset, fontMetrics);
                    g.drawString(lineNumber, x, y);
                }
                rowStartOffset = Utilities.getRowEnd((JTextComponent)((Object)this.codeArea), rowStartOffset) + 1;
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Line numbers draw error", (Throwable)e);
                break;
            }
        }
    }

    private void applyRenderHints(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (DESKTOP_HINTS != null) {
                g2d.setRenderingHints(DESKTOP_HINTS);
            } else {
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
        }
    }

    private boolean isCurrentLine(int rowStartOffset) {
        int caretPosition = this.codeArea.getCaretPosition();
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        return root.getElementIndex(rowStartOffset) == root.getElementIndex(caretPosition);
    }

    @Nullable
    protected String getTextLineNumber(int rowStartOffset) {
        int index;
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
        if (line.getStartOffset() != rowStartOffset) {
            return null;
        }
        int lineNumber = index + 1;
        if (this.useSourceLines) {
            Integer sourceLine = this.codeArea.getSourceLine(lineNumber);
            if (sourceLine == null) {
                return null;
            }
            return String.valueOf(sourceLine);
        }
        return String.valueOf(lineNumber);
    }

    private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r = this.codeArea.modelToView(rowStartOffset);
        if (r == null) {
            throw new BadLocationException("Can't get Y offset", rowStartOffset);
        }
        int lineHeight = fontMetrics.getHeight();
        int y = r.y + r.height;
        int descent = 0;
        if (r.height == lineHeight) {
            descent = fontMetrics.getDescent();
        } else {
            if (this.fonts == null) {
                this.fonts = new HashMap<String, FontMetrics>();
            }
            Element root = this.codeArea.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element line = root.getElement(index);
            for (int i = 0; i < line.getElementCount(); ++i) {
                Element child = line.getElement(i);
                AttributeSet as = child.getAttributes();
                String fontFamily = (String)as.getAttribute(StyleConstants.FontFamily);
                Integer fontSize = (Integer)as.getAttribute(StyleConstants.FontSize);
                String key = fontFamily + fontSize;
                FontMetrics fm = this.fonts.computeIfAbsent(key, k -> {
                    Font font = new Font(fontFamily, 0, fontSize);
                    return this.codeArea.getFontMetrics(font);
                });
                descent = Math.max(descent, fm.getDescent());
            }
        }
        return y - descent;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int caretPosition = this.codeArea.getCaretPosition();
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        if (this.lastLine != currentLine) {
            this.repaint();
            this.lastLine = currentLine;
        }
    }

    public void setUseSourceLines(boolean useSourceLines) {
        this.useSourceLines = useSourceLines;
    }
}

