export interface AlertRuleDTO {
  id: number;
  dashboardId: number;
  dashboardUid: string;
  dashboardSlug: string;
  panelId: number;
  name: string;
  state: string;
  newStateDate: string;
  evalDate: string;
  evalData?: object;
  executionError: string;
  url: string;
}

export interface AlertRule {
  id: number;
  dashboardId: number;
  panelId: number;
  name: string;
  state: string;
  stateText: string;
  stateIcon: string;
  stateClass: string;
  stateAge: string;
  url: string;
  info?: string;
  executionError?: string;
  evalData?: { noData: boolean };
}

export interface AlertRulesState {
  items: AlertRule[];
  searchQuery: string;
}
