/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.DeclarationParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class StatementParser {
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create(JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD);
    private final JavaParser myParser;

    public StatementParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            StatementParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(1);
        }
        return this.parseCodeBlock(builder, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder, boolean isStatement) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(2);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && JavaParserUtil.isParseStatementCodeBlocksDeep(builder)) {
            return this.parseCodeBlockDeep(builder, false);
        }
        return PsiBuilderUtil.parseBlockLazy(builder, JavaTokenType.LBRACE, JavaTokenType.RBRACE, JavaElementType.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(@NotNull PsiBuilder builder, boolean parseUntilEof) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(3);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        this.parseStatements(builder, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
        builder.getTokenType();
        JavaParserUtil.done(codeBlock, JavaElementType.CODE_BLOCK);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(4);
        }
        this.parseStatements(builder, null);
    }

    private void parseStatements(PsiBuilder builder, @Nullable BraceMode braceMode) {
        while (builder.getTokenType() != null) {
            PsiBuilder.Marker statement2 = this.parseStatement(builder);
            if (statement2 != null) continue;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.RBRACE && (braceMode == BraceMode.TILL_FIRST || braceMode == BraceMode.TILL_LAST && builder.lookAhead(1) == null)) break;
            PsiBuilder.Marker error = builder.mark();
            builder.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaErrorMessages.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaErrorMessages.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaErrorMessages.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker statement2;
        IElementType tokenType;
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(5);
        }
        if ((tokenType = builder.getTokenType()) == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return this.parseBreakStatement(builder);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return StatementParser.parseContinueStatement(builder);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(empty, JavaElementType.EMPTY_STATEMENT);
            return empty;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            StatementParser.skipQualifiedName(builder);
            IElementType suspectedLT = builder.getTokenType();
            IElementType next = builder.lookAhead(1);
            refPos.rollbackTo();
            if (suspectedLT == JavaTokenType.LT || suspectedLT == JavaTokenType.DOT && next == JavaTokenType.AT) {
                PsiBuilder.Marker declStatement = builder.mark();
                PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
                if (decl == null) {
                    PsiBuilder.Marker marker = this.myParser.getReferenceParser().parseType(builder, 0);
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    if (marker == null) {
                        builder.advanceLexer();
                    }
                }
                JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                return declStatement;
            }
        }
        PsiBuilder.Marker pos = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null) {
            int count2 = 1;
            PsiBuilder.Marker list2 = expr.precede();
            PsiBuilder.Marker statement3 = list2.precede();
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder.mark();
                builder.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count2;
            }
            if (count2 > 1) {
                pos.drop();
                JavaParserUtil.done(list2, JavaElementType.EXPRESSION_LIST);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement3, JavaElementType.EXPRESSION_LIST_STATEMENT);
                return statement3;
            }
            if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop(list2, pos);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement3, JavaElementType.EXPRESSION_STATEMENT);
                return statement3;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
        if (decl != null) {
            statement2 = decl.precede();
            JavaParserUtil.done(statement2, JavaElementType.DECLARATION_STATEMENT);
            return statement2;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.COLON) {
            statement2 = builder.mark();
            PsiBuilderUtil.advance(builder, 2);
            this.parseStatement(builder);
            JavaParserUtil.done(statement2, JavaElementType.LABELED_STATEMENT);
            return statement2;
        }
        if (expr != null) {
            statement2 = builder.mark();
            this.myParser.getExpressionParser().parse(builder);
            JavaParserUtil.semicolon(builder);
            JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_STATEMENT);
            return statement2;
        }
        return null;
    }

    private static void skipQualifiedName(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder.getTokenType() == JavaTokenType.DOT && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance(builder, 2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker elseStatement;
            PsiBuilder.Marker thenStatement = this.parseStatement(builder);
            if (thenStatement == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            } else if (PsiBuilderUtil.expect(builder, JavaTokenType.ELSE_KEYWORD) && (elseStatement = this.parseStatement(builder)) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement2, JavaElementType.IF_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(6);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.WHILE_STATEMENT, false);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(7);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
            PsiBuilder.Marker marker = statement2;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(8);
            }
            return marker;
        }
        PsiBuilder.Marker afterParenth = builder.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, false, true);
        if (param == null || JavaParserUtil.exprType(param) != JavaElementType.PARAMETER || builder.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            PsiBuilder.Marker marker = this.parseForLoopFromInitializer(builder, statement2);
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(9);
            }
            return marker;
        }
        afterParenth.drop();
        PsiBuilder.Marker marker = this.parseForEachFromColon(builder, statement2);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(10);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder, PsiBuilder.Marker statement2) {
        PsiBuilder.Marker bodyStatement;
        if (this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
                PsiBuilder.Marker marker = statement2;
                if (marker == null) {
                    StatementParser.$$$reportNull$$$0(11);
                }
                return marker;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (StatementParser.getLastToken(builder) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !JavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder)) == null;
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement2;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(12);
                    }
                    return marker;
                }
            } else {
                this.parseForUpdateExpressions(builder);
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                    JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement2;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(13);
                    }
                    return marker;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(14);
        }
        return marker;
    }

    private static IElementType getLastToken(PsiBuilder builder) {
        IElementType token;
        int offset2 = -1;
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder.rawLookup(offset2))) {
            --offset2;
        }
        return token;
    }

    private void parseForUpdateExpressions(PsiBuilder builder) {
        PsiBuilder.Marker expressionStatement;
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            return;
        }
        if (builder.getTokenType() != JavaTokenType.COMMA) {
            expressionStatement = expr.precede();
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_STATEMENT);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            expressionStatement = expressionList.precede();
            do {
                builder.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder);
                if (nextExpression != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            } while (builder.getTokenType() == JavaTokenType.COMMA);
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_LIST_STATEMENT);
        }
        expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder, PsiBuilder.Marker statement2) {
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        }
        if (JavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen") && this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement2, JavaElementType.FOREACH_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(15);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker body = this.parseStatement(builder);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        } else if (!PsiBuilderUtil.expect(builder, JavaTokenType.WHILE_KEYWORD)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.while", new Object[0]));
        } else if (this.parseExprInParenth(builder)) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement2, JavaElementType.DO_WHILE_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.SWITCH_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(17);
        }
        return marker;
    }

    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        boolean isCase = builder.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder.advanceLexer();
        if (isCase) {
            PsiBuilder.Marker expressionList = builder.mark();
            do {
                PsiBuilder.Marker nextExpression;
                if ((nextExpression = this.myParser.getExpressionParser().parseCaseLabel(builder)) != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.ARROW)) {
            PsiBuilder.Marker body;
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                body = builder.mark();
                this.parseCodeBlock(builder, true);
                body.done(JavaElementType.BLOCK_STATEMENT);
                if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                    PsiBuilder.Marker mark = builder.mark();
                    while (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                        builder.advanceLexer();
                    }
                    mark.error(JavaErrorMessages.message("expected.switch.label", new Object[0]));
                }
            } else if (builder.getTokenType() == JavaTokenType.THROW_KEYWORD) {
                this.parseThrowStatement(builder);
            } else {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    body = expr.precede();
                    JavaParserUtil.semicolon(builder);
                    body.done(JavaElementType.EXPRESSION_STATEMENT);
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.switch.rule", new Object[0]));
                    PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
                }
            }
            JavaParserUtil.done(statement2, JavaElementType.SWITCH_LABELED_RULE);
        } else {
            JavaParserUtil.expectOrError(builder, JavaTokenType.COLON, "expected.colon");
            JavaParserUtil.done(statement2, JavaElementType.SWITCH_LABEL_STATEMENT);
        }
        return statement2;
    }

    @NotNull
    private PsiBuilder.Marker parseBreakStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() != JavaTokenType.SEMICOLON) {
            this.myParser.getExpressionParser().parse(builder);
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement2, JavaElementType.BREAK_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(18);
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseContinueStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement2, JavaElementType.CONTINUE_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(19);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        this.myParser.getExpressionParser().parse(builder);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement2, JavaElementType.RETURN_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(20);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement2, JavaElementType.THROW_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(21);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.SYNCHRONIZED_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(22);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder) {
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        boolean bl = hasResourceList = builder.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder);
        }
        if ((tryBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        } else if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder.getTokenType())) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.catch.or.finally", new Object[0]));
        } else {
            PsiBuilder.Marker finallyBlock;
            while (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder)) {
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder, true)) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            }
        }
        JavaParserUtil.done(statement2, JavaElementType.TRY_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(23);
        }
        return marker;
    }

    public boolean parseCatchBlock(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(24);
        }
        assert (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder.getTokenType();
        PsiBuilder.Marker section = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, true, false);
        if (param == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.boolean.expression", new Object[0]));
        } else if (PsiBuilderUtil.expect(builder, JavaTokenType.COLON) && this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement2, JavaElementType.ASSERT_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(25);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        this.parseCodeBlock(builder, true);
        JavaParserUtil.done(statement2, JavaElementType.BLOCK_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(26);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseExprInParenthWithBlock(@NotNull PsiBuilder builder, @NotNull IElementType type2, boolean block) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(27);
        }
        if (type2 == null) {
            StatementParser.$$$reportNull$$$0(28);
        }
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker body;
            PsiBuilder.Marker marker = body = block ? this.parseCodeBlock(builder, true) : this.parseStatement(builder);
            if (body == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message(block ? "expected.lbrace" : "expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement2, type2);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(29);
        }
        return marker;
    }

    private boolean parseExprInParenth(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null || builder.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder.advanceLexer();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIfStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhileStatement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForStatement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForLoopFromInitializer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForEachFromColon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDoWhileStatement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSwitchStatement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBreakStatement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContinueStatement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReturnStatement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseThrowStatement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSynchronizedStatement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTryStatement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAssertStatement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBlockStatement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExprInParenthWithBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlockDeep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStatements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseCatchBlock";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseExprInParenthWithBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

