(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/repl#repl-state::t
    (make-struct-type
     'std/net/repl#repl-state::t
     '#f
     '4
     'repl-state
     '((final: . #t))
     '#f
     '(client channel reader eof)))
  (define std/net/repl#repl-state?
    (make-struct-predicate std/net/repl#repl-state::t))
  (define std/net/repl#make-repl-state
    (lambda _$args143019_
      (apply make-struct-instance std/net/repl#repl-state::t _$args143019_)))
  (define std/net/repl#repl-state-client
    (make-struct-field-accessor std/net/repl#repl-state::t '0))
  (define std/net/repl#repl-state-channel
    (make-struct-field-accessor std/net/repl#repl-state::t '1))
  (define std/net/repl#repl-state-reader
    (make-struct-field-accessor std/net/repl#repl-state::t '2))
  (define std/net/repl#repl-state-eof
    (make-struct-field-accessor std/net/repl#repl-state::t '3))
  (define std/net/repl#repl-state-client-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '0))
  (define std/net/repl#repl-state-channel-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '1))
  (define std/net/repl#repl-state-reader-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '2))
  (define std/net/repl#repl-state-eof-set!
    (make-struct-field-mutator std/net/repl#repl-state::t '3))
  (define std/net/repl#start-repl-server!__%
    (lambda (_g143021_ _passwd142987142991_ _address142988142993_)
      (let* ((_passwd142996_
              (if (eq? _passwd142987142991_ absent-value)
                  '#f
                  _passwd142987142991_))
             (_address142998_
              (if (eq? _address142988142993_ absent-value)
                  '"127.0.0.1:7000"
                  _address142988142993_)))
        (std/logger#start-logger!__0)
        (let* ((_sock143000_
                (open-tcp-server
                 (cons 'server-address:
                       (cons _address142998_
                             (cons 'eol-encoding:
                                   (cons 'cr-lf
                                         (cons 'reuse-address:
                                               (cons '#t '()))))))))
               (_server143002_
                (gerbil/gambit/threads#spawn/group
                 'repl-server
                 std/net/repl#repl-server
                 _sock143000_
                 _passwd142996_)))
          (thread-specific-set! _server143002_ _sock143000_)
          _server143002_))))
  (define std/net/repl#start-repl-server!__@
    (lambda (_keys142986143008_ . _args143010_)
      (apply std/net/repl#start-repl-server!__%
             _keys142986143008_
             (table-ref _keys142986143008_ 'password: absent-value)
             (table-ref _keys142986143008_ 'address: absent-value)
             _args143010_)))
  (define std/net/repl#start-repl-server!
    (lambda _args142989143016_
      (apply keyword-dispatch
             '#(password: address:)
             std/net/repl#start-repl-server!__@
             _args142989143016_)))
  (define std/net/repl#stop-repl-server!
    (lambda (_server142968_)
      (let ((_tgroup142970_ (thread-thread-group _server142968_))
            (_port142971_ (thread-specific _server142968_)))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g142972142975_)
              (if ((lambda (_$obj142978_) (uncaught-exception? _$obj142978_))
                   _g142972142975_)
                  (let ((_e142981_ _g142972142975_))
                    (if (os-exception? (uncaught-exception-reason _e142981_))
                        '#!void
                        (raise _e142981_)))
                  (raise _g142972142975_)))
            (lambda ()
              (close-port _port142971_)
              (std/misc/threads#thread-async! _server142968_ void)
              (thread-join! _server142968_))))
         (lambda () (std/misc/threads#thread-group-kill! _tgroup142970_))))))
  (define std/net/repl#repl-server
    (lambda (_sock142948_ _passwd142949_)
      (let _lp142951_ ()
        (let ((_client142954_ (read _sock142948_)))
          (if (eof-object? _client142954_)
              '#!void
              (begin
                (let ((_sinfo142956_
                       (tcp-client-peer-socket-info _client142954_)))
                  (std/logger#debug
                   '"accepted repl connection from ~a"
                   (std/net/address#inet-address->string
                    (cons (socket-info-address _sinfo142956_)
                          (socket-info-port-number _sinfo142956_)))))
                (output-port-readtable-set!
                 _client142954_
                 (readtable-sharing-allowed?-set
                  (output-port-readtable _client142954_)
                  '#t))
                (let* ((_tgroup142958_ (make-thread-group 'repl-client))
                       (_thread142961_
                        (make-thread
                         (lambda ()
                           (std/net/repl#repl-client
                            _client142954_
                            _passwd142949_))
                         'repl
                         _tgroup142958_))
                       (_state142963_
                        (std/net/repl#make-repl-client-state
                         _client142954_
                         _thread142961_)))
                  (thread-group-specific-set! _tgroup142958_ _state142963_)
                  (thread-start! _thread142961_)
                  (let ((_monitor142966_
                         (gerbil/gambit/threads#spawn/name
                          'repl-client-monitor
                          std/net/repl#repl-client-monitor
                          _thread142961_
                          _tgroup142958_)))
                    (thread-specific-set! _monitor142966_ _tgroup142958_))
                  (_lp142951_))))))))
  (define std/net/repl#repl-client-monitor
    (lambda (_thread142933_ _tgroup142934_)
      (with-unwind-protect
       (lambda ()
         (with-exception-catcher
          (lambda (_g142935142938_)
            (if ((lambda (_$obj142941_) (uncaught-exception? _$obj142941_))
                 _g142935142938_)
                (let ((_e142944_ _g142935142938_))
                  (std/logger#log-error
                   '"repl client error"
                   (uncaught-exception-reason _e142944_)))
                (raise _g142935142938_)))
          (lambda () (thread-join! _thread142933_))))
       (lambda () (std/misc/threads#thread-group-kill! _tgroup142934_)))))
  (define std/net/repl#repl-client
    (lambda (_client142921_ _passwd142922_)
      (if _passwd142922_
          (let _lp142924_ ()
            (display '"Password: " _client142921_)
            (force-output _client142921_)
            (let ((_pw142927_ (read-line _client142921_)))
              (if (equal? _pw142927_ _passwd142922_) '#!void (_lp142924_))))
          '#!void)
      (let ((_state142929_ (std/net/repl#repl-client-state__0)))
        (thread-start!
         (##direct-structure-ref
          _state142929_
          '3
          std/net/repl#repl-state::t
          '#f))
        (call-with-parameters
         (lambda () (replx))
         current-input-port
         (##repl-input-port)
         current-output-port
         (##repl-output-port)
         current-error-port
         (##repl-output-port)
         ##current-user-interrupt-handler
         (lambda () (##handle-interrupt '#f)))
        (close-port _client142921_)
        (thread-terminate!
         (##direct-structure-ref
          _state142929_
          '3
          std/net/repl#repl-state::t
          '#f)))))
  (define std/net/repl#repl-client-reader
    (lambda (_state142880_ _in142881_ _out142882_ _repl-thread142883_)
      (letrec ((_loop142885_
                (lambda (_mode142894_)
                  (let ((_c142896_ (read-char _in142881_)))
                    (if (eof-object? _c142896_)
                        (begin
                          (##direct-structure-set!
                           _state142880_
                           '#t
                           '4
                           std/net/repl#repl-state::t
                           '#f)
                          (close-output-port _out142882_))
                        (let ((_$e142898_ _mode142894_))
                          (if (eq? 'input _$e142898_)
                              (if (char=? _c142896_ '#\xff)
                                  (_loop142885_ _c142896_)
                                  (if (char=? _c142896_ '#\x4)
                                      (begin
                                        (close-output-port _out142882_)
                                        (_loop142885_ _mode142894_))
                                      (begin
                                        (write-char _c142896_ _out142882_)
                                        (force-output _out142882_)
                                        (_loop142885_ _mode142894_))))
                              (if (or (eq? '#\xfb _$e142898_)
                                      (eq? '#\xfc _$e142898_)
                                      (eq? '#\xfe _$e142898_))
                                  (_loop142885_ 'input)
                                  (if (eq? '#\xfd _$e142898_)
                                      (begin
                                        (if (char=? _c142896_ '#\x6)
                                            (let ((_client142907_
                                                   (##direct-structure-ref
                                                    _state142880_
                                                    '1
                                                    std/net/repl#repl-state::t
                                                    '#f)))
                                              (gerbil/gambit/ports#write-u8vector__%
                                               '#u8(255 251 6)
                                               _client142907_)
                                              (force-output _client142907_))
                                            '#!void)
                                        (_loop142885_ 'input))
                                      (if (eq? '#\xff _$e142898_)
                                          (let ((_$e142909_ _c142896_))
                                            (if (eq? '#\xf4 _$e142909_)
                                                (begin
                                                  (std/misc/threads#thread-async!
                                                   _repl-thread142883_
                                                   ##user-interrupt!)
                                                  (_loop142885_ 'input))
                                                (if (or (eq? '#\xfb _$e142909_)
                                                        (eq? '#\xfc _$e142909_)
                                                        (eq? '#\xfd _$e142909_)
                                                        (eq? '#\xfe
                                                             _$e142909_))
                                                    (_loop142885_ _c142896_)
                                                    (_loop142885_ 'input))))
                                          (_loop142885_ 'input)))))))))))
        (with-exception-catcher
         (lambda (_g142886142888_)
           (if '#t
               (let ((_e142891_ _g142886142888_))
                 (std/logger#log-error '"repl reader error" _e142891_)
                 (##direct-structure-set!
                  _state142880_
                  '#t
                  '4
                  std/net/repl#repl-state::t
                  '#f)
                 (close-output-port _out142882_))
               (raise _g142886142888_)))
         (lambda () (_loop142885_ 'input))))))
  (define std/net/repl#make-repl-client-state
    (lambda (_client142862_ _thread142863_)
      (let ((_g143022_
             (open-string-pipe '(direction: input permanent-close: #f))))
        (begin
          (let ((_g143023_
                 (if (##values? _g143022_) (##vector-length _g143022_) 1)))
            (if (not (##fx= _g143023_ 2))
                (error "Context expects 2 values" _g143023_)))
          (let ((_in-rd142865_ (##vector-ref _g143022_ 0))
                (_in-wr142866_ (##vector-ref _g143022_ 1)))
            (let* ((_g143024_
                    (macro-port-name-set!
                     _in-rd142865_
                     (lambda (_port142868_) '(repl))))
                   (_channel142871_
                    (##make-repl-channel-ports _in-rd142865_ _client142862_))
                   (_g143025_
                    (macro-repl-channel-last-owner-set!
                     _channel142871_
                     _thread142863_))
                   (_state142874_
                    (##structure
                     std/net/repl#repl-state::t
                     _client142862_
                     _channel142871_
                     '#f
                     '#f))
                   (_reader142877_
                    (make-thread
                     (lambda ()
                       (std/net/repl#repl-client-reader
                        _state142874_
                        _client142862_
                        _in-wr142866_
                        _thread142863_))
                     'repl-client-reader)))
              (##direct-structure-set!
               _state142874_
               _reader142877_
               '3
               std/net/repl#repl-state::t
               '#f)
              _state142874_))))))
  (define std/net/repl#repl-context-command
    (lambda (_repl-context142854_ _src142855_)
      (if (eof-object? _src142855_)
          (let ((_$e142857_ (std/net/repl#repl-client-state__0)))
            (if _$e142857_
                ((lambda (_state142860_)
                   (if (##direct-structure-ref
                        _state142860_
                        '4
                        std/net/repl#repl-state::t
                        '#f)
                       (##repl-context-return _repl-context142854_ '#!void)
                       (begin
                         (##repl-channel-newline)
                         (if (fx< '0
                                  (macro-repl-context-level
                                   _repl-context142854_))
                             (##repl-cmd-d _repl-context142854_)
                             (if (##repl-channel-really-exit?)
                                 (##repl-context-return
                                  _repl-context142854_
                                  '#!void)
                                 (##repl-context-prompt
                                  _repl-context142854_))))))
                 _$e142857_)
                (##default-repl-context-command
                 _repl-context142854_
                 _src142855_)))
          (##default-repl-context-command _repl-context142854_ _src142855_))))
  (##repl-context-command-set! std/net/repl#repl-context-command)
  (define std/net/repl#make-repl-channel
    (lambda (_thread142849_)
      (let ((_$e142851_ (std/net/repl#repl-client-state__% _thread142849_)))
        (if _$e142851_
            (##direct-structure-ref
             _$e142851_
             '2
             std/net/repl#repl-state::t
             '#f)
            (##default-thread-make-repl-channel _thread142849_)))))
  (##thread-make-repl-channel-set! std/net/repl#make-repl-channel)
  (define std/net/repl#repl-client-state__%
    (lambda (_thread142830_)
      (let _lp142832_ ((_tgroup142834_ (thread-thread-group _thread142830_)))
        (if (not _tgroup142834_)
            '#f
            (let ((_$e142836_ (thread-group-specific _tgroup142834_)))
              (if _$e142836_
                  ((lambda (_state142839_)
                     (if (##structure-direct-instance-of?
                          _state142839_
                          'std/net/repl#repl-state::t)
                         _state142839_
                         (_lp142832_ (thread-group-parent _tgroup142834_))))
                   _$e142836_)
                  (_lp142832_ (thread-group-parent _tgroup142834_))))))))
  (define std/net/repl#repl-client-state__0
    (lambda ()
      (let ((_thread142845_ (current-thread)))
        (std/net/repl#repl-client-state__% _thread142845_))))
  (define std/net/repl#repl-client-state
    (lambda _g143027_
      (let ((_g143026_ (length _g143027_)))
        (cond ((##fx= _g143026_ 0)
               (apply std/net/repl#repl-client-state__0 _g143027_))
              ((##fx= _g143026_ 1)
               (apply std/net/repl#repl-client-state__% _g143027_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/repl#repl-client-state
                _g143027_))))))
  (define std/net/repl#taint!__%
    (lambda (_tgroup142806_)
      (let ((_$e142808_ (std/net/repl#repl-client-state__0)))
        (if _$e142808_
            ((lambda (_state142811_)
               (let* ((_tgroup142816_
                       (let ((_$e142813_ _tgroup142806_))
                         (if _$e142813_
                             _$e142813_
                             (std/misc/threads#primordial-thread-group))))
                      (_ostate142818_ (thread-group-specific _tgroup142816_)))
                 (thread-group-specific-set! _tgroup142816_ _state142811_)
                 _ostate142818_))
             _$e142808_)
            (error '"No repl state")))))
  (define std/net/repl#taint!__0
    (lambda ()
      (let ((_tgroup142825_ '#f)) (std/net/repl#taint!__% _tgroup142825_))))
  (define std/net/repl#taint!
    (lambda _g143029_
      (let ((_g143028_ (length _g143029_)))
        (cond ((##fx= _g143028_ 0) (apply std/net/repl#taint!__0 _g143029_))
              ((##fx= _g143028_ 1) (apply std/net/repl#taint!__% _g143029_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/repl#taint!
                _g143029_))))))
  (define std/net/repl#untaint!__%
    (lambda (_tgroup142782_ _state142783_)
      (let ((_tgroup142788_
             (let ((_$e142785_ _tgroup142782_))
               (if _$e142785_
                   _$e142785_
                   (std/misc/threads#primordial-thread-group)))))
        (if (##structure-direct-instance-of?
             (thread-group-specific _tgroup142788_)
             'std/net/repl#repl-state::t)
            (thread-group-specific-set! _tgroup142788_ _state142783_)
            (error '"No tainted repl state in thread-group" _tgroup142788_)))))
  (define std/net/repl#untaint!__0
    (lambda ()
      (let* ((_tgroup142794_ '#f) (_state142796_ '#f))
        (std/net/repl#untaint!__% _tgroup142794_ _state142796_))))
  (define std/net/repl#untaint!__1
    (lambda (_tgroup142798_)
      (let ((_state142800_ '#f))
        (std/net/repl#untaint!__% _tgroup142798_ _state142800_))))
  (define std/net/repl#untaint!
    (lambda _g143031_
      (let ((_g143030_ (length _g143031_)))
        (cond ((##fx= _g143030_ 0) (apply std/net/repl#untaint!__0 _g143031_))
              ((##fx= _g143030_ 1) (apply std/net/repl#untaint!__1 _g143031_))
              ((##fx= _g143030_ 2) (apply std/net/repl#untaint!__% _g143031_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/repl#untaint!
                _g143031_)))))))
