/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;

public class IsSimpleOp {
    private Geometry inputGeom;
    private boolean isClosedEndpointsInInterior = true;
    private Coordinate nonSimpleLocation = null;

    public IsSimpleOp() {
    }

    public IsSimpleOp(Geometry geom) {
        this.inputGeom = geom;
    }

    public IsSimpleOp(Geometry geom, BoundaryNodeRule boundaryNodeRule) {
        this.inputGeom = geom;
        this.isClosedEndpointsInInterior = !boundaryNodeRule.isInBoundary(2);
    }

    public boolean isSimple() {
        this.nonSimpleLocation = null;
        return this.computeSimple(this.inputGeom);
    }

    private boolean computeSimple(Geometry geom) {
        this.nonSimpleLocation = null;
        if (geom.isEmpty()) {
            return true;
        }
        if (geom instanceof LineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)geom);
        }
        if (geom instanceof Polygonal) {
            return this.isSimplePolygonal(geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.isSimpleGeometryCollection(geom);
        }
        return true;
    }

    public Coordinate getNonSimpleLocation() {
        return this.nonSimpleLocation;
    }

    public boolean isSimple(LineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiLineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiPoint mp) {
        return this.isSimpleMultiPoint(mp);
    }

    private boolean isSimpleMultiPoint(MultiPoint mp) {
        if (mp.isEmpty()) {
            return true;
        }
        TreeSet<Coordinate> points = new TreeSet<Coordinate>();
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Point pt = (Point)mp.getGeometryN(i);
            Coordinate p = pt.getCoordinate();
            if (points.contains(p)) {
                this.nonSimpleLocation = p;
                return false;
            }
            points.add(p);
        }
        return true;
    }

    private boolean isSimplePolygonal(Geometry geom) {
        List rings = LinearComponentExtracter.getLines(geom);
        for (LinearRing ring : rings) {
            if (this.isSimpleLinearGeometry(ring)) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleGeometryCollection(Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry comp = geom.getGeometryN(i);
            if (this.computeSimple(comp)) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleLinearGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        GeometryGraph graph = new GeometryGraph(0, geom);
        RobustLineIntersector li = new RobustLineIntersector();
        SegmentIntersector si = graph.computeSelfNodes(li, true);
        if (!si.hasIntersection()) {
            return true;
        }
        if (si.hasProperIntersection()) {
            this.nonSimpleLocation = si.getProperIntersectionPoint();
            return false;
        }
        if (this.hasNonEndpointIntersection(graph)) {
            return false;
        }
        return !this.isClosedEndpointsInInterior || !this.hasClosedEndpointIntersection(graph);
    }

    private boolean hasNonEndpointIntersection(GeometryGraph graph) {
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            Iterator eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                if (ei.isEndPoint(maxSegmentIndex)) continue;
                this.nonSimpleLocation = ei.getCoordinate();
                return true;
            }
        }
        return false;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph graph) {
        TreeMap endPoints = new TreeMap();
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            boolean isClosed = e.isClosed();
            Coordinate p0 = e.getCoordinate(0);
            this.addEndpoint(endPoints, p0, isClosed);
            Coordinate p1 = e.getCoordinate(e.getNumPoints() - 1);
            this.addEndpoint(endPoints, p1, isClosed);
        }
        for (EndpointInfo eiInfo : endPoints.values()) {
            if (!eiInfo.isClosed || eiInfo.degree == 2) continue;
            this.nonSimpleLocation = eiInfo.getCoordinate();
            return true;
        }
        return false;
    }

    private void addEndpoint(Map endPoints, Coordinate p, boolean isClosed) {
        EndpointInfo eiInfo = (EndpointInfo)endPoints.get(p);
        if (eiInfo == null) {
            eiInfo = new EndpointInfo(p);
            endPoints.put(p, eiInfo);
        }
        eiInfo.addEndpoint(isClosed);
    }

    private static class EndpointInfo {
        Coordinate pt;
        boolean isClosed;
        int degree;

        public EndpointInfo(Coordinate pt) {
            this.pt = pt;
            this.isClosed = false;
            this.degree = 0;
        }

        public Coordinate getCoordinate() {
            return this.pt;
        }

        public void addEndpoint(boolean isClosed) {
            ++this.degree;
            this.isClosed |= isClosed;
        }
    }
}

