/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.grok.GrokMatchGroup;
import org.elasticsearch.grok.ThreadWatchdog;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.ValueException;

public final class Grok {
    private static final String NAME_GROUP = "name";
    private static final String SUBNAME_GROUP = "subname";
    private static final String PATTERN_GROUP = "pattern";
    private static final String DEFINITION_GROUP = "definition";
    private static final String GROK_PATTERN = "%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:(?:[^{}]+|\\.+)+)+))?\\}";
    private static final Regex GROK_PATTERN_REGEX = new Regex("%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:(?:[^{}]+|\\.+)+)+))?\\}".getBytes(StandardCharsets.UTF_8), 0, "%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:(?:[^{}]+|\\.+)+)+))?\\}".getBytes(StandardCharsets.UTF_8).length, 0, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT);
    private static final Map<String, String> builtinPatterns;
    private final Map<String, String> patternBank;
    private final boolean namedCaptures;
    private final Regex compiledExpression;
    private final ThreadWatchdog threadWatchdog;

    public Grok(Map<String, String> patternBank, String grokPattern) {
        this(patternBank, grokPattern, true, ThreadWatchdog.noop());
    }

    public Grok(Map<String, String> patternBank, String grokPattern, ThreadWatchdog threadWatchdog) {
        this(patternBank, grokPattern, true, threadWatchdog);
    }

    Grok(Map<String, String> patternBank, String grokPattern, boolean namedCaptures) {
        this(patternBank, grokPattern, namedCaptures, ThreadWatchdog.noop());
    }

    private Grok(Map<String, String> patternBank, String grokPattern, boolean namedCaptures, ThreadWatchdog threadWatchdog) {
        this.patternBank = patternBank;
        this.namedCaptures = namedCaptures;
        this.threadWatchdog = threadWatchdog;
        for (Map.Entry<String, String> entry : patternBank.entrySet()) {
            String name = entry.getKey();
            String pattern = entry.getValue();
            this.forbidCircularReferences(name, new ArrayList<String>(), pattern);
        }
        String expression = this.toRegex(grokPattern);
        byte[] expressionBytes = expression.getBytes(StandardCharsets.UTF_8);
        this.compiledExpression = new Regex(expressionBytes, 0, expressionBytes.length, 0, (Encoding)UTF8Encoding.INSTANCE);
    }

    private void forbidCircularReferences(String patternName, List<String> path, String pattern) {
        if (pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":")) {
            String message;
            if (path.isEmpty()) {
                message = "circular reference in pattern [" + patternName + "][" + pattern + "]";
            } else {
                message = "circular reference in pattern [" + path.remove(path.size() - 1) + "][" + pattern + "] back to pattern [" + patternName + "]";
                if (!path.isEmpty()) {
                    message = message + " via patterns [" + String.join((CharSequence)"=>", path) + "]";
                }
            }
            throw new IllegalArgumentException(message);
        }
        int i = pattern.indexOf("%{");
        while (i != -1) {
            int end;
            int begin = i + 2;
            int brackedIndex = pattern.indexOf(125, begin);
            int columnIndex = pattern.indexOf(58, begin);
            if (brackedIndex != -1 && columnIndex == -1) {
                end = brackedIndex;
            } else if (columnIndex != -1 && brackedIndex == -1) {
                end = columnIndex;
            } else if (brackedIndex != -1 && columnIndex != -1) {
                end = Math.min(brackedIndex, columnIndex);
            } else {
                throw new IllegalArgumentException("pattern [" + pattern + "] has circular references to other pattern definitions");
            }
            String otherPatternName = pattern.substring(begin, end);
            path.add(otherPatternName);
            this.forbidCircularReferences(patternName, path, this.patternBank.get(otherPatternName));
            i = pattern.indexOf("%{", i + 1);
        }
    }

    public String groupMatch(String name, Region region, String pattern) {
        try {
            int number = GROK_PATTERN_REGEX.nameToBackrefNumber(name.getBytes(StandardCharsets.UTF_8), 0, name.getBytes(StandardCharsets.UTF_8).length, region);
            int begin = region.beg[number];
            int end = region.end[number];
            return new String(pattern.getBytes(StandardCharsets.UTF_8), begin, end - begin, StandardCharsets.UTF_8);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        catch (ValueException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toRegex(String grokPattern) {
        int result;
        byte[] grokPatternBytes = grokPattern.getBytes(StandardCharsets.UTF_8);
        Matcher matcher = GROK_PATTERN_REGEX.matcher(grokPatternBytes);
        try {
            this.threadWatchdog.register();
            result = matcher.search(0, grokPatternBytes.length, 0);
        }
        finally {
            this.threadWatchdog.unregister();
        }
        if (result != -1) {
            Region region = matcher.getEagerRegion();
            String namedPatternRef = this.groupMatch(NAME_GROUP, region, grokPattern);
            String subName = this.groupMatch(SUBNAME_GROUP, region, grokPattern);
            String definition = this.groupMatch(DEFINITION_GROUP, region, grokPattern);
            String patternName = this.groupMatch(PATTERN_GROUP, region, grokPattern);
            String pattern = this.patternBank.get(patternName);
            if (pattern == null) {
                throw new IllegalArgumentException("Unable to find pattern [" + patternName + "] in Grok's pattern dictionary");
            }
            if (pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":")) {
                throw new IllegalArgumentException("circular reference in pattern back [" + patternName + "]");
            }
            String grokPart = this.namedCaptures && subName != null ? String.format(Locale.US, "(?<%s>%s)", namedPatternRef, pattern) : (!this.namedCaptures ? String.format(Locale.US, "(?<%s>%s)", patternName + "_" + String.valueOf(result), pattern) : String.format(Locale.US, "(?:%s)", pattern));
            String start = new String(grokPatternBytes, 0, result, StandardCharsets.UTF_8);
            String rest = new String(grokPatternBytes, region.end[0], grokPatternBytes.length - region.end[0], StandardCharsets.UTF_8);
            return start + this.toRegex(grokPart + rest);
        }
        return grokPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(String text) {
        int result;
        Matcher matcher = this.compiledExpression.matcher(text.getBytes(StandardCharsets.UTF_8));
        try {
            this.threadWatchdog.register();
            result = matcher.search(0, text.length(), 0);
        }
        finally {
            this.threadWatchdog.unregister();
        }
        return result != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> captures(String text) {
        int result;
        byte[] textAsBytes = text.getBytes(StandardCharsets.UTF_8);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        Matcher matcher = this.compiledExpression.matcher(textAsBytes);
        try {
            this.threadWatchdog.register();
            result = matcher.search(0, textAsBytes.length, 0);
        }
        finally {
            this.threadWatchdog.unregister();
        }
        if (result == -2) {
            throw new RuntimeException("grok pattern matching was interrupted after [" + this.threadWatchdog.maxExecutionTimeInMillis() + "] ms");
        }
        if (result == -1) {
            return null;
        }
        if (this.compiledExpression.numberOfNames() > 0) {
            Region region = matcher.getEagerRegion();
            Iterator entry = this.compiledExpression.namedBackrefIterator();
            block3: while (entry.hasNext()) {
                NameEntry e = (NameEntry)entry.next();
                String groupName = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8);
                for (int number : e.getBackRefs()) {
                    if (region.beg[number] < 0) continue;
                    String matchValue = new String(textAsBytes, region.beg[number], region.end[number] - region.beg[number], StandardCharsets.UTF_8);
                    GrokMatchGroup match = new GrokMatchGroup(groupName, matchValue);
                    fields.put(match.getName(), match.getValue());
                    continue block3;
                }
            }
        }
        return fields;
    }

    public static Map<String, String> getBuiltinPatterns() {
        return builtinPatterns;
    }

    private static Map<String, String> loadBuiltinPatterns() throws IOException {
        String[] PATTERN_NAMES = new String[]{"aws", "bacula", "bro", "exim", "firewalls", "grok-patterns", "haproxy", "java", "junos", "linux-syslog", "mcollective-patterns", "mongodb", "nagios", "postgresql", "rails", "redis", "ruby"};
        HashMap<String, String> builtinPatterns = new HashMap<String, String>();
        for (String pattern : PATTERN_NAMES) {
            try (InputStream is = Grok.class.getResourceAsStream("/patterns/" + pattern);){
                Grok.loadPatterns(builtinPatterns, is);
            }
        }
        return Collections.unmodifiableMap(builtinPatterns);
    }

    private static void loadPatterns(Map<String, String> patternBank, InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            String[] parts;
            String trimmedLine = line.replaceAll("^\\s+", "");
            if (trimmedLine.startsWith("#") || trimmedLine.length() == 0 || (parts = trimmedLine.split("\\s+", 2)).length != 2) continue;
            patternBank.put(parts[0], parts[1]);
        }
    }

    static {
        try {
            builtinPatterns = Grok.loadBuiltinPatterns();
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to load built-in grok patterns", e);
        }
    }
}

