/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.util.BitUtil;

public final class XTessellator {
    private static final int VERTEX_THRESHOLD = 80;

    private XTessellator() {
    }

    public static List<Triangle> tessellate(Polygon polygon) {
        List<Triangle> result;
        boolean mortonOptimized;
        Node outerNode = XTessellator.createDoublyLinkedList(polygon, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            throw new IllegalArgumentException("Malformed shape detected in XTessellator!");
        }
        if (polygon.numHoles() > 0) {
            outerNode = XTessellator.eliminateHoles(polygon, outerNode);
        }
        int threshold = 80 - polygon.numPoints();
        for (int i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        boolean bl = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            XTessellator.sortByMorton(outerNode);
        }
        if ((result = XTessellator.earcutLinkedList(outerNode, new ArrayList<Triangle>(), State.INIT, mortonOptimized)).size() == 0) {
            throw new IllegalArgumentException("Unable to Tessellate shape [" + polygon + "]. Possible malformed shape detected.");
        }
        return result;
    }

    private static Node createDoublyLinkedList(Polygon polygon, int startIndex, GeoUtils.WindingOrder windingOrder) {
        Node lastNode = null;
        if (windingOrder == polygon.getWindingOrder()) {
            for (int i = 0; i < polygon.numPoints(); ++i) {
                lastNode = XTessellator.insertNode(polygon, startIndex++, i, lastNode);
            }
        } else {
            for (int i = polygon.numPoints() - 1; i >= 0; --i) {
                lastNode = XTessellator.insertNode(polygon, startIndex++, i, lastNode);
            }
        }
        if (lastNode != null && XTessellator.isVertexEquals(lastNode, lastNode.next)) {
            XTessellator.removeNode(lastNode);
            lastNode = lastNode.next;
        }
        return XTessellator.filterPoints(lastNode, null);
    }

    private static Node eliminateHoles(Polygon polygon, Node outerNode) {
        int i;
        ArrayList<Node> holeList = new ArrayList<Node>();
        Polygon[] holes = polygon.getHoles();
        int nodeIndex = polygon.numPoints();
        for (i = 0; i < polygon.numHoles(); ++i) {
            Node list = XTessellator.createDoublyLinkedList(holes[i], nodeIndex, GeoUtils.WindingOrder.CCW);
            if (list == list.next) {
                list.isSteiner = true;
            }
            if (list != null) {
                holeList.add(XTessellator.fetchLeftmost(list));
            }
            nodeIndex += holes[i].numPoints();
        }
        holeList.sort((pNodeA, pNodeB) -> pNodeA.getX() < pNodeB.getX() ? -1 : (pNodeA.getX() == pNodeB.getX() ? 0 : 1));
        for (i = 0; i < holeList.size(); ++i) {
            Node holeNode = (Node)holeList.get(i);
            XTessellator.eliminateHole(holeNode, outerNode);
            outerNode = XTessellator.filterPoints(outerNode, outerNode.next);
        }
        return outerNode;
    }

    private static void eliminateHole(Node holeNode, Node outerNode) {
        if ((outerNode = XTessellator.fetchHoleBridge(holeNode, outerNode)) != null) {
            Node node = XTessellator.splitPolygon(outerNode, holeNode);
            XTessellator.filterPoints(node, node.next);
        }
    }

    private static Node fetchHoleBridge(Node holeNode, Node outerNode) {
        Node p = outerNode;
        double qx = Double.NEGATIVE_INFINITY;
        double hx = holeNode.getX();
        double hy = holeNode.getY();
        Node connection = null;
        do {
            double x;
            if (!(hy <= p.getY()) || !(hy >= p.next.getY()) || p.next.getY() == p.getY() || !((x = p.getX() + (hy - p.getY()) * (p.next.getX() - p.getX()) / (p.next.getY() - p.getY())) <= hx) || !(x > qx)) continue;
            qx = x;
            if (x == hx) {
                if (hy == p.getY()) {
                    return p;
                }
                if (hy == p.next.getY()) {
                    return p.next;
                }
            }
            Node node = connection = p.getX() < p.next.getX() ? p : p.next;
        } while ((p = p.next) != outerNode);
        if (connection == null) {
            return null;
        }
        if (hx == qx) {
            return connection.previous;
        }
        Node stop = connection;
        double mx = connection.getX();
        double my = connection.getY();
        double tanMin = Double.POSITIVE_INFINITY;
        p = connection.next;
        while (p != stop) {
            double tan;
            if (hx >= p.getX() && p.getX() >= mx && hx != p.getX() && XTessellator.pointInEar(p.getX(), p.getY(), hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy) && ((tan = Math.abs(hy - p.getY()) / (hx - p.getX())) < tanMin || tan == tanMin && p.getX() > connection.getX()) && XTessellator.isLocallyInside(p, holeNode)) {
                connection = p;
                tanMin = tan;
            }
            p = p.next;
        }
        return connection;
    }

    private static Node fetchLeftmost(Node start) {
        Node node = start;
        Node leftMost = start;
        do {
            if (!(node.getX() < leftMost.getX())) continue;
            leftMost = node;
        } while ((node = node.next) != start);
        return leftMost;
    }

    private static List<Triangle> earcutLinkedList(Node currEar, List<Triangle> tessellation, State state, boolean mortonOptimized) {
        block9: {
            block5: while (true) {
                if (currEar == null || currEar.previous == currEar.next) {
                    return tessellation;
                }
                Node stop = currEar;
                do {
                    boolean isReflex;
                    Node prevNode = currEar.previous;
                    Node nextNode = currEar.next;
                    boolean bl = isReflex = XTessellator.area(prevNode.getX(), prevNode.getY(), currEar.getX(), currEar.getY(), nextNode.getX(), nextNode.getY()) >= 0.0;
                    if (!isReflex && XTessellator.isEar(currEar, mortonOptimized)) {
                        tessellation.add(new Triangle(prevNode, currEar, nextNode));
                        XTessellator.removeNode(currEar);
                        currEar = nextNode.next;
                        stop = nextNode.next;
                        continue;
                    }
                    currEar = nextNode;
                    if (currEar != stop) continue;
                    switch (state) {
                        case INIT: {
                            currEar = XTessellator.filterPoints(currEar, null);
                            state = State.CURE;
                            continue block5;
                        }
                        case CURE: {
                            currEar = XTessellator.cureLocalIntersections(currEar, tessellation);
                            state = State.SPLIT;
                            continue block5;
                        }
                        case SPLIT: {
                            if (XTessellator.splitEarcut(currEar, tessellation, mortonOptimized)) break;
                            tessellation.clear();
                        }
                    }
                    break block9;
                } while (currEar.previous != currEar.next);
                break;
            }
        }
        return tessellation;
    }

    private static boolean isEar(Node ear, boolean mortonOptimized) {
        if (mortonOptimized) {
            return XTessellator.mortonIsEar(ear);
        }
        Node node = ear.next.next;
        while (node != ear.previous) {
            if (XTessellator.pointInEar(node.getX(), node.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && XTessellator.area(node.previous.getX(), node.previous.getY(), node.getX(), node.getY(), node.next.getX(), node.next.getY()) >= 0.0) {
                return false;
            }
            node = node.next;
        }
        return true;
    }

    private static boolean mortonIsEar(Node ear) {
        int minTX = StrictMath.min(StrictMath.min(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int minTY = StrictMath.min(StrictMath.min(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        int maxTX = StrictMath.max(StrictMath.max(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int maxTY = StrictMath.max(StrictMath.max(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.interleave((int)minTX, (int)minTY);
        long maxZ = BitUtil.interleave((int)maxTX, (int)maxTY);
        Node p = ear.previousZ;
        Node n = ear.nextZ;
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0 && n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (p.idx != ear.previous.idx && p.idx != ear.next.idx && XTessellator.pointInEar(p.getX(), p.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && XTessellator.area(p.previous.getX(), p.previous.getY(), p.getX(), p.getY(), p.next.getX(), p.next.getY()) >= 0.0) {
                return false;
            }
            p = p.previousZ;
            if (n.idx != ear.previous.idx && n.idx != ear.next.idx && XTessellator.pointInEar(n.getX(), n.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && XTessellator.area(n.previous.getX(), n.previous.getY(), n.getX(), n.getY(), n.next.getX(), n.next.getY()) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0) {
            if (p.idx != ear.previous.idx && p.idx != ear.next.idx && XTessellator.pointInEar(p.getX(), p.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && XTessellator.area(p.previous.getX(), p.previous.getY(), p.getX(), p.getY(), p.next.getX(), p.next.getY()) >= 0.0) {
                return false;
            }
            p = p.previousZ;
        }
        while (n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (n.idx != ear.previous.idx && n.idx != ear.next.idx && XTessellator.pointInEar(n.getX(), n.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && XTessellator.area(n.previous.getX(), n.previous.getY(), n.getX(), n.getY(), n.next.getX(), n.next.getY()) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        return true;
    }

    private static Node cureLocalIntersections(Node startNode, List<Triangle> tessellation) {
        Node node = startNode;
        do {
            Node b;
            Node nextNode = node.next;
            Node a = node.previous;
            if (XTessellator.isVertexEquals(a, b = nextNode.next) || XTessellator.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY()) || !XTessellator.linesIntersect(a.getX(), a.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), b.getX(), b.getY()) || !XTessellator.isLocallyInside(a, b) || !XTessellator.isLocallyInside(b, a)) continue;
            tessellation.add(new Triangle(a, node, b));
            XTessellator.removeNode(node);
            XTessellator.removeNode(node.next);
            node = startNode = b;
        } while ((node = node.next) != startNode);
        return node;
    }

    private static boolean splitEarcut(Node start, List<Triangle> tessellation, boolean mortonIndexed) {
        Node searchNode = start;
        do {
            Node nextNode = searchNode.next;
            Node diagonal = nextNode.next;
            while (diagonal != searchNode.previous) {
                if (XTessellator.isValidDiagonal(searchNode, diagonal)) {
                    Node splitNode = XTessellator.splitPolygon(searchNode, diagonal);
                    searchNode = XTessellator.filterPoints(searchNode, searchNode.next);
                    splitNode = XTessellator.filterPoints(splitNode, splitNode.next);
                    if (mortonIndexed) {
                        XTessellator.sortByMortonWithReset(searchNode);
                        XTessellator.sortByMortonWithReset(splitNode);
                    }
                    XTessellator.earcutLinkedList(searchNode, tessellation, State.INIT, mortonIndexed);
                    XTessellator.earcutLinkedList(splitNode, tessellation, State.INIT, mortonIndexed);
                    return true;
                }
                diagonal = diagonal.next;
            }
        } while ((searchNode = searchNode.next) != start);
        return false;
    }

    private static Node splitPolygon(Node a, Node b) {
        Node a2 = new Node(a);
        Node b2 = new Node(b);
        Node an = a.next;
        Node bp = b.previous;
        a.next = b;
        a.nextZ = b;
        b.previous = a;
        b.previousZ = a;
        a2.next = an;
        a2.nextZ = an;
        an.previous = a2;
        an.previousZ = a2;
        b2.next = a2;
        b2.nextZ = a2;
        a2.previous = b2;
        a2.previousZ = b2;
        bp.next = b2;
        bp.nextZ = b2;
        return b2;
    }

    private static boolean isValidDiagonal(Node a, Node b) {
        return a.next.idx != b.idx && a.previous.idx != b.idx && !XTessellator.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY()) && XTessellator.isLocallyInside(a, b) && XTessellator.isLocallyInside(b, a) && XTessellator.middleInsert(a, a.getX(), a.getY(), b.getX(), b.getY());
    }

    private static boolean isLocallyInside(Node a, Node b) {
        if (XTessellator.area(a.previous.getX(), a.previous.getY(), a.getX(), a.getY(), a.next.getX(), a.next.getY()) < 0.0) {
            return XTessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.next.getX(), a.next.getY()) >= 0.0 && XTessellator.area(a.getX(), a.getY(), a.previous.getX(), a.previous.getY(), b.getX(), b.getY()) >= 0.0;
        }
        return XTessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.previous.getX(), a.previous.getY()) < 0.0 || XTessellator.area(a.getX(), a.getY(), a.next.getX(), a.next.getY(), b.getX(), b.getY()) < 0.0;
    }

    private static boolean middleInsert(Node start, double x0, double y0, double x1, double y1) {
        Node node = start;
        boolean lIsInside = false;
        double lDx = (x0 + x1) / 2.0;
        double lDy = (y0 + y1) / 2.0;
        do {
            Node nextNode = node.next;
            if (node.getY() > lDy == nextNode.getY() > lDy || !(lDx < (nextNode.getX() - node.getX()) * (lDy - node.getY()) / (nextNode.getY() - node.getY()) + node.getX())) continue;
            boolean bl = lIsInside = !lIsInside;
        } while ((node = node.next) != start);
        return lIsInside;
    }

    private static boolean isIntersectingPolygon(Node start, double x0, double y0, double x1, double y1) {
        Node nextNode;
        Node node = start;
        do {
            nextNode = node.next;
            if (XTessellator.isVertexEquals(node, x0, y0) || XTessellator.isVertexEquals(node, x1, y1) || !XTessellator.linesIntersect(node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), x0, y0, x1, y1)) continue;
            return true;
        } while ((node = nextNode) != start);
        return false;
    }

    public static boolean linesIntersect(double aX0, double aY0, double aX1, double aY1, double bX0, double bY0, double bX1, double bY1) {
        return XTessellator.area(aX0, aY0, aX1, aY1, bX0, bY0) > 0.0 != XTessellator.area(aX0, aY0, aX1, aY1, bX1, bY1) > 0.0 && XTessellator.area(bX0, bY0, bX1, bY1, aX0, aY0) > 0.0 != XTessellator.area(bX0, bY0, bX1, bY1, aX1, aY1) > 0.0;
    }

    private static void sortByMortonWithReset(Node start) {
        Node next = start;
        do {
            next.previousZ = next.previous;
            next.nextZ = next.next;
        } while ((next = next.next) != start);
        XTessellator.sortByMorton(start);
    }

    private static void sortByMorton(Node start) {
        start.previousZ.nextZ = null;
        start.previousZ = null;
        XTessellator.tathamSort(start);
    }

    private static void tathamSort(Node list) {
        int numMerges;
        int inSize = 1;
        if (list == null) {
            return;
        }
        do {
            Node p = list;
            list = null;
            Node tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                Node q = p;
                int i = 0;
                int pSize = 0;
                while (i < inSize && q != null) {
                    ++i;
                    ++pSize;
                    q = q.nextZ;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Node e;
                    if (pSize != 0 && (qSize == 0 || q == null || Long.compareUnsigned(p.morton, q.morton) <= 0)) {
                        e = p;
                        p = p.nextZ;
                        --pSize;
                    } else {
                        e = q;
                        q = q.nextZ;
                        --qSize;
                    }
                    if (tail != null) {
                        tail.nextZ = e;
                    } else {
                        list = e;
                    }
                    e.previousZ = tail;
                    tail = e;
                }
                p = q;
            }
            tail.nextZ = null;
            inSize *= 2;
        } while (numMerges > 1);
    }

    private static Node filterPoints(Node start, Node end) {
        boolean continueIteration;
        if (start == null) {
            return start;
        }
        if (end == null) {
            end = start;
        }
        Node node = start;
        do {
            continueIteration = false;
            Node nextNode = node.next;
            Node prevNode = node.previous;
            if (!node.isSteiner && XTessellator.isVertexEquals(node, nextNode) || XTessellator.area(prevNode.getX(), prevNode.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY()) == 0.0) {
                XTessellator.removeNode(node);
                node = end = prevNode;
                if (node == nextNode) break;
                continueIteration = true;
                continue;
            }
            node = nextNode;
        } while (continueIteration || node != end);
        return end;
    }

    private static Node insertNode(Polygon polygon, int index, int vertexIndex, Node lastNode) {
        Node node = new Node(polygon, index, vertexIndex);
        if (lastNode == null) {
            node.previous = node;
            node.previousZ = node;
            node.next = node;
            node.nextZ = node;
        } else {
            node.next = lastNode.next;
            node.nextZ = lastNode.next;
            node.previous = lastNode;
            node.previousZ = lastNode;
            lastNode.next.previous = node;
            lastNode.nextZ.previousZ = node;
            lastNode.next = node;
            lastNode.nextZ = node;
        }
        return node;
    }

    private static void removeNode(Node node) {
        node.next.previous = node.previous;
        node.previous.next = node.next;
        if (node.previousZ != null) {
            node.previousZ.nextZ = node.nextZ;
        }
        if (node.nextZ != null) {
            node.nextZ.previousZ = node.previousZ;
        }
    }

    private static boolean isVertexEquals(Node a, Node b) {
        return XTessellator.isVertexEquals(a, b.getX(), b.getY());
    }

    private static boolean isVertexEquals(Node a, double x, double y) {
        return a.getX() == x && a.getY() == y;
    }

    private static double area(double aX, double aY, double bX, double bY, double cX, double cY) {
        return (bY - aY) * (cX - bX) - (bX - aX) * (cY - bY);
    }

    private static boolean pointInEar(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        return (cx - x) * (ay - y) - (ax - x) * (cy - y) >= 0.0 && (ax - x) * (by - y) - (bx - x) * (ay - y) >= 0.0 && (bx - x) * (cy - y) - (cx - x) * (by - y) >= 0.0;
    }

    public static boolean pointInTriangle(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        int a = GeoUtils.orient((double)x, (double)y, (double)ax, (double)ay, (double)bx, (double)by);
        int b = GeoUtils.orient((double)x, (double)y, (double)bx, (double)by, (double)cx, (double)cy);
        if (a == 0 || b == 0 || a < 0 == b < 0) {
            int c = GeoUtils.orient((double)x, (double)y, (double)cx, (double)cy, (double)ax, (double)ay);
            return c == 0 || c < 0 == (b < 0 || a < 0);
        }
        return false;
    }

    public static boolean pointInPolygon(List<Triangle> tessellation, double lat, double lon) {
        for (int i = 0; i < tessellation.size(); ++i) {
            if (!tessellation.get(i).containsPoint(lat, lon)) continue;
            return true;
        }
        return false;
    }

    public static final class Triangle {
        Node[] vertex;

        protected Triangle(Node a, Node b, Node c) {
            this.vertex = new Node[]{a, b, c};
        }

        public int getEncodedX(int vertex) {
            return this.vertex[vertex].x;
        }

        public int getEncodedY(int vertex) {
            return this.vertex[vertex].y;
        }

        public double getLat(int vertex) {
            return this.vertex[vertex].getLat();
        }

        public double getLon(int vertex) {
            return this.vertex[vertex].getLon();
        }

        protected boolean containsPoint(double lat, double lon) {
            return XTessellator.pointInTriangle(lon, lat, this.vertex[0].getLon(), this.vertex[0].getLat(), this.vertex[1].getLon(), this.vertex[1].getLat(), this.vertex[2].getLon(), this.vertex[2].getLat());
        }

        public String toString() {
            String result = this.vertex[0].x + ", " + this.vertex[0].y + " " + this.vertex[1].x + ", " + this.vertex[1].y + " " + this.vertex[2].x + ", " + this.vertex[2].y;
            return result;
        }
    }

    protected static class Node {
        private final int idx;
        private final int vrtxIdx;
        private final Polygon polygon;
        private final int x;
        private final int y;
        private final long morton;
        private Node previous;
        private Node next;
        private Node previousZ;
        private Node nextZ;
        private boolean isSteiner = false;

        protected Node(Polygon polygon, int index, int vertexIndex) {
            this.idx = index;
            this.vrtxIdx = vertexIndex;
            this.polygon = polygon;
            this.y = GeoEncodingUtils.encodeLatitude((double)polygon.getPolyLat(this.vrtxIdx));
            this.x = GeoEncodingUtils.encodeLongitude((double)polygon.getPolyLon(this.vrtxIdx));
            this.morton = BitUtil.interleave((int)(this.x ^ Integer.MIN_VALUE), (int)(this.y ^ Integer.MIN_VALUE));
            this.previous = null;
            this.next = null;
            this.previousZ = null;
            this.nextZ = null;
        }

        protected Node(Node other) {
            this.idx = other.idx;
            this.vrtxIdx = other.vrtxIdx;
            this.polygon = other.polygon;
            this.morton = other.morton;
            this.x = other.x;
            this.y = other.y;
            this.previous = other.previous;
            this.next = other.next;
            this.previousZ = other.previousZ;
            this.nextZ = other.nextZ;
            this.isSteiner = other.isSteiner;
        }

        public final double getX() {
            return this.polygon.getPolyLon(this.vrtxIdx);
        }

        public final double getY() {
            return this.polygon.getPolyLat(this.vrtxIdx);
        }

        public final double getLon() {
            return this.polygon.getPolyLon(this.vrtxIdx);
        }

        public final double getLat() {
            return this.polygon.getPolyLat(this.vrtxIdx);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.previous == null) {
                builder.append("||-");
            } else {
                builder.append(this.previous.idx + " <- ");
            }
            builder.append(this.idx);
            if (this.next == null) {
                builder.append(" -||");
            } else {
                builder.append(" -> " + this.next.idx);
            }
            return builder.toString();
        }
    }

    private static enum State {
        INIT,
        CURE,
        SPLIT;

    }
}

