/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.transport.http.HttpChannel;

public class HttpTransport
extends AbstractTransport {
    private static final Log log = LogFactory.getLog((Class)HttpTransport.class);
    public static final String HTTP_BINDING = "http://www.w3.org/2004/08/wsdl/http";
    public static final String CHUNKING_ENABLED = "urn:xfire:transport:http:chunking-enabled";
    public static final String HTTP_TRANSPORT_NS = "http://schemas.xmlsoap.org/soap/http";
    private static final String URI_PREFIX = "urn:xfire:transport:http:";

    protected Channel createNewChannel(String uri) {
        log.debug((Object)("Creating new channel for uri: " + uri));
        HttpChannel c = new HttpChannel(uri, this);
        c.setEndpoint(new DefaultEndpoint());
        return c;
    }

    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public String getServiceURL(Service service) {
        return "http://localhost/services/" + service.getSimpleName();
    }

    public String getTransportURI(Service service) {
        return HTTP_TRANSPORT_NS;
    }

    public String[] getSupportedBindings() {
        return new String[]{HTTP_BINDING};
    }

    public String[] getKnownUriSchemes() {
        return new String[]{"http://", "https://"};
    }
}

